/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityGeneratorLimitRemover;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderGeneratorLimitRemover
extends TileEntityRenderer<TileEntityGeneratorLimitRemover> {
    private static final ResourceLocation RES = new ResourceLocation("naturesaura", "textures/models/generator_limit_remover_glint.png");
    private final ModelLimitRemoverGlint model = new ModelLimitRemoverGlint();

    public RenderGeneratorLimitRemover(TileEntityRendererDispatcher disp) {
        super(disp);
    }

    public void render(TileEntityGeneratorLimitRemover te, float v, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        TileEntity above = te.func_145831_w().func_175625_s(te.func_174877_v().func_177984_a());
        if (above instanceof TileEntityImpl && ((TileEntityImpl)above).wantsLimitRemover()) {
            this.renderGlint(matrixStack, iRenderTypeBuffer, 1.0, combinedOverlayIn);
            this.renderGlint(matrixStack, iRenderTypeBuffer, 0.0, combinedOverlayIn);
        }
    }

    private void renderGlint(MatrixStack stack, IRenderTypeBuffer buffer, double yOff, int combinedOverlayIn) {
        stack.func_227860_a_();
        int brightness = 0xF000F0;
        float alpha = ((float)Math.sin((double)System.currentTimeMillis() / 800.0) + 1.0f) / 2.0f;
        stack.func_227861_a_((double)-0.001f, yOff + 1.0 + (double)0.001f, (double)1.001f);
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        stack.func_227862_a_(1.002f, 1.002f, 1.002f);
        this.model.func_225598_a_(stack, buffer.getBuffer(this.model.func_228282_a_(RES)), brightness, combinedOverlayIn, 1.0f, 1.0f, 1.0f, alpha);
        stack.func_227865_b_();
    }

    private static class ModelLimitRemoverGlint
    extends Model {
        private final ModelRenderer box = new ModelRenderer((Model)this, 0, 0);

        public ModelLimitRemoverGlint() {
            super(RenderType::func_228644_e_);
            this.box.func_78787_b(64, 64);
            this.box.func_228300_a_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.box.func_228309_a_(matrixStack, iVertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

