/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import com.google.common.primitives.Ints;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;

public class TileEntityFireworkGenerator
extends TileEntityImpl
implements ITickableTileEntity {
    private FireworkRocketEntity trackedEntity;
    private ItemStack trackedItem;
    private int toRelease;
    private int releaseTimer;

    public TileEntityFireworkGenerator() {
        super(ModTileEntities.FIREWORK_GENERATOR);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                List items = this.field_145850_b.func_175647_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(4.0), EntityPredicates.field_94557_a);
                for (ItemEntity item : items) {
                    ItemStack stack;
                    if (item.func_174874_s() || (stack = item.func_92059_d()).func_190926_b() || stack.func_77973_b() != Items.field_196152_dE) continue;
                    if (this.trackedEntity == null && this.releaseTimer <= 0) {
                        FireworkRocketEntity entity;
                        this.trackedEntity = entity = new FireworkRocketEntity(this.field_145850_b, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), stack);
                        this.trackedItem = stack.func_77946_l();
                        this.field_145850_b.func_217376_c((Entity)entity);
                    }
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        item.func_70106_y();
                        continue;
                    }
                    item.func_92058_a(stack);
                }
            }
            if (this.trackedEntity != null && !this.trackedEntity.func_70089_S()) {
                if (this.trackedItem.func_77942_o()) {
                    float generateFactor = 0.0f;
                    HashSet<Integer> usedColors = new HashSet<Integer>();
                    CompoundNBT compound = this.trackedItem.func_77978_p();
                    CompoundNBT fireworks = compound.func_74775_l("Fireworks");
                    int flightTime = fireworks.func_74762_e("Flight");
                    ListNBT explosions = fireworks.func_150295_c("Explosions", 10);
                    if (!explosions.isEmpty()) {
                        generateFactor += (float)flightTime;
                        for (INBT base : explosions) {
                            boolean trail;
                            CompoundNBT explosion = (CompoundNBT)base;
                            generateFactor += 1.5f;
                            boolean flicker = explosion.func_74767_n("Flicker");
                            if (flicker) {
                                generateFactor += 1.0f;
                            }
                            if (trail = explosion.func_74767_n("Trail")) {
                                generateFactor += 8.0f;
                            }
                            byte type = explosion.func_74771_c("Type");
                            generateFactor += (new float[]{0.0f, 1.0f, 0.5f, 20.0f, 0.5f})[type];
                            HashSet<Integer> colors = new HashSet<Integer>();
                            for (int color : explosion.func_74759_k("Colors")) {
                                usedColors.add(color);
                                colors.add(color);
                            }
                            generateFactor += 0.75f * (float)colors.size();
                        }
                    }
                    if (generateFactor > 0.0f) {
                        int toAdd = MathHelper.func_76123_f((float)(generateFactor * 10000.0f));
                        if (this.canGenerateRightNow(35, toAdd)) {
                            this.toRelease = toAdd;
                            this.releaseTimer = 15 * flightTime + 40;
                        }
                        ArrayList<Integer> data = new ArrayList<Integer>();
                        data.add(this.field_174879_c.func_177958_n());
                        data.add(this.field_174879_c.func_177956_o());
                        data.add(this.field_174879_c.func_177952_p());
                        data.addAll(usedColors);
                        PacketHandler.sendToAllLoaded(this.field_145850_b, this.field_174879_c, new PacketParticles((float)this.trackedEntity.func_226277_ct_(), (float)this.trackedEntity.func_226278_cu_(), (float)this.trackedEntity.func_226281_cx_(), PacketParticles.Type.FIREWORK_GEN, Ints.toArray(data)));
                    }
                }
                this.trackedEntity = null;
                this.trackedItem = null;
            }
            if (this.releaseTimer > 0) {
                --this.releaseTimer;
                if (this.releaseTimer <= 0) {
                    while (this.toRelease > 0) {
                        BlockPos spot = IAuraChunk.getLowestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
                        this.toRelease -= IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot).storeAura(spot, this.toRelease);
                    }
                    PacketHandler.sendToAllLoaded(this.field_145850_b, this.field_174879_c, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), PacketParticles.Type.FLOWER_GEN_AURA_CREATION, new int[0]));
                }
            }
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }
}

