/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.forge.clothconfig2.gui.entries.AbstractListListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractTextFieldListListEntry<T, C extends AbstractTextFieldListCell<T, C, SELF>, SELF extends AbstractTextFieldListListEntry<T, C, SELF>>
extends AbstractListListEntry<T, C, SELF> {
    public AbstractTextFieldListListEntry(String fieldName, List<T> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<T>> saveConsumer, Supplier<List<T>> defaultValue, String resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront, BiFunction<T, SELF, C> createNewCell) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, createNewCell);
    }

    public static abstract class AbstractTextFieldListCell<T, SELF extends AbstractTextFieldListCell<T, SELF, OUTER_SELF>, OUTER_SELF extends AbstractTextFieldListListEntry<T, SELF, OUTER_SELF>>
    extends AbstractListListEntry.AbstractListCell<T, SELF, OUTER_SELF> {
        protected TextFieldWidget widget;
        private boolean isSelected;

        public AbstractTextFieldListCell(@Nullable T value, OUTER_SELF listListEntry) {
            super(value, listListEntry);
            T finalValue = this.substituteDefault(value);
            this.widget = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, 100, 18, ""){

                public void render(int mouseX, int mouseY, float delta) {
                    this.setFocused(isSelected);
                    super.render(mouseX, mouseY, delta);
                }
            };
            this.widget.func_200675_a(this::isValidText);
            this.widget.func_146203_f(Integer.MAX_VALUE);
            this.widget.func_146185_a(false);
            this.widget.func_146180_a(Objects.toString(finalValue));
            this.widget.func_212954_a(s -> {
                this.widget.func_146193_g(this.getPreferredTextColor());
                if (listListEntry.getScreen() != null && !Objects.equals(s, Objects.toString(finalValue))) {
                    ((AbstractTextFieldListListEntry)this.listListEntry).getScreen().setEdited(true, ((AbstractTextFieldListListEntry)this.listListEntry).isRequiresRestart());
                }
            });
        }

        @Override
        public void updateSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        @Nullable
        protected abstract T substituteDefault(@Nullable T var1);

        protected abstract boolean isValidText(String var1);

        @Override
        public int getCellHeight() {
            return 20;
        }

        @Override
        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.widget.setWidth(entryWidth - 12);
            this.widget.x = x;
            this.widget.y = y + 1;
            this.widget.func_146184_c(((AbstractTextFieldListListEntry)this.listListEntry).isEditable());
            this.widget.render(mouseX, mouseY, delta);
            if (isSelected && ((AbstractTextFieldListListEntry)this.listListEntry).isEditable()) {
                AbstractTextFieldListCell.fill((int)x, (int)(y + 12), (int)(x + entryWidth - 12), (int)(y + 13), (int)(this.getConfigError().isPresent() ? -43691 : -2039584));
            }
        }

        public List<? extends IGuiEventListener> children() {
            return Collections.singletonList(this.widget);
        }
    }
}

