/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DeferredRegister<T extends IForgeRegistryEntry<T>> {
    private final IForgeRegistry<T> type;
    private final String modid;
    private final Map<RegistryObject<T>, Supplier<? extends T>> entries = new LinkedHashMap<RegistryObject<T>, Supplier<? extends T>>();
    private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());

    public DeferredRegister(IForgeRegistry<T> reg, String modid) {
        this.type = reg;
        this.modid = modid;
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(sup);
        ResourceLocation key = new ResourceLocation(this.modid, name);
        RegistryObject ret = RegistryObject.of(key, this.type);
        if (this.entries.putIfAbsent(ret, () -> (IForgeRegistryEntry)((IForgeRegistryEntry)sup.get()).setRegistryName(key)) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return ret;
    }

    public void register(IEventBus bus) {
        bus.addListener(this::addEntries);
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.entriesView;
    }

    private void addEntries(RegistryEvent.Register<?> event) {
        if (event.getGenericType() == this.type.getRegistrySuperType()) {
            IForgeRegistry<?> reg = event.getRegistry();
            for (Map.Entry<RegistryObject<T>, Supplier<T>> e : this.entries.entrySet()) {
                reg.register((IForgeRegistryEntry)e.getValue().get());
                e.getKey().updateReference(reg);
            }
        }
    }
}

