/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.fast_poi_retrieval;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.Dynamic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import me.jellysquid.mods.lithium.common.poi.IExtendedRegionSectionCache;
import me.jellysquid.mods.lithium.common.util.Collector;
import me.jellysquid.mods.lithium.common.util.ListeningLong2ObjectOpenHashMap;
import net.minecraft.util.IDynamicSerializable;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.storage.RegionSectionCache;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RegionSectionCache.class})
public abstract class MixinRegionSectionCache<R extends IDynamicSerializable>
implements IExtendedRegionSectionCache<R> {
    @Mutable
    @Shadow
    @Final
    private Long2ObjectMap<Optional<R>> field_219121_b;
    private Long2ObjectOpenHashMap<BitSet> columns;

    @Shadow
    protected abstract void func_219107_b(ChunkPos var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(File file_1, BiFunction<Runnable, Dynamic<?>, R> serializer, Function<Runnable, R> factory, DataFixer fixer, DefaultTypeReferences type, CallbackInfo ci) {
        this.columns = new Long2ObjectOpenHashMap();
        this.field_219121_b = new ListeningLong2ObjectOpenHashMap<Optional>(this::onEntryAdded, this::onEntryRemoved);
    }

    private void onEntryRemoved(long key, Optional<R> value) {
    }

    private void onEntryAdded(long key, Optional<R> value) {
        int z;
        int y = SectionPos.func_218144_c((long)key);
        if (y < 0 || y >= 16) {
            return;
        }
        int x = SectionPos.func_218173_b((long)key);
        long pos = ChunkPos.func_77272_a((int)x, (int)(z = SectionPos.func_218153_d((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags == null) {
            flags = new BitSet(16);
            this.columns.put(pos, (Object)flags);
        }
        flags.set(y, value.isPresent());
    }

    @Override
    public Stream<R> getWithinChunkColumn(int chunkX, int chunkZ) {
        BitSet flags = this.getCachedColumnInfo(chunkX, chunkZ);
        if (flags.isEmpty()) {
            return Stream.empty();
        }
        return flags.stream().mapToObj(chunkY -> ((Optional)this.field_219121_b.get(SectionPos.func_218166_b((int)chunkX, (int)chunkY, (int)chunkZ))).orElse(null)).filter(Objects::nonNull);
    }

    @Override
    public boolean collectWithinChunkColumn(int chunkX, int chunkZ, Collector<R> consumer) {
        BitSet flags = this.getCachedColumnInfo(chunkX, chunkZ);
        if (flags.isEmpty()) {
            return true;
        }
        int chunkY = flags.nextSetBit(0);
        while (chunkY >= 0) {
            IDynamicSerializable obj = ((Optional)this.field_219121_b.get(SectionPos.func_218166_b((int)chunkX, (int)chunkY, (int)chunkZ))).orElse(null);
            if (obj != null && !consumer.collect(obj)) {
                return false;
            }
            chunkY = flags.nextSetBit(chunkY + 1);
        }
        return true;
    }

    private BitSet getCachedColumnInfo(int chunkX, int chunkZ) {
        long pos = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
        BitSet flags = this.getColumnInfo(pos, false);
        if (flags != null) {
            return flags;
        }
        this.func_219107_b(new ChunkPos(pos));
        return this.getColumnInfo(pos, true);
    }

    private BitSet getColumnInfo(long pos, boolean required) {
        BitSet set = (BitSet)this.columns.get(pos);
        if (set == null && required) {
            throw new NullPointerException("No data is present for column: " + new ChunkPos(pos));
        }
        return set;
    }
}

