/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapePart;

public class VoxelShapeSimpleCube
extends VoxelShape {
    private static final double EPSILON = 1.0E-7;
    private final double x1;
    private final double y1;
    private final double z1;
    private final double x2;
    private final double y2;
    private final double z2;

    public VoxelShapeSimpleCube(VoxelShapePart voxels, double x1, double y1, double z1, double x2, double y2, double z2) {
        super(voxels);
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    public VoxelShape func_197751_a(double x, double y, double z) {
        return new VoxelShapeSimpleCube(this.field_197768_g, this.x1 + x, this.y1 + y, this.z1 + z, this.x2 + x, this.y2 + y, this.z2 + z);
    }

    public double func_212431_a(AxisRotation cycleDirection, AxisAlignedBB box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(AxisRotation dir, AxisAlignedBB box, double maxDist) {
        switch (dir) {
            case NONE: {
                return this.calculatePenetration(this.x1, this.x2, box.field_72340_a, box.field_72336_d, maxDist);
            }
            case FORWARD: {
                return this.calculatePenetration(this.z1, this.z2, box.field_72339_c, box.field_72334_f, maxDist);
            }
            case BACKWARD: {
                return this.calculatePenetration(this.y1, this.y2, box.field_72338_b, box.field_72337_e, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean intersects(AxisRotation dir, AxisAlignedBB box) {
        switch (dir) {
            case NONE: {
                return VoxelShapeSimpleCube.lessThan(this.y1, box.field_72337_e) && VoxelShapeSimpleCube.lessThan(box.field_72338_b, this.y2) && VoxelShapeSimpleCube.lessThan(this.z1, box.field_72334_f) && VoxelShapeSimpleCube.lessThan(box.field_72339_c, this.z2);
            }
            case FORWARD: {
                return VoxelShapeSimpleCube.lessThan(this.x1, box.field_72336_d) && VoxelShapeSimpleCube.lessThan(box.field_72340_a, this.x2) && VoxelShapeSimpleCube.lessThan(this.y1, box.field_72337_e) && VoxelShapeSimpleCube.lessThan(box.field_72338_b, this.y2);
            }
            case BACKWARD: {
                return VoxelShapeSimpleCube.lessThan(this.z1, box.field_72334_f) && VoxelShapeSimpleCube.lessThan(box.field_72339_c, this.z2) && VoxelShapeSimpleCube.lessThan(this.x1, box.field_72336_d) && VoxelShapeSimpleCube.lessThan(box.field_72340_a, this.x2);
            }
        }
        throw new IllegalArgumentException();
    }

    private double calculatePenetration(double a1, double a2, double b1, double b2, double maxDist) {
        double penetration;
        if (maxDist > 0.0) {
            penetration = a1 - b2;
            if (penetration < -1.0E-7 || maxDist < penetration) {
                return maxDist;
            }
            if (penetration < 1.0E-7) {
                return 0.0;
            }
        } else {
            penetration = a2 - b1;
            if (penetration > 1.0E-7 || maxDist > penetration) {
                return maxDist;
            }
            if (penetration > -1.0E-7) {
                return 0.0;
            }
        }
        return penetration;
    }

    public List<AxisAlignedBB> func_197756_d() {
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{this.func_197752_a()});
    }

    public AxisAlignedBB func_197752_a() {
        return new AxisAlignedBB(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public double func_197762_b(Direction.Axis axis) {
        return axis.func_196051_a(this.x1, this.y1, this.z1);
    }

    public double func_197758_c(Direction.Axis axis) {
        return axis.func_196051_a(this.x2, this.y2, this.z2);
    }

    protected double func_197759_b(Direction.Axis axis, int index) {
        if (index < 0 || index > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        switch (axis) {
            case X: {
                return index == 0 ? this.x1 : this.x2;
            }
            case Y: {
                return index == 0 ? this.y1 : this.y2;
            }
            case Z: {
                return index == 0 ? this.z1 : this.z2;
            }
        }
        throw new IllegalArgumentException();
    }

    protected DoubleList func_197757_a(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return DoubleArrayList.wrap((double[])new double[]{this.x1, this.x2});
            }
            case Y: {
                return DoubleArrayList.wrap((double[])new double[]{this.y1, this.y2});
            }
            case Z: {
                return DoubleArrayList.wrap((double[])new double[]{this.z1, this.z2});
            }
        }
        throw new IllegalArgumentException();
    }

    protected boolean func_211542_b(double x, double y, double z) {
        return x >= this.x1 && x < this.x2 && y >= this.y1 && y < this.y2 && z >= this.z1 && z < this.z2;
    }

    public boolean func_197766_b() {
        return this.x1 + 1.0E-7 > this.x2 || this.y1 + 1.0E-7 > this.y2 || this.z1 + 1.0E-7 > this.z2;
    }

    protected int func_197749_a(Direction.Axis axis, double coord) {
        if (coord < this.func_197762_b(axis)) {
            return -1;
        }
        if (coord >= this.func_197758_c(axis)) {
            return 1;
        }
        return 0;
    }

    private static boolean lessThan(double a, double b) {
        return a + 1.0E-7 < b;
    }
}

