/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.gui.GuiConfig;
import ovh.corail.tombstone.gui.GuiInfo;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpgradePerkServerMessage;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;

@OnlyIn(value=Dist.CLIENT)
public class GuiKnowledge
extends TBScreen {
    private static final ResourceLocation GUI_BAR = new ResourceLocation("minecraft", "textures/gui/bars.png");
    private final ITBCapability cap;
    private final int iconSize = 16;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private int hoveredPerkLevel = 0;
    private final ItemStack stackSkull = new ItemStack((IItemProvider)ModItems.advancement[0]);
    private final ItemStack stackRevive = new ItemStack((IItemProvider)ModItems.advancement[7]);
    private final ItemStack stackAnkh = new ItemStack((IItemProvider)ModItems.advancement[3]);
    private final ItemStack stackDragonBreath = new ItemStack((IItemProvider)Items.field_185157_bK);
    private final double alignmentPos;

    public GuiKnowledge(ITBCapability cap) {
        super(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getTranslation(new Object[0]));
        this.cap = cap;
        for (Perk perk : PerkRegistry.perkRegistry.getValues()) {
            if (Helper.isDisabledPerk(perk, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)) continue;
            this.icons.add(new PerkIcon(perk));
        }
        this.alignmentPos = this.getBarRatio();
    }

    @Override
    public void init() {
        super.init();
        int x = this.guiLeft + 15;
        int y = this.guiTop + 72;
        int i = 0;
        int spaceForIcon = this.icons.size() > 12 ? 22 : 31;
        int maxIconByLine = this.icons.size() > 12 ? 8 : 6;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setPosition(x + caseX * spaceForIcon, y);
            if (caseX == maxIconByLine - 1) {
                y += 30;
            }
            ++i;
        }
        this.addButton((Widget)new TBGuiButton(this.guiLeft + 10, this.guiBottom - 25, 70, 15, I18n.func_135052_a((String)"tombstone.compendium.main.title", (Object[])new Object[0]), pressable -> this.getMinecraft().func_147108_a((Screen)new GuiInfo(null))));
        this.addButton((Widget)new TBGuiButton(this.guiRight - 10 - 70, this.guiBottom - 25, 70, 15, LangKey.BUTTON_CONFIG.getClientTranslation(new Object[0]), pressable -> this.getMinecraft().func_147108_a((Screen)new GuiConfig())));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.hoveredIcon != null) {
            if (mouseButton == 0) {
                int perkLevel = this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk);
                if (perkLevel < this.hoveredIcon.perk.getLevelMax() && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                    return true;
                }
            } else if (mouseButton == 1 && this.getMinecraft().field_71439_g.func_184812_l_() && this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk) > 0) {
                PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        this.renderBackground();
        this.hoveredIcon = this.icons.stream().filter(p -> p.contains(mouseX, mouseY)).findFirst().orElse(null);
        int totalPerkPoints = this.cap.getTotalPerkPoints();
        int usedPerkPoints = this.cap.getUsedPerkPoints((PlayerEntity)this.getMinecraft().field_71439_g);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        RenderSystem.pushMatrix();
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((Object)((Object)this)).getClass();
        this.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 4, -1);
        ((Object)((Object)this)).getClass();
        this.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 6, -1);
        String titleName = LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getClientTranslation(new Object[0]);
        float f = (float)this.halfWidth - (float)this.font.func_78256_a(titleName) / 2.0f;
        float f2 = (float)this.guiTop + 9.0f;
        ((Object)((Object)this)).getClass();
        this.font.func_211126_b(titleName, f, f2, -1);
        ((Object)((Object)this)).getClass();
        this.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 18, -1);
        ((Object)((Object)this)).getClass();
        this.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 20, -1);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().field_71446_o.func_110577_a(GUI_BAR);
        GuiKnowledge.blit((int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)40.0f, (int)182, (int)5, (int)182, (int)256);
        GuiKnowledge.blit((int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)45.0f, (int)((int)(129.22 * (double)(this.cap.getKnowledge() - this.cap.getKnowledgeForLevel(totalPerkPoints)) / (double)this.cap.getKnowledgeToReachNextLevel(totalPerkPoints + 1))), (int)5, (int)182, (int)256);
        GuiKnowledge.blit((int)(this.guiLeft + 52), (int)(this.guiTop + 31), (float)0.0f, (float)101.0f, (int)182, (int)3, (int)182, (int)256);
        int startAlignmentY = 44;
        this.drawCenteredString(this.font, "Alignment", this.halfWidth, this.guiTop + startAlignmentY - 4, -1);
        GuiKnowledge.fill((int)(this.guiLeft + 20), (int)(this.guiTop + startAlignmentY + 10), (int)(this.guiRight - 20), (int)(this.guiTop + startAlignmentY + 17), (int)-16777216);
        Helper.fillGradient(this.guiLeft + 21, this.guiTop + startAlignmentY + 11, this.halfWidth, this.guiTop + startAlignmentY + 16, -65536, -1, this.getBlitOffset(), true);
        Helper.fillGradient(this.halfWidth, this.guiTop + startAlignmentY + 11, this.guiRight - 21, this.guiTop + startAlignmentY + 16, -1, -16776961, this.getBlitOffset(), true);
        float step = (float)(this.xSize - 42) / 8.0f;
        for (int i = 0; i < 8; ++i) {
            if (i == 4) continue;
            this.vLine(this.guiLeft + 21 + (int)((float)i * step), this.guiTop + startAlignmentY + 10, this.guiTop + startAlignmentY + 16, -16777216);
        }
        this.itemRenderer.func_180450_b(this.stackSkull, this.guiLeft + 10, this.guiTop + startAlignmentY + 5);
        this.itemRenderer.func_180450_b(this.stackRevive, this.guiRight - 10 - 16, this.guiTop + startAlignmentY + 5);
        int adjust = (int)((double)(this.xSize - 42) / 2.0 * this.alignmentPos);
        this.itemRenderer.func_180450_b(this.stackAnkh, this.halfWidth + adjust - 8, this.guiTop + startAlignmentY + 4);
        String levelString = this.leftPerkPoints + " / " + totalPerkPoints;
        float f3 = this.guiLeft + 48 - this.font.func_78256_a(levelString);
        float f4 = this.guiTop + 28;
        ((Object)((Object)this)).getClass();
        this.font.func_211126_b(levelString, f3, f4, -1);
        for (PerkIcon icon : this.icons) {
            this.drawPerk(icon);
        }
        if (Helper.isContributor((PlayerEntity)this.getMinecraft().field_71439_g)) {
            float f5 = this.guiLeft + 30;
            float f6 = this.guiBottom - 45;
            ((Object)((Object)this)).getClass();
            this.font.func_211126_b("Contributor", f5, f6, 8858573);
        }
        if (Helper.isDateAroundHalloween()) {
            String halloweenString = "Halloween";
            float f7 = this.guiRight - 30 - this.font.func_78256_a(halloweenString);
            float f8 = this.guiBottom - 45;
            ((Object)((Object)this)).getClass();
            this.font.func_211126_b(halloweenString, f7, f8, 8858573);
        }
        super.render(mouseX, mouseY, partialTick);
        this.drawPerkTooltip();
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
        RenderSystem.popMatrix();
    }

    private double getBarRatio() {
        boolean isPositive = this.cap.getAlignmentValue() >= 0;
        int alignement = Math.abs(MathHelper.func_76125_a((int)this.cap.getAlignmentValue(), (int)this.cap.getAlignmentMinValue(), (int)this.cap.getAlignmentMaxValue()));
        double ratio = alignement > 300 ? 0.75 + 0.25 * (double)(alignement - 300) * 0.02 : (alignement > 150 ? 0.5 + 0.25 * (double)(alignement - 150) * 0.015 : (alignement > 50 ? 0.25 + 0.25 * (double)(alignement - 50) * 0.01 : 0.25 * (double)alignement * 0.005));
        return isPositive ? ratio : -ratio;
    }

    private void drawPerk(PerkIcon icon) {
        int n;
        int levelWithBonus = this.cap.getPerkLevelWithBonus((PlayerEntity)this.getMinecraft().field_71439_g, icon.perk);
        boolean isHovered = icon == this.hoveredIcon;
        boolean isMax = this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, icon.perk) == icon.perk.getLevelMax();
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiKnowledge.fill((int)(icon.getMinX() - 1), (int)(icon.getMinY() - 1), (int)(icon.getMaxX() + 1), (int)(icon.getMaxY() + 1 + 10), (int)-15329733);
        if (isHovered) {
            int n2;
            if (isMax) {
                ((Object)((Object)this)).getClass();
                n2 = -1980292;
            } else {
                n2 = -7096363;
            }
            int color = n2;
            this.hLine(icon.minX - 2, icon.maxX + 1, icon.minY - 2, color);
            this.hLine(icon.minX - 2, icon.maxX + 1, icon.minY + 27, color);
            this.vLine(icon.minX - 2, icon.minY - 2, icon.minY + 27, color);
            this.vLine(icon.minX + 17, icon.minY - 2, icon.minY + 27, color);
        }
        if (levelWithBonus == 0 && !isHovered) {
            this.fillGradient(icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -13421773, -13421773);
            RenderSystem.color4f((float)0.13f, (float)0.13f, (float)0.13f, (float)0.5f);
        } else {
            this.fillGradient(icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -16703669, -7096363);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (icon.perk != ModPerks.alchemist) {
            ResourceLocation texture = icon.perk.getIcon();
            if (texture != null) {
                this.getMinecraft().func_110434_K().func_110577_a(texture);
                GuiKnowledge.blit((int)icon.getMinX(), (int)icon.getMinY(), (float)0.0f, (float)0.0f, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize);
            }
        } else {
            this.itemRenderer.func_180450_b(this.stackDragonBreath, icon.getMinX(), icon.getMinY());
        }
        boolean hasBonus = icon.perk.getLevelBonus((PlayerEntity)this.getMinecraft().field_71439_g) != 0;
        String string = "" + levelWithBonus;
        float f = (float)icon.getMinX() + (levelWithBonus > 9 ? 2.5f : 5.5f);
        float f2 = icon.getMinY() + 18;
        if (hasBonus) {
            ((Object)((Object)this)).getClass();
            n = 8858573;
        } else if (isMax) {
            ((Object)((Object)this)).getClass();
            n = -1980292;
        } else if (levelWithBonus > 0) {
            ((Object)((Object)this)).getClass();
            n = -12562177;
        } else {
            ((Object)((Object)this)).getClass();
            n = -8355712;
        }
        this.font.func_211126_b(string, f, f2, n);
        RenderSystem.popMatrix();
    }

    private void drawPerkTooltip() {
        if (this.hoveredIcon != null) {
            this.hoveredPerkLevel = this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk);
            int levelWithBonus = this.cap.getPerkLevelWithBonus((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk);
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.hoveredIcon.perk.getClientTranslation());
            String specialInfo = this.hoveredIcon.perk.getSpecialInfo(levelWithBonus);
            if (!specialInfo.isEmpty()) {
                list.add(specialInfo);
            }
            IntStream.rangeClosed(1, this.hoveredIcon.perk.getLevelMax()).forEach(i -> {
                String info = this.hoveredIcon.perk.getTooltip(i, this.hoveredPerkLevel, levelWithBonus);
                if (!info.isEmpty()) {
                    list.add((this.hoveredPerkLevel >= i ? TextFormatting.WHITE : ((this.hoveredIcon.perk.isEncrypted() ? levelWithBonus >= i : levelWithBonus == i) ? TextFormatting.DARK_PURPLE : TextFormatting.DARK_GRAY)).toString() + i + " -> " + LangKey.getClientTranslation(info, new Object[0]));
                }
            });
            if (this.hoveredPerkLevel < this.hoveredIcon.perk.getLevelMax()) {
                int cost = this.hoveredIcon.perk.getCost(this.hoveredPerkLevel + 1);
                boolean canUpgrade = this.leftPerkPoints >= cost;
                list.add((canUpgrade ? TextFormatting.AQUA : TextFormatting.RED) + LangKey.MESSAGE_COST.getClientTranslation(cost));
                list.add(canUpgrade ? TextFormatting.BLUE + LangKey.MESSAGE_CLICK_TO_UPGRADE.getClientTranslation(new Object[0]) : TextFormatting.RED + LangKey.MESSAGE_CANT_UPGRADE.getClientTranslation(new Object[0]));
            } else {
                list.add(TextFormatting.GOLD + LangKey.MESSAGE_MAX.getClientTranslation(new Object[0]));
            }
            this.drawHoveringText(list, this.hoveredIcon.minX + 10, this.hoveredIcon.minY + 10, this.font);
        }
    }

    private void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        int maxTextWidth = 200;
        if (!textLines.isEmpty()) {
            RenderSystem.disableRescaleNormal();
            RenderHelper.func_74518_a();
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = x + 12;
            if (tooltipX + tooltipTextWidth + 4 > this.width && (tooltipX = x - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = x > this.width / 2 ? x - 12 - 8 : this.width - 16 - x;
                needsWrap = true;
            }
            if (tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = x > this.width / 2 ? x - 16 - tooltipTextWidth : x + 12;
            }
            int tooltipY = y - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > this.height) {
                tooltipY = this.height - tooltipHeight - 4;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            int borderColorStart = 0x505000FF;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            Helper.fillGradient(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor, 300, false);
            Helper.fillGradient(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor, 300, false);
            Helper.fillGradient(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor, 300, false);
            Helper.fillGradient(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor, 300, false);
            Helper.fillGradient(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor, 300, false);
            Helper.fillGradient(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd, 300, false);
            Helper.fillGradient(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd, 300, false);
            Helper.fillGradient(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart, 300, false);
            Helper.fillGradient(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd, 300, false);
            int perkLine = 0;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                boolean isPerkLine;
                String line = textLines.get(lineNumber);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String[] splits = line.split(" -> ");
                boolean bl = isPerkLine = splits.length > 1;
                if (isPerkLine && this.hoveredIcon.perk.isEncrypted() && perkLine > this.cap.getPerkLevelWithBonus((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk)) {
                    String subString = splits[0] + " -> ";
                    font.func_211126_b(subString, (float)tooltipX, (float)tooltipY, -1980292);
                    FontRenderer standardGalacticFontRenderer = this.getMinecraft().func_211500_ak().func_211504_a(Minecraft.field_71464_q);
                    if (standardGalacticFontRenderer != null) {
                        standardGalacticFontRenderer.func_211126_b(TextFormatting.DARK_GRAY + splits[1], (float)(tooltipX + font.func_78256_a(subString)), (float)tooltipY, -1980292);
                    }
                } else {
                    font.func_211126_b(line, (float)tooltipX, (float)tooltipY, -1980292);
                }
                if (isPerkLine) {
                    ++perkLine;
                }
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
        }
    }

    public class PerkIcon {
        public final Perk perk;
        int minX;
        int minY;
        int maxX;
        int maxY;

        PerkIcon(Perk perk) {
            this.perk = perk;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        boolean contains(double x, double y) {
            return x >= (double)this.minX && y >= (double)this.minY && x <= (double)this.maxX && y <= (double)(this.maxY + 10);
        }

        int getMinX() {
            return this.minX;
        }

        int getMinY() {
            return this.minY;
        }

        int getMaxX() {
            return this.maxX;
        }

        int getMaxY() {
            return this.maxY;
        }
    }
}

