/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.IMekWrench;
import mekanism.api.Upgrade;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.GenericWrench;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.GasTankTier;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Contract;

public final class MekanismUtils {
    public static final float ONE_OVER_ROOT_TWO = (float)(1.0 / Math.sqrt(2.0));
    public static final Direction[] SIDE_DIRS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final List<UUID> warnedFails = new ArrayList<UUID>();

    public static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            Mekanism.logger.error("Stack size changed by a different amount (" + actual + ") than requested (" + expected + ").", (Throwable)new Exception());
        }
    }

    public static void logExpectedZero(FloatingLong actual) {
        if (!actual.isZero()) {
            Mekanism.logger.error("Energy value changed by a different amount (" + actual + ") than requested (zero).", (Throwable)new Exception());
        }
    }

    public static ItemStack getEmptyGasTank(GasTankTier tier) {
        switch (tier) {
            case BASIC: {
                return MekanismBlocks.BASIC_GAS_TANK.getItemStack();
            }
            case ADVANCED: {
                return MekanismBlocks.ADVANCED_GAS_TANK.getItemStack();
            }
            case ELITE: {
                return MekanismBlocks.ELITE_GAS_TANK.getItemStack();
            }
            case ULTIMATE: {
                return MekanismBlocks.ULTIMATE_GAS_TANK.getItemStack();
            }
            case CREATIVE: {
                return MekanismBlocks.CREATIVE_GAS_TANK.getItemStack();
            }
        }
        return ItemStack.field_190927_a;
    }

    public static <T> Optional<T> toOptional(@Nonnull LazyOptional<T> lazyOptional) {
        if (lazyOptional.isPresent()) {
            return Optional.of(lazyOptional.orElseThrow(() -> new RuntimeException("Failed to retrieve value of lazy optional when it claimed it was present.")));
        }
        return Optional.empty();
    }

    public static boolean isActive(IBlockReader world, BlockPos pos) {
        TileEntity tile = MekanismUtils.getTileEntity(world, pos);
        if (tile instanceof IActiveState) {
            return ((IActiveState)tile).getActive();
        }
        return false;
    }

    public static Direction getLeft(Direction orientation) {
        return orientation.func_176746_e();
    }

    public static Direction getRight(Direction orientation) {
        return orientation.func_176735_f();
    }

    public static float fractionUpgrades(IUpgradeTile mgmt, Upgrade type) {
        if (mgmt.supportsUpgrades()) {
            return (float)mgmt.getComponent().getUpgrades(type) / (float)type.getMax();
        }
        return 0.0f;
    }

    public static float getScale(float prevScale, IExtendedFluidTank tank) {
        return MekanismUtils.getScale(prevScale, tank.getFluidAmount(), tank.getCapacity(), tank.isEmpty());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> float getScale(float prevScale, IChemicalTank<CHEMICAL, STACK> tank) {
        return MekanismUtils.getScale(prevScale, tank.getStored(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(float prevScale, int stored, int capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0 ? 0.0f : (float)stored / (float)capacity, empty);
    }

    public static float getScale(float prevScale, long stored, long capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0L ? 0.0f : (float)((double)stored / (double)capacity), empty);
    }

    public static float getScale(float prevScale, IEnergyContainer container) {
        float targetScale;
        FloatingLong maxEnergy = container.getMaxEnergy();
        if (maxEnergy.isZero()) {
            targetScale = 0.0f;
        } else {
            FloatingLong scale = container.getEnergy().divide(maxEnergy);
            targetScale = scale.floatValue();
        }
        return MekanismUtils.getScale(prevScale, targetScale, container.isEmpty());
    }

    public static float getScale(float prevScale, float targetScale, boolean empty) {
        if ((double)Math.abs(prevScale - targetScale) > 0.01) {
            return (9.0f * prevScale + targetScale) / 10.0f;
        }
        if (!empty && prevScale == 0.0f) {
            return targetScale;
        }
        return prevScale;
    }

    public static int getTicks(IUpgradeTile mgmt, int def) {
        if (mgmt.supportsUpgrades()) {
            return (int)((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), -MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED)));
        }
        return def;
    }

    public static FloatingLong getEnergyPerTick(IUpgradeTile mgmt, FloatingLong def) {
        if (mgmt.supportsUpgrades()) {
            return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0f * MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(mgmt, Upgrade.ENERGY)));
        }
        return def;
    }

    public static double getGasPerTickMean(IUpgradeTile mgmt, long def) {
        if (mgmt.supportsUpgrades()) {
            if (mgmt.getComponent().supports(Upgrade.GAS)) {
                return (double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0f * MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(mgmt, Upgrade.GAS));
            }
            return (double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED));
        }
        return def;
    }

    public static FloatingLong getMaxEnergy(IUpgradeTile mgmt, FloatingLong def) {
        if (mgmt.supportsUpgrades()) {
            return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(mgmt, Upgrade.ENERGY)));
        }
        return def;
    }

    public static FloatingLong getMaxEnergy(ItemStack itemStack, FloatingLong def) {
        Map<Upgrade, Integer> upgrades;
        float numUpgrades = 0.0f;
        if (ItemDataUtils.hasData(itemStack, "upgrades", 9) && (upgrades = Upgrade.buildMap(ItemDataUtils.getDataMap(itemStack))).containsKey(Upgrade.ENERGY)) {
            numUpgrades = upgrades.get(Upgrade.ENERGY).intValue();
        }
        return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), numUpgrades / (float)Upgrade.ENERGY.getMax()));
    }

    public static boolean isGettingPowered(World world, BlockPos pos) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            BlockPos offset = pos.func_177972_a(side);
            if (!MekanismUtils.isBlockLoaded((IBlockReader)world, pos) || !MekanismUtils.isBlockLoaded((IBlockReader)world, offset)) continue;
            BlockState blockState = world.func_180495_p(offset);
            boolean weakPower = blockState.func_177230_c().shouldCheckWeakPower(blockState, (IWorldReader)world, pos, side);
            if (weakPower && MekanismUtils.isDirectlyGettingPowered(world, offset)) {
                return true;
            }
            if (weakPower || blockState.func_185911_a((IBlockReader)world, offset, side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectlyGettingPowered(World world, BlockPos pos) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            BlockPos offset = pos.func_177972_a(side);
            if (!MekanismUtils.isBlockLoaded((IBlockReader)world, offset) || world.func_175651_c(pos, side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidReplaceableBlock(@Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return World.func_175701_a((BlockPos)pos) && world.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    public static void notifyLoadedNeighborsOfTileChange(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        for (Direction dir : EnumUtils.DIRECTIONS) {
            Block block1;
            BlockPos offset = pos.func_177972_a(dir);
            if (!MekanismUtils.isBlockLoaded((IBlockReader)world, offset)) continue;
            MekanismUtils.notifyNeighborofChange(world, offset, pos);
            if (!world.func_180495_p(offset).func_215686_e((IBlockReader)world, offset) || !MekanismUtils.isBlockLoaded((IBlockReader)world, offset = offset.func_177972_a(dir)) || !(block1 = world.func_180495_p(offset).func_177230_c()).getWeakChanges(state, (IWorldReader)world, offset)) continue;
            block1.onNeighborChange(state, (IWorldReader)world, offset, pos);
        }
    }

    public static void notifyNeighborofChange(World world, BlockPos pos, BlockPos fromPos) {
        BlockState state = world.func_180495_p(pos);
        state.func_177230_c().onNeighborChange(state, (IWorldReader)world, pos, fromPos);
        state.func_215697_a(world, pos, world.func_180495_p(fromPos).func_177230_c(), fromPos, false);
    }

    public static void notifyNeighborOfChange(World world, Direction neighborSide, BlockPos fromPos) {
        BlockPos neighbor = fromPos.func_177972_a(neighborSide);
        BlockState state = world.func_180495_p(neighbor);
        state.func_177230_c().onNeighborChange(state, (IWorldReader)world, neighbor, fromPos);
        state.func_215697_a(world, neighbor, world.func_180495_p(fromPos).func_177230_c(), fromPos, false);
    }

    public static void makeBoundingBlock(@Nullable IWorld world, BlockPos boundingLocation, BlockPos orig) {
        if (world == null) {
            return;
        }
        BlockBounding boundingBlock = MekanismBlocks.BOUNDING_BLOCK.getBlock();
        BlockState newState = BlockStateHelper.getStateForPlacement(boundingBlock, boundingBlock.func_176223_P(), world, boundingLocation, null, Direction.NORTH);
        world.func_180501_a(boundingLocation, newState, 3);
        if (!world.func_201670_d()) {
            TileEntityBoundingBlock tile = MekanismUtils.getTileEntity(TileEntityBoundingBlock.class, (IBlockReader)world, boundingLocation);
            if (tile != null) {
                tile.setMainLocation(orig);
            } else {
                Mekanism.logger.warn("Unable to find Bounding Block Tile at: {}", (Object)boundingLocation);
            }
        }
    }

    public static void makeAdvancedBoundingBlock(IWorld world, BlockPos boundingLocation, BlockPos orig) {
        BlockBounding boundingBlock = MekanismBlocks.ADVANCED_BOUNDING_BLOCK.getBlock();
        BlockState newState = BlockStateHelper.getStateForPlacement(boundingBlock, boundingBlock.func_176223_P(), world, boundingLocation, null, Direction.NORTH);
        world.func_180501_a(boundingLocation, newState, 3);
        if (!world.func_201670_d()) {
            TileEntityAdvancedBoundingBlock tile = MekanismUtils.getTileEntity(TileEntityAdvancedBoundingBlock.class, (IBlockReader)world, boundingLocation);
            if (tile != null) {
                tile.setMainLocation(orig);
            } else {
                Mekanism.logger.warn("Unable to find Advanced Bounding Block Tile at: {}", (Object)boundingLocation);
            }
        }
    }

    public static void updateBlock(@Nullable World world, BlockPos pos) {
        if (!MekanismUtils.isBlockLoaded((IBlockReader)world, pos)) {
            return;
        }
        BlockState blockState = world.func_180495_p(pos);
        world.func_225319_b(pos, Blocks.field_150350_a.func_176223_P(), blockState);
        TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, pos);
        if (!(tile instanceof IActiveState) || ((IActiveState)tile).lightUpdate() && MekanismConfig.client.machineEffects.get()) {
            MekanismUtils.recheckLighting((ILightReader)world, pos);
        }
    }

    public static void recheckLighting(@Nonnull ILightReader world, @Nonnull BlockPos pos) {
        world.func_225524_e_().func_215568_a(pos);
    }

    public static boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World world, BlockPos pos, @Nonnull FluidStack fluidStack, @Nullable Direction side) {
        boolean canContainFluid;
        Fluid fluid = fluidStack.getFluid();
        if (!fluid.getAttributes().canBePlacedInWorld((ILightReader)world, pos, fluidStack)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        boolean isReplaceable = state.func_227032_a_(fluid);
        boolean bl = canContainFluid = state.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)state.func_177230_c()).func_204510_a((IBlockReader)world, pos, state, fluid);
        if (world.func_175623_d(pos) || isReplaceable || canContainFluid) {
            if (world.func_201675_m().func_177500_n() && fluid.getAttributes().doesVaporize((ILightReader)world, pos, fluidStack)) {
                fluid.getAttributes().vaporize(player, world, pos, fluidStack);
            } else if (canContainFluid) {
                if (((ILiquidContainer)state.func_177230_c()).func_204509_a((IWorld)world, pos, state, ((FlowingFluid)fluid).func_207204_a(false))) {
                    MekanismUtils.playEmptySound(player, (IWorld)world, pos, fluidStack);
                }
            } else {
                if (!world.func_201670_d() && isReplaceable && !state.func_185904_a().func_76224_d()) {
                    world.func_175655_b(pos, true);
                }
                MekanismUtils.playEmptySound(player, (IWorld)world, pos, fluidStack);
                world.func_180501_a(pos, fluid.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return side != null && MekanismUtils.tryPlaceContainedLiquid(player, world, pos.func_177972_a(side), fluidStack, null);
    }

    private static void playEmptySound(@Nullable PlayerEntity player, IWorld world, BlockPos pos, @Nonnull FluidStack fluidStack) {
        SoundEvent soundevent = fluidStack.getFluid().getAttributes().getEmptySound((ILightReader)world, pos);
        if (soundevent == null) {
            soundevent = fluidStack.getFluid().func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        world.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static ResourceLocation getResource(ResourceType type, String name) {
        return Mekanism.rl(type.getPrefix() + name);
    }

    public static void saveChunk(TileEntity tile) {
        if (tile == null || tile.func_145837_r() || tile.func_145831_w() == null) {
            return;
        }
        tile.func_145831_w().func_175646_b(tile.func_174877_v(), tile);
    }

    public static boolean canFunction(TileEntity tile) {
        if (!(tile instanceof IRedstoneControl)) {
            return true;
        }
        IRedstoneControl control = (IRedstoneControl)tile;
        switch (control.getControlType()) {
            case DISABLED: {
                return true;
            }
            case HIGH: {
                return control.isPowered();
            }
            case LOW: {
                return !control.isPowered();
            }
            case PULSE: {
                return control.isPowered() && !control.wasPowered();
            }
        }
        return false;
    }

    public static BlockRayTraceResult rayTrace(PlayerEntity player) {
        double reach = Mekanism.proxy.getReach(player);
        Vec3d headVec = MekanismUtils.getHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return player.func_130014_f_().func_217299_a(new RayTraceContext(headVec, endVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    private static Vec3d getHeadVec(PlayerEntity player) {
        double posY = player.func_226278_cu_() + (double)player.func_70047_e();
        if (player.func_213453_ef()) {
            posY -= 0.08;
        }
        return new Vec3d(player.func_226277_ct_(), posY, player.func_226281_cx_());
    }

    public static ITextComponent getEnergyDisplayShort(FloatingLong energy) {
        switch ((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()) {
            case J: {
                return UnitDisplayUtils.getDisplayShort(energy, UnitDisplayUtils.ElectricUnit.JOULES);
            }
            case FE: {
                return UnitDisplayUtils.getDisplayShort(EnergyCompatUtils.EnergyType.FORGE.convertToAsFloatingLong(energy), UnitDisplayUtils.ElectricUnit.FORGE_ENERGY);
            }
            case EU: {
                return UnitDisplayUtils.getDisplayShort(EnergyCompatUtils.EnergyType.EU.convertToAsFloatingLong(energy), UnitDisplayUtils.ElectricUnit.ELECTRICAL_UNITS);
            }
        }
        return MekanismLang.ERROR.translate(new Object[0]);
    }

    public static FloatingLong convertToJoules(FloatingLong energy) {
        switch ((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()) {
            case FE: {
                return EnergyCompatUtils.EnergyType.FORGE.convertFrom(energy);
            }
            case EU: {
                return EnergyCompatUtils.EnergyType.EU.convertFrom(energy);
            }
        }
        return energy;
    }

    public static FloatingLong convertToDisplay(FloatingLong energy) {
        switch ((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()) {
            case FE: {
                return EnergyCompatUtils.EnergyType.FORGE.convertToAsFloatingLong(energy);
            }
            case EU: {
                return EnergyCompatUtils.EnergyType.EU.convertToAsFloatingLong(energy);
            }
        }
        return energy;
    }

    public static ITextComponent getTemperatureDisplay(double T, UnitDisplayUtils.TemperatureUnit unit, boolean shift) {
        double TK = unit.convertToK(T, true);
        switch ((UnitDisplayUtils.TempType)MekanismConfig.general.tempUnit.get()) {
            case K: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.KELVIN, shift);
            }
            case C: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.CELSIUS, shift);
            }
            case R: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.RANKINE, shift);
            }
            case F: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.FAHRENHEIT, shift);
            }
            case STP: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.AMBIENT, shift);
            }
        }
        return MekanismLang.ERROR.translate(new Object[0]);
    }

    public static String getCoordDisplay(BlockPos pos) {
        return "[" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "]";
    }

    public static ItemStack getFullGasTank(GasTankTier tier, @Nonnull Gas gas) {
        return GasUtils.getFilledVariant(MekanismUtils.getEmptyGasTank(tier), tier.getStorage(), gas);
    }

    public static CraftingInventory getDummyCraftingInv() {
        Container tempContainer = new Container(ContainerType.field_221518_l, 1){

            public boolean func_75145_c(@Nonnull PlayerEntity player) {
                return false;
            }
        };
        return new CraftingInventory(tempContainer, 3, 3);
    }

    public static ItemStack findRepairRecipe(CraftingInventory inv, World world) {
        NonNullList dmgItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        ItemStack leftStack = (ItemStack)dmgItems.get(0);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            if (leftStack.func_190926_b()) {
                leftStack = inv.func_70301_a(i);
                dmgItems.set(0, (Object)leftStack);
                continue;
            }
            dmgItems.set(1, (Object)inv.func_70301_a(i));
            break;
        }
        if (leftStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack rightStack = (ItemStack)dmgItems.get(1);
        if (!rightStack.func_190926_b() && leftStack.func_77973_b() == rightStack.func_77973_b() && leftStack.func_190916_E() == 1 && rightStack.func_190916_E() == 1 && leftStack.func_77973_b().isRepairable(leftStack)) {
            Item theItem = leftStack.func_77973_b();
            int dmgDiff0 = theItem.getMaxDamage(leftStack) - leftStack.func_77952_i();
            int dmgDiff1 = theItem.getMaxDamage(leftStack) - rightStack.func_77952_i();
            int value = dmgDiff0 + dmgDiff1 + theItem.getMaxDamage(leftStack) * 5 / 100;
            int solve = Math.max(0, theItem.getMaxDamage(leftStack) - value);
            ItemStack repaired = new ItemStack((IItemProvider)leftStack.func_77973_b());
            repaired.func_196085_b(solve);
            return repaired;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isChunkVibrated(ChunkPos chunk, DimensionType dimension) {
        return Mekanism.activeVibrators.stream().anyMatch(coord -> coord.dimension == dimension && coord.x >> 4 == chunk.field_77276_a && coord.z >> 4 == chunk.field_77275_b);
    }

    public static boolean isOp(PlayerEntity p) {
        if (p instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)p;
            return MekanismConfig.general.opsBypassRestrictions.get() && player.field_71133_b.func_184103_al().func_152596_g(player.func_146103_bH());
        }
        return false;
    }

    @Nullable
    public static IMekWrench getWrench(ItemStack it) {
        Item item = it.func_77973_b();
        if (item instanceof IMekWrench) {
            return (IMekWrench)item;
        }
        if (item.func_206844_a(MekanismTags.Items.WRENCHES)) {
            return GenericWrench.INSTANCE;
        }
        return null;
    }

    @Nonnull
    public static String getLastKnownUsername(UUID uuid) {
        GameProfile gp;
        String ret = UsernameCache.getLastKnownUsername((UUID)uuid);
        if (ret == null && !warnedFails.contains(uuid) && EffectiveSide.get().isServer() && (gp = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152652_a(uuid)) != null) {
            ret = gp.getName();
        }
        if (ret == null && !warnedFails.contains(uuid)) {
            Mekanism.logger.warn("Failed to retrieve username for UUID {}, you might want to add it to the JSON cache", (Object)uuid);
            warnedFails.add(uuid);
        }
        return ret != null ? ret : "<???>";
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static TileEntity getTileEntity(@Nullable IWorld world, @Nonnull Long2ObjectMap<IChunk> chunkMap, @Nonnull Coord4D coord) {
        return MekanismUtils.getTileEntity(world, chunkMap, coord.getPos());
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static TileEntity getTileEntity(@Nullable IWorld world, @Nonnull Long2ObjectMap<IChunk> chunkMap, @Nonnull BlockPos pos) {
        int chunkZ;
        if (world == null) {
            return null;
        }
        int chunkX = pos.func_177958_n() >> 4;
        long combinedChunk = (long)chunkX << 32 | (long)(chunkZ = pos.func_177952_p() >> 4) & 0xFFFFFFFFL;
        IChunk chunk = (IChunk)chunkMap.get(combinedChunk);
        if (chunk == null && (chunk = world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, false)) != null) {
            chunkMap.put(combinedChunk, (Object)chunk);
        }
        return MekanismUtils.getTileEntity((IBlockReader)chunk, pos);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static TileEntity getTileEntity(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (!MekanismUtils.isBlockLoaded(world, pos)) {
            return null;
        }
        return world.func_175625_s(pos);
    }

    @Nullable
    @Contract(value="_, null, _ -> null")
    public static <T extends TileEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable IBlockReader world, @Nonnull BlockPos pos) {
        return MekanismUtils.getTileEntity(clazz, world, pos, false);
    }

    @Nullable
    @Contract(value="_, null, _, _ -> null")
    public static <T extends TileEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable IBlockReader world, @Nonnull BlockPos pos, boolean logWrongType) {
        if (!MekanismUtils.isBlockLoaded(world, pos)) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        if (clazz.isInstance(tile)) {
            return (T)((TileEntity)clazz.cast(tile));
        }
        if (logWrongType) {
            Mekanism.logger.warn("Unexpected TileEntity class at {}, expected {}, but found: {}", (Object)pos, clazz, tile.getClass());
        }
        return null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isBlockLoaded(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof World) {
            return ((World)world).func_195588_v(pos);
        }
        if (world instanceof IWorldReader) {
            return ((IWorldReader)world).func_175667_e(pos);
        }
        return true;
    }

    public static void dismantleBlock(BlockState state, World world, BlockPos pos) {
        MekanismUtils.dismantleBlock(state, world, pos, MekanismUtils.getTileEntity((IBlockReader)world, pos));
    }

    public static void dismantleBlock(BlockState state, World world, BlockPos pos, TileEntity tile) {
        Block.func_220059_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)tile);
        world.func_217377_a(pos, false);
    }

    public static void onChangedPotionEffect(LivingEntity entity, EffectInstance id, boolean reapply) {
        entity.field_70752_e = true;
        if (reapply && !entity.field_70170_p.field_72995_K) {
            Effect effect = id.func_188419_a();
            effect.func_111187_a(entity, entity.func_110140_aT(), id.func_76458_c());
            effect.func_111185_a(entity, entity.func_110140_aT(), id.func_76458_c());
        }
    }

    @SafeVarargs
    public static ActionResultType performActions(ActionResultType firstAction, Supplier<ActionResultType> ... secondaryActions) {
        if (firstAction == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        ActionResultType result = firstAction;
        boolean hasFailed = result == ActionResultType.FAIL;
        for (Supplier<ActionResultType> secondaryAction : secondaryActions) {
            result = secondaryAction.get();
            if (result == ActionResultType.SUCCESS) {
                return ActionResultType.SUCCESS;
            }
            hasFailed &= result == ActionResultType.FAIL;
        }
        if (hasFailed) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public static int redstoneLevelFromContents(double amount, double capacity) {
        double fractionFull = capacity == 0.0 ? 0.0 : amount / capacity;
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    public static int redstoneLevelFromContents(FloatingLong amount, FloatingLong capacity) {
        if (capacity.isZero() || amount.isZero()) {
            return 0;
        }
        return 1 + amount.divide(capacity).multiply(14L).intValue();
    }

    public static enum ResourceType {
        GUI("gui"),
        GUI_BUTTON("gui/button"),
        GUI_BAR("gui/bar"),
        GUI_GAUGE("gui/gauge"),
        GUI_PROGRESS("gui/progress"),
        GUI_SLOT("gui/slot"),
        SOUND("sound"),
        RENDER("render"),
        TEXTURE_BLOCKS("textures/block"),
        TEXTURE_ITEMS("textures/item"),
        MODEL("models"),
        INFUSE("infuse");

        private String prefix;

        private ResourceType(String s) {
            this.prefix = s;
        }

        public String getPrefix() {
            return this.prefix + "/";
        }
    }
}

