/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.distribution.target.EnergyAcceptorTarget;
import mekanism.common.distribution.target.EnergyTransmitterSaveTarget;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EnergyNetwork
extends DynamicNetwork<IStrictEnergyHandler, EnergyNetwork, FloatingLong>
implements IMekanismStrictEnergyHandler {
    private final List<IEnergyContainer> energyContainers;
    public final VariableCapacityEnergyContainer energyContainer;
    public float energyScale;
    private FloatingLong prevTransferAmount = FloatingLong.ZERO;
    private FloatingLong floatingLongCapacity = FloatingLong.ZERO;

    public EnergyNetwork() {
        this.energyContainer = VariableCapacityEnergyContainer.create(this::getCapacityAsFloatingLong, BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.alwaysTrue, (IMekanismStrictEnergyHandler)this);
        this.energyContainers = Collections.singletonList(this.energyContainer);
    }

    public EnergyNetwork(UUID networkID) {
        super(networkID);
        this.energyContainer = VariableCapacityEnergyContainer.create(this::getCapacityAsFloatingLong, BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.alwaysTrue, (IMekanismStrictEnergyHandler)this);
        this.energyContainers = Collections.singletonList(this.energyContainer);
    }

    public EnergyNetwork(Collection<EnergyNetwork> networks) {
        this();
        for (EnergyNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    @Override
    protected void forceScaleUpdate() {
        this.energyScale = !this.energyContainer.isEmpty() && !this.energyContainer.getMaxEnergy().isZero() ? Math.min(1.0f, this.energyContainer.getEnergy().divide(this.energyContainer.getMaxEnergy()).floatValue()) : 0.0f;
    }

    @Override
    public void adoptTransmittersAndAcceptorsFrom(EnergyNetwork net) {
        FloatingLong oldCapacity = this.getCapacityAsFloatingLong();
        super.adoptTransmittersAndAcceptorsFrom(net);
        FloatingLong ourScale = this.energyScale == 0.0f ? FloatingLong.ZERO : oldCapacity.multiply(this.energyScale);
        FloatingLong theirScale = net.energyScale == 0.0f ? FloatingLong.ZERO : net.getCapacityAsFloatingLong().multiply(net.energyScale);
        FloatingLong capacity = this.getCapacityAsFloatingLong();
        this.energyScale = Math.min(1.0f, capacity.isZero() ? 0.0f : ourScale.add(theirScale).divide(this.getCapacityAsFloatingLong()).floatValue());
        if (!this.isRemote() && !net.energyContainer.isEmpty()) {
            this.energyContainer.setEnergy(this.energyContainer.getEnergy().add(net.getBuffer()));
            net.energyContainer.setEmpty();
        }
    }

    @Override
    @Nonnull
    public FloatingLong getBuffer() {
        return this.energyContainer.getEnergy();
    }

    @Override
    public void absorbBuffer(IGridTransmitter<IStrictEnergyHandler, EnergyNetwork, FloatingLong> transmitter) {
        FloatingLong energy = transmitter.getBuffer();
        if (!energy.isZero()) {
            this.energyContainer.setEnergy(this.energyContainer.getEnergy().add(energy));
        }
    }

    @Override
    public void clampBuffer() {
        if (!this.energyContainer.isEmpty()) {
            FloatingLong capacity = this.getCapacityAsFloatingLong();
            if (this.energyContainer.getEnergy().greaterThan(capacity)) {
                this.energyContainer.setEnergy(capacity);
            }
        }
    }

    @Override
    protected synchronized void updateCapacity(IGridTransmitter<IStrictEnergyHandler, EnergyNetwork, FloatingLong> transmitter) {
        this.floatingLongCapacity = this.floatingLongCapacity.plusEqual(transmitter.getCapacityAsFloatingLong());
        this.capacity = this.floatingLongCapacity.longValue();
    }

    @Override
    public synchronized void updateCapacity() {
        FloatingLong sum = FloatingLong.ZERO;
        for (IGridTransmitter transmitter : this.transmitters) {
            sum = sum.plusEqual(transmitter.getCapacityAsFloatingLong());
        }
        if (!this.floatingLongCapacity.equals(sum)) {
            this.floatingLongCapacity = sum;
            this.capacity = this.floatingLongCapacity.longValue();
            this.updateSaveShares = true;
        }
    }

    @Nonnull
    public FloatingLong getCapacityAsFloatingLong() {
        return this.floatingLongCapacity;
    }

    @Override
    protected void updateSaveShares() {
        super.updateSaveShares();
        int size = this.transmittersSize();
        if (size > 0) {
            Direction side = Direction.NORTH;
            ObjectOpenHashSet saveTargets = new ObjectOpenHashSet(size);
            for (IGridTransmitter transmitter : this.transmitters) {
                EnergyTransmitterSaveTarget saveTarget = new EnergyTransmitterSaveTarget();
                saveTarget.addHandler(side, transmitter);
                saveTargets.add(saveTarget);
            }
            EmitUtils.sendToAcceptors(saveTargets, size, this.energyContainer.getEnergy().copy());
            for (EnergyTransmitterSaveTarget saveTarget : saveTargets) {
                saveTarget.saveShare(side);
            }
        }
    }

    private FloatingLong tickEmit(FloatingLong energyToSend) {
        ObjectOpenHashSet targets = new ObjectOpenHashSet();
        int totalHandlers = 0;
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        for (Coord4D coord : this.possibleAcceptors) {
            TileEntity tile;
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            if (sides == null || sides.isEmpty() || (tile = MekanismUtils.getTileEntity((IWorld)this.getWorld(), (Long2ObjectMap<IChunk>)chunkMap, coord)) == null) continue;
            EnergyAcceptorTarget target = new EnergyAcceptorTarget();
            for (Direction side : sides) {
                IStrictEnergyHandler handler = EnergyCompatUtils.getStrictEnergyHandler(tile, side);
                if (handler == null || !handler.insertEnergy(FloatingLong.ONE, Action.SIMULATE).smallerThan(FloatingLong.ONE)) continue;
                target.addHandler(side, handler);
            }
            int curHandlers = target.getHandlers().size();
            if (curHandlers <= 0) continue;
            targets.add(target);
            totalHandlers += curHandlers;
        }
        return EmitUtils.sendToAcceptors(targets, totalHandlers, energyToSend.copy());
    }

    public String toString() {
        return "[EnergyNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.isRemote()) {
            float scale = this.computeContentScale();
            if (scale != this.energyScale) {
                this.energyScale = scale;
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTransferEvent(this, this.energyScale));
                this.needsUpdate = false;
            }
            if (this.energyContainer.isEmpty()) {
                this.prevTransferAmount = FloatingLong.ZERO;
            } else {
                this.prevTransferAmount = this.tickEmit(this.energyContainer.getEnergy());
                this.energyContainer.extract(this.prevTransferAmount, Action.EXECUTE, AutomationType.INTERNAL);
            }
        }
    }

    public float computeContentScale() {
        float scale = (float)this.energyContainer.getEnergy().divideToLevel(this.energyContainer.getMaxEnergy());
        float ret = Math.max(this.energyScale, scale);
        if (!this.prevTransferAmount.isZero() && ret < 1.0f) {
            ret = Math.min(1.0f, ret + 0.02f);
        } else if (this.prevTransferAmount.isZero() && ret > 0.0f) {
            ret = Math.max(scale, ret - 0.02f);
        }
        return ret;
    }

    @Override
    public ITextComponent getNeededInfo() {
        return EnergyDisplay.of(this.energyContainer.getNeeded()).getTextComponent();
    }

    @Override
    public ITextComponent getStoredInfo() {
        return EnergyDisplay.of(this.energyContainer.getEnergy()).getTextComponent();
    }

    @Override
    public ITextComponent getFlowInfo() {
        return MekanismLang.GENERIC_PER_TICK.translate(EnergyDisplay.of(this.prevTransferAmount));
    }

    @Override
    public ITextComponent getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.ENERGY_NETWORK, this.transmitters.size(), this.possibleAcceptors.size());
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    public void onContentsChanged() {
        this.updateSaveShares = true;
    }

    public static class EnergyTransferEvent
    extends Event {
        public final EnergyNetwork energyNetwork;
        public final float energyScale;

        public EnergyTransferEvent(EnergyNetwork network, float scale) {
            this.energyNetwork = network;
            this.energyScale = scale;
        }
    }
}

