/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigurable;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.transmitters.IBlockableConnection;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MultipartUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TileEntitySidedPipe
extends CapabilityTileEntity
implements IBlockableConnection,
IConfigurable,
ITransmitter,
ITickableTileEntity {
    public byte currentAcceptorConnections = 0;
    public byte currentTransmitterConnections = 0;
    private boolean redstonePowered = false;
    protected boolean redstoneReactive = false;
    public boolean forceUpdate = true;
    private boolean redstoneSet = false;
    public ConnectionType[] connectionTypes = new ConnectionType[]{ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL};
    public TileEntity[] cachedAcceptors = new TileEntity[6];
    @Nullable
    private TransmitterModelData modelData;

    public TileEntitySidedPipe(TileEntityType<? extends TileEntitySidedPipe> type) {
        super(type);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.BLOCKABLE_CONNECTION_CAPABILITY, this));
    }

    public static boolean connectionMapContainsSide(byte connections, Direction side) {
        byte tester = (byte)(1 << side.ordinal());
        return (connections & tester) > 0;
    }

    public static byte setConnectionBit(byte connections, boolean toSet, Direction side) {
        return (byte)(connections & ~((byte)(1 << side.ordinal())) | (byte)((toSet ? 1 : 0) << side.ordinal()));
    }

    public static ConnectionType getConnectionType(Direction side, byte allConnections, byte transmitterConnections, ConnectionType[] types) {
        if (!TileEntitySidedPipe.connectionMapContainsSide(allConnections, side)) {
            return ConnectionType.NONE;
        }
        if (TileEntitySidedPipe.connectionMapContainsSide(transmitterConnections, side)) {
            return ConnectionType.NORMAL;
        }
        return types[side.ordinal()];
    }

    public void func_73660_a() {
        if (!this.isRemote() && this.forceUpdate) {
            this.refreshConnections();
            this.forceUpdate = false;
        }
    }

    public boolean handlesRedstone() {
        return true;
    }

    public byte getPossibleTransmitterConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (Direction side : EnumUtils.DIRECTIONS) {
            Optional<IGridTransmitter<?, ?, ?>> capability;
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
            if (!this.canConnectMutual(side, tile) || !(capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()))).isPresent() || !TransmissionType.checkTransmissionType(capability.get(), this.getTransmitterType().getTransmission()) || !this.isValidTransmitter(tile)) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    public boolean getPossibleAcceptorConnection(Direction side) {
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
        if (this.canConnectMutual(side, tile) && this.isValidAcceptor(tile, side)) {
            if (this.cachedAcceptors[side.ordinal()] != tile) {
                this.cachedAcceptors[side.ordinal()] = tile;
                this.markDirtyAcceptor(side);
            }
            return true;
        }
        if (this.cachedAcceptors[side.ordinal()] != null) {
            this.cachedAcceptors[side.ordinal()] = null;
            this.markDirtyAcceptor(side);
        }
        return false;
    }

    public boolean getPossibleTransmitterConnection(Direction side) {
        Optional<IGridTransmitter<?, ?, ?>> capability;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
        if (this.canConnectMutual(side, tile) && (capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()))).isPresent()) {
            return TransmissionType.checkTransmissionType(capability.get(), this.getTransmitterType().getTransmission()) && this.isValidTransmitter(tile);
        }
        return false;
    }

    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (Direction side : EnumUtils.DIRECTIONS) {
            BlockPos offset = this.func_174877_v().func_177972_a(side);
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), offset);
            if (this.canConnectMutual(side, tile)) {
                if (!this.isRemote() && !this.func_145831_w().func_195588_v(offset)) {
                    this.forceUpdate = true;
                    continue;
                }
                if (this.isValidAcceptor(tile, side)) {
                    if (this.cachedAcceptors[side.ordinal()] != tile) {
                        this.cachedAcceptors[side.ordinal()] = tile;
                        this.markDirtyAcceptor(side);
                    }
                    connections = (byte)(connections | 1 << side.ordinal());
                    continue;
                }
            }
            if (this.cachedAcceptors[side.ordinal()] == null) continue;
            this.cachedAcceptors[side.ordinal()] = null;
            this.markDirtyAcceptor(side);
        }
        return connections;
    }

    public byte getAllCurrentConnections() {
        return (byte)(this.currentTransmitterConnections | this.currentAcceptorConnections);
    }

    public abstract boolean isValidTransmitter(TileEntity var1);

    public List<VoxelShape> getCollisionBoxes() {
        ArrayList<VoxelShape> list = new ArrayList<VoxelShape>();
        byte connections = this.getAllCurrentConnections();
        boolean isSmall = this.getTransmitterType().getSize() == TransmitterType.Size.SMALL;
        for (Direction side : EnumUtils.DIRECTIONS) {
            ConnectionType connectionType = TileEntitySidedPipe.getConnectionType(side, connections, this.currentTransmitterConnections, this.connectionTypes);
            if (connectionType == ConnectionType.NONE) continue;
            if (isSmall) {
                list.add(BlockSmallTransmitter.getSideForType(connectionType, side));
                continue;
            }
            list.add(BlockLargeTransmitter.getSideForType(connectionType, side));
        }
        list.add(isSmall ? BlockSmallTransmitter.center : BlockLargeTransmitter.center);
        return list;
    }

    public abstract TransmitterType getTransmitterType();

    public abstract boolean isValidAcceptor(TileEntity var1, Direction var2);

    protected boolean isAcceptorAndListen(TileEntity tile, Direction side, Capability<?> capability) {
        LazyOptional<?> lazyOptional = CapabilityUtils.getCapability((ICapabilityProvider)tile, capability, side.func_176734_d());
        if (lazyOptional.isPresent()) {
            if (!this.isRemote()) {
                BlockPos pos = tile.func_174877_v();
                lazyOptional.addListener(invalidated -> {
                    if (!this.func_145837_r() && this.field_145850_b != null && this.field_145850_b.func_195588_v(pos)) {
                        this.refreshConnections(side);
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnectMutual(Direction side, @Nullable TileEntity cachedTile) {
        if (!this.canConnect(side)) {
            return false;
        }
        if (cachedTile == null) {
            cachedTile = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
        }
        return (Boolean)CapabilityUtils.getCapability((ICapabilityProvider)cachedTile, Capabilities.BLOCKABLE_CONNECTION_CAPABILITY, side.func_176734_d()).map(connection -> connection.canConnect(side.func_176734_d())).orElse((Object)true);
    }

    @Override
    public boolean canConnect(Direction side) {
        if (this.connectionTypes[side.ordinal()] == ConnectionType.NONE) {
            return false;
        }
        if (this.handlesRedstone()) {
            if (!this.redstoneSet) {
                this.redstonePowered = this.redstoneReactive ? MekanismUtils.isGettingPowered(this.func_145831_w(), this.func_174877_v()) : false;
                this.redstoneSet = true;
            }
            return !this.redstoneReactive || !this.redstonePowered;
        }
        return true;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74774_a("connections", this.currentTransmitterConnections);
        updateTag.func_74774_a("acceptors", this.currentAcceptorConnections);
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            updateTag.func_74768_a("side" + i, this.connectionTypes[i].ordinal());
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setByteIfPresent(tag, "connections", connections -> {
            this.currentTransmitterConnections = connections;
        });
        NBTUtils.setByteIfPresent(tag, "acceptors", acceptors -> {
            this.currentAcceptorConnections = acceptors;
        });
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int index = i++;
            NBTUtils.setEnumIfPresent(tag, "side" + index, ConnectionType::byIndexStatic, type -> {
                this.connectionTypes[index] = type;
            });
        }
    }

    @Override
    public void handleUpdatePacket(@Nonnull CompoundNBT tag) {
        super.handleUpdatePacket(tag);
        this.requestModelDataUpdate();
        MekanismUtils.updateBlock(this.func_145831_w(), this.func_174877_v());
    }

    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.redstoneReactive = nbtTags.func_74767_n("redstone");
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int index = i++;
            NBTUtils.setEnumIfPresent(nbtTags, "connection" + index, ConnectionType::byIndexStatic, color -> {
                this.connectionTypes[index] = color;
            });
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("redstone", this.redstoneReactive);
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            nbtTags.func_74768_a("connection" + i, this.connectionTypes[i].ordinal());
        }
        return nbtTags;
    }

    private void recheckRedstone() {
        if (this.handlesRedstone()) {
            boolean previouslyPowered = this.redstonePowered;
            this.redstonePowered = this.redstoneReactive ? MekanismUtils.isGettingPowered(this.func_145831_w(), this.func_174877_v()) : false;
            if (previouslyPowered != this.redstonePowered) {
                this.markDirtyTransmitters();
            }
            this.redstoneSet = true;
        }
    }

    public void refreshConnections() {
        if (!this.isRemote()) {
            this.recheckRedstone();
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            byte possibleAcceptors = this.getPossibleAcceptorConnections();
            byte newlyEnabledTransmitters = 0;
            boolean sendDesc = false;
            if ((possibleTransmitters | possibleAcceptors) != this.getAllCurrentConnections()) {
                sendDesc = true;
                if (possibleTransmitters != this.currentTransmitterConnections) {
                    newlyEnabledTransmitters = (byte)(possibleTransmitters ^ this.currentTransmitterConnections);
                    newlyEnabledTransmitters = (byte)(newlyEnabledTransmitters & ~this.currentTransmitterConnections);
                }
            }
            this.currentTransmitterConnections = possibleTransmitters;
            this.currentAcceptorConnections = possibleAcceptors;
            if (newlyEnabledTransmitters != 0) {
                this.recheckConnections(newlyEnabledTransmitters);
            }
            if (sendDesc) {
                this.sendUpdatePacket();
            }
        }
    }

    public void refreshConnections(Direction side) {
        if (!this.isRemote()) {
            boolean possibleTransmitter = this.getPossibleTransmitterConnection(side);
            boolean possibleAcceptor = this.getPossibleAcceptorConnection(side);
            boolean transmitterChanged = false;
            boolean sendDesc = false;
            if ((possibleTransmitter || possibleAcceptor) != TileEntitySidedPipe.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
                sendDesc = true;
                if (possibleTransmitter != TileEntitySidedPipe.connectionMapContainsSide(this.currentTransmitterConnections, side)) {
                    transmitterChanged = possibleTransmitter;
                }
            }
            this.currentTransmitterConnections = TileEntitySidedPipe.setConnectionBit(this.currentTransmitterConnections, possibleTransmitter, side);
            this.currentAcceptorConnections = TileEntitySidedPipe.setConnectionBit(this.currentAcceptorConnections, possibleAcceptor, side);
            if (transmitterChanged) {
                this.recheckConnection(side);
            }
            if (sendDesc) {
                this.sendUpdatePacket();
            }
        }
    }

    protected void recheckConnections(byte newlyEnabledTransmitters) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            TileEntitySidedPipe tile;
            if (!TileEntitySidedPipe.connectionMapContainsSide(newlyEnabledTransmitters, side) || (tile = MekanismUtils.getTileEntity(TileEntitySidedPipe.class, (IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side))) == null) continue;
            tile.refreshConnections(side.func_176734_d());
        }
    }

    protected void recheckConnection(Direction side) {
    }

    protected void onModeChange(Direction side) {
        this.markDirtyAcceptor(side);
        if (this.getPossibleTransmitterConnections() != this.currentTransmitterConnections) {
            this.markDirtyTransmitters();
        }
        this.markDirty(false);
    }

    protected void markDirtyTransmitters() {
        this.notifyTileChange();
    }

    protected void markDirtyAcceptor(Direction side) {
    }

    public abstract void onWorldJoin();

    public abstract void onWorldSeparate();

    public void func_145843_s() {
        this.onWorldSeparate();
        super.func_145843_s();
    }

    public void func_145829_t() {
        this.onWorldJoin();
        super.func_145829_t();
    }

    public void onChunkUnloaded() {
        this.onWorldSeparate();
        super.onChunkUnloaded();
    }

    public void onAdded() {
        this.onWorldJoin();
        this.refreshConnections();
    }

    public void onLoad() {
        this.onWorldJoin();
        super.onLoad();
    }

    public void onNeighborTileChange(Direction side) {
        this.refreshConnections(side);
    }

    public void onNeighborBlockChange(Direction side) {
        if (this.handlesRedstone() && this.redstoneReactive) {
            this.refreshConnections();
        } else {
            this.refreshConnections(side);
        }
    }

    public ConnectionType getConnectionType(Direction side) {
        return TileEntitySidedPipe.getConnectionType(side, this.getAllCurrentConnections(), this.currentTransmitterConnections, this.connectionTypes);
    }

    public Set<Direction> getConnections(ConnectionType type) {
        EnumSet<Direction> sides = EnumSet.noneOf(Direction.class);
        for (Direction side : EnumUtils.DIRECTIONS) {
            if (this.getConnectionType(side) != type) continue;
            sides.add(side);
        }
        return sides;
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            Pair<Vec3d, Vec3d> vecs = MultipartUtils.getRayTraceVectors((Entity)player);
            MultipartUtils.AdvancedRayTraceResult result = MultipartUtils.collisionRayTrace(this.func_174877_v(), (Vec3d)vecs.getLeft(), (Vec3d)vecs.getRight(), this.getCollisionBoxes());
            if (result == null) {
                return ActionResultType.PASS;
            }
            Direction hitSide = this.sideHit(result.hit.subHit + 1);
            if (hitSide == null) {
                if (this.connectionTypes[side.ordinal()] != ConnectionType.NONE && this.onConfigure(player, 6, side) == ActionResultType.SUCCESS) {
                    this.refreshConnections();
                    this.notifyTileChange();
                    return ActionResultType.SUCCESS;
                }
                hitSide = side;
            }
            this.connectionTypes[hitSide.ordinal()] = (ConnectionType)this.connectionTypes[hitSide.ordinal()].getNext();
            this.onModeChange(Direction.func_82600_a((int)hitSide.ordinal()));
            this.refreshConnections();
            this.notifyTileChange();
            player.func_145747_a((ITextComponent)MekanismLang.CONNECTION_TYPE.translate(this.connectionTypes[hitSide.ordinal()]));
            this.sendUpdatePacket();
        }
        return ActionResultType.SUCCESS;
    }

    protected Direction sideHit(int boxIndex) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction side : EnumUtils.DIRECTIONS) {
            byte connections = this.getAllCurrentConnections();
            if (!TileEntitySidedPipe.connectionMapContainsSide(connections, side)) continue;
            list.add(side);
        }
        if (boxIndex < list.size()) {
            return (Direction)list.get(boxIndex);
        }
        return null;
    }

    protected ActionResultType onConfigure(PlayerEntity player, int part, Direction side) {
        return ActionResultType.PASS;
    }

    public EnumColor getRenderColor() {
        return null;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote() && this.handlesRedstone()) {
            this.redstoneReactive ^= true;
            this.refreshConnections();
            this.notifyTileChange();
            player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.REDSTONE_SENSITIVITY.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, BooleanStateDisplay.OnOff.of(this.redstoneReactive)})));
        }
        return ActionResultType.SUCCESS;
    }

    public void requestModelDataUpdate() {
        this.modelData = null;
        super.requestModelDataUpdate();
    }

    @Nonnull
    public TransmitterModelData getModelData() {
        if (this.modelData == null) {
            this.modelData = this.initModelData();
            this.updateModelData(this.modelData);
        }
        return this.modelData;
    }

    protected void updateModelData(TransmitterModelData modelData) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            modelData.setConnectionData(side, this.getConnectionType(side));
        }
    }

    @Nonnull
    protected TransmitterModelData initModelData() {
        return new TransmitterModelData();
    }

    public void notifyTileChange() {
        MekanismUtils.notifyLoadedNeighborsOfTileChange(this.func_145831_w(), this.func_174877_v());
    }

    public boolean canRenderBreaking() {
        return false;
    }

    public static enum ConnectionType implements IIncrementalEnum<ConnectionType>,
    IStringSerializable,
    IHasTranslationKey
    {
        NORMAL(MekanismLang.CONNECTION_NORMAL),
        PUSH(MekanismLang.CONNECTION_PUSH),
        PULL(MekanismLang.CONNECTION_PULL),
        NONE(MekanismLang.CONNECTION_NONE);

        private static final ConnectionType[] TYPES;
        private final ILangEntry langEntry;

        private ConnectionType(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        @Nonnull
        public ConnectionType byIndex(int index) {
            return ConnectionType.byIndexStatic(index);
        }

        public static ConnectionType byIndexStatic(int index) {
            return MathUtils.getByIndexMod(TYPES, index);
        }

        static {
            TYPES = ConnectionType.values();
        }
    }
}

