/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.IMekWrench;
import mekanism.api.Upgrade;
import mekanism.api.block.IHasTileEntity;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.IMekanismInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.sustained.ISustainedInventory;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ITileComponent;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.AttributeUpgradeable;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.resolver.manager.EnergyHandlerManager;
import mekanism.common.capabilities.resolver.manager.FluidHandlerManager;
import mekanism.common.capabilities.resolver.manager.GasHandlerManager;
import mekanism.common.capabilities.resolver.manager.HeatHandlerManager;
import mekanism.common.capabilities.resolver.manager.ICapabilityHandlerManager;
import mekanism.common.capabilities.resolver.manager.InfusionHandlerManager;
import mekanism.common.capabilities.resolver.manager.ItemHandlerManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.inventory.container.ITrackableContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableGasStack;
import mekanism.common.inventory.container.sync.SyncableInfusionStack;
import mekanism.common.inventory.slot.UpgradeInventorySlot;
import mekanism.common.item.ItemConfigurationCard;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.WrenchResult;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.interfaces.ITierUpgradable;
import mekanism.common.tile.interfaces.ITileActive;
import mekanism.common.tile.interfaces.ITileDirectional;
import mekanism.common.tile.interfaces.ITileRedstone;
import mekanism.common.tile.interfaces.ITileSound;
import mekanism.common.tile.interfaces.ITileUpgradable;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileEntityMekanism
extends CapabilityTileEntity
implements IFrequencyHandler,
ITickableTileEntity,
ITileDirectional,
ITileActive,
ITileSound,
ITileRedstone,
ISecurityTile,
IMekanismInventory,
ISustainedInventory,
ITileUpgradable,
ITierUpgradable,
IComparatorSupport,
ITrackableContainer,
IMekanismGasHandler,
IMekanismInfusionHandler,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler {
    public Set<PlayerEntity> playersUsing = new ObjectOpenHashSet();
    public int ticker;
    private final List<ICapabilityHandlerManager<?>> capabilityHandlerManagers = new ArrayList();
    private final List<ITileComponent> components = new ArrayList<ITileComponent>();
    protected IBlockProvider blockProvider;
    private boolean supportsComparator;
    private boolean supportsUpgrades;
    private boolean supportsRedstone;
    private boolean canBeUpgraded;
    private boolean isDirectional;
    private boolean isActivatable;
    private boolean hasInventory;
    private boolean hasSecurity;
    private boolean hasSound;
    private boolean hasGui;
    public boolean redstone = false;
    private boolean redstoneLastTick = false;
    private IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    private int currentRedstoneLevel;
    protected TileComponentUpgrade upgradeComponent;
    protected final ItemHandlerManager itemHandlerManager;
    protected final GasHandlerManager gasHandlerManager;
    protected final InfusionHandlerManager infusionHandlerManager;
    protected final FluidHandlerManager fluidHandlerManager;
    protected final EnergyHandlerManager energyHandlerManager;
    private FloatingLong lastEnergyReceived = FloatingLong.ZERO;
    protected final HeatHandlerManager heatHandlerManager;
    private TileComponentSecurity securityComponent;
    private boolean currentActive;
    private int updateDelay;
    protected IntSupplier delaySupplier;
    @Nullable
    private final SoundEvent soundEvent;
    private ISound activeSound;
    private int playSoundCooldown;

    public TileEntityMekanism(IBlockProvider blockProvider) {
        super(((IHasTileEntity)blockProvider.getBlock()).getTileType());
        this.delaySupplier = MekanismConfig.general.blockDeactivationDelay;
        this.playSoundCooldown = 0;
        this.blockProvider = blockProvider;
        this.setSupportedTypes(this.blockProvider.getBlock());
        this.presetVariables();
        this.gasHandlerManager = new GasHandlerManager(this.getInitialGasTanks(), this);
        this.capabilityHandlerManagers.add(this.gasHandlerManager);
        this.infusionHandlerManager = new InfusionHandlerManager(this.getInitialInfusionTanks(), this);
        this.capabilityHandlerManagers.add(this.infusionHandlerManager);
        this.fluidHandlerManager = new FluidHandlerManager(this.getInitialFluidTanks(), this);
        this.capabilityHandlerManagers.add(this.fluidHandlerManager);
        this.energyHandlerManager = new EnergyHandlerManager(this.getInitialEnergyContainers(), this);
        this.capabilityHandlerManagers.add(this.energyHandlerManager);
        this.heatHandlerManager = new HeatHandlerManager(this.getInitialHeatCapacitors(), this);
        this.capabilityHandlerManagers.add(this.heatHandlerManager);
        this.itemHandlerManager = new ItemHandlerManager(this.getInitialInventory(), this.hasInventory, this);
        this.capabilityHandlerManagers.add(this.itemHandlerManager);
        for (ICapabilityHandlerManager<?> capabilityHandlerManager : this.capabilityHandlerManagers) {
            if (!capabilityHandlerManager.canHandle()) continue;
            this.addCapabilityResolver(capabilityHandlerManager);
        }
        if (this.supportsUpgrades()) {
            this.upgradeComponent = new TileComponentUpgrade(this, UpgradeInventorySlot.of(this, this.getSupportedUpgrade()));
        }
        if (this.hasSecurity()) {
            this.securityComponent = new TileComponentSecurity(this);
        }
        this.soundEvent = this.hasSound() ? Attribute.get(blockProvider.getBlock(), AttributeSound.class).getSoundEvent() : null;
    }

    private void setSupportedTypes(Block block) {
        this.supportsUpgrades = Attribute.has(block, AttributeUpgradeSupport.class);
        this.canBeUpgraded = Attribute.has(block, AttributeUpgradeable.class);
        this.isDirectional = Attribute.has(block, AttributeStateFacing.class);
        this.supportsRedstone = Attribute.has(block, Attributes.AttributeRedstone.class);
        this.hasSound = Attribute.has(block, AttributeSound.class);
        this.hasGui = Attribute.has(block, AttributeGui.class);
        this.hasInventory = Attribute.has(block, Attributes.AttributeInventory.class);
        this.hasSecurity = Attribute.has(block, Attributes.AttributeSecurity.class);
        this.isActivatable = this.hasSound || Attribute.has(block, AttributeStateActive.class);
        this.supportsComparator = Attribute.has(block, Attributes.AttributeComparator.class);
    }

    protected void presetVariables() {
    }

    public Block getBlockType() {
        return this.blockProvider.getBlock();
    }

    public boolean persists(SubstanceType type) {
        return type.canHandle(this);
    }

    public boolean handles(SubstanceType type) {
        return this.persists(type);
    }

    @Override
    public final boolean supportsUpgrades() {
        return this.supportsUpgrades;
    }

    @Override
    public final boolean supportsComparator() {
        return this.supportsComparator;
    }

    @Override
    public final boolean canBeUpgraded() {
        return this.canBeUpgraded;
    }

    @Override
    public final boolean isDirectional() {
        return this.isDirectional;
    }

    @Override
    public final boolean supportsRedstone() {
        return this.supportsRedstone;
    }

    @Override
    public final boolean hasSound() {
        return this.hasSound;
    }

    public final boolean hasGui() {
        return this.hasGui;
    }

    @Override
    public final boolean hasSecurity() {
        return this.hasSecurity;
    }

    @Override
    public final boolean isActivatable() {
        return this.isActivatable;
    }

    @Override
    public final boolean hasInventory() {
        return this.itemHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleInfusion() {
        return this.infusionHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleFluid() {
        return this.fluidHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleGas() {
        return this.gasHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleEnergy() {
        return this.energyHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleHeat() {
        return this.heatHandlerManager.canHandle();
    }

    public void addComponent(ITileComponent component) {
        this.components.add(component);
        if (component instanceof TileComponentConfig) {
            this.addConfigComponent((TileComponentConfig)component);
        }
    }

    public List<ITileComponent> getComponents() {
        return this.components;
    }

    @Nonnull
    public ITextComponent getName() {
        return TextComponentUtil.translate(this.getBlockType().func_149739_a(), new Object[0]);
    }

    @Override
    protected void markDirtyComparator() {
        int newRedstoneLevel;
        if (this.supportsComparator() && !this.func_195044_w().isAir((IBlockReader)this.field_145850_b, this.field_174879_c) && (newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.getBlockType());
            this.currentRedstoneLevel = newRedstoneLevel;
        }
    }

    public WrenchResult tryWrench(BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        IMekWrench wrenchHandler;
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && (wrenchHandler = MekanismUtils.getWrench(stack)) != null && wrenchHandler.canUseWrench(stack, player, rayTrace.func_216350_a())) {
            if (this.hasSecurity() && !SecurityUtils.canAccess(player, this)) {
                SecurityUtils.displayNoAccess(player);
                return WrenchResult.NO_SECURITY;
            }
            if (player.func_225608_bj_()) {
                MekanismUtils.dismantleBlock(state, this.func_145831_w(), this.field_174879_c, this);
                return WrenchResult.DISMANTLED;
            }
            if (this.isDirectional()) {
                this.setFacing(this.getDirection().func_176746_e());
            }
            return WrenchResult.SUCCESS;
        }
        return WrenchResult.PASS;
    }

    public ActionResultType openGui(PlayerEntity player) {
        if (this.hasGui() && !this.isRemote() && !player.func_225608_bj_()) {
            ItemConfigurator configurator;
            if (this.hasSecurity() && !SecurityUtils.canAccess(player, this)) {
                SecurityUtils.displayNoAccess(player);
                return ActionResultType.FAIL;
            }
            ItemStack stack = player.func_184614_ca();
            if (this.isDirectional() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator && (configurator = (ItemConfigurator)stack.func_77973_b()).getState(stack) == ItemConfigurator.ConfiguratorMode.ROTATE) {
                return ActionResultType.PASS;
            }
            if (CapabilityUtils.getCapability((ICapabilityProvider)this, Capabilities.CONFIG_CARD_CAPABILITY, null).isPresent() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurationCard) {
                return ActionResultType.PASS;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)Attribute.get(this.blockProvider.getBlock(), AttributeGui.class).getProvider(this), (BlockPos)this.field_174879_c);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_73660_a() {
        for (ITileComponent component : this.components) {
            component.tick();
        }
        if (this.isRemote()) {
            if (this.hasSound()) {
                this.updateSound();
            }
            if (this.isActivatable() && this.ticker == 0) {
                MekanismUtils.updateBlock(this.func_145831_w(), this.func_174877_v());
            }
            this.onUpdateClient();
        } else {
            if (this.isActivatable() && this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.getClientActive() != this.currentActive) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, Attribute.setActive(this.func_195044_w(), this.currentActive));
                }
            }
            this.onUpdateServer();
            if (this.persists(SubstanceType.HEAT)) {
                this.update(null);
            }
            this.lastEnergyReceived = FloatingLong.ZERO;
        }
        ++this.ticker;
        if (this.supportsRedstone()) {
            this.redstoneLastTick = this.redstone;
        }
    }

    public void open(PlayerEntity player) {
        this.playersUsing.add(player);
    }

    public void close(PlayerEntity player) {
        this.playersUsing.remove(player);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (ITileComponent component : this.components) {
            component.invalidate();
        }
        if (this.isRemote() && this.hasSound()) {
            this.updateSound();
        }
    }

    protected void onUpdateClient() {
    }

    protected void onUpdateServer() {
    }

    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.redstone = nbtTags.func_74767_n("redstone");
        for (ITileComponent component : this.components) {
            component.read(nbtTags);
        }
        if (this.supportsRedstone()) {
            NBTUtils.setEnumIfPresent(nbtTags, "controlType", IRedstoneControl.RedstoneControl::byIndexStatic, type -> {
                this.controlType = type;
            });
        }
        if (this.hasInventory() && this.persistInventory()) {
            DataHandlerUtils.readSlots(this.getInventorySlots(null), nbtTags.func_150295_c("Items", 10));
        }
        for (SubstanceType type2 : SubstanceType.values()) {
            if (!type2.canHandle(this) || !this.persists(type2)) continue;
            type2.read(this, nbtTags);
        }
        if (this.isActivatable()) {
            this.currentActive = nbtTags.func_74767_n("activeState");
            this.updateDelay = nbtTags.func_74762_e("updateDelay");
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("redstone", this.redstone);
        for (ITileComponent component : this.components) {
            component.write(nbtTags);
        }
        if (this.supportsRedstone()) {
            nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        }
        if (this.hasInventory() && this.persistInventory()) {
            nbtTags.func_218657_a("Items", (INBT)DataHandlerUtils.writeSlots(this.getInventorySlots(null)));
        }
        for (SubstanceType type : SubstanceType.values()) {
            if (!type.canHandle(this) || !this.persists(type)) continue;
            type.write(this, nbtTags);
        }
        if (this.isActivatable()) {
            nbtTags.func_74757_a("activeState", this.currentActive);
            nbtTags.func_74768_a("updateDelay", this.updateDelay);
        }
        return nbtTags;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        for (ITileComponent component : this.components) {
            component.trackForMainContainer(container);
        }
        if (this.supportsRedstone()) {
            container.track(SyncableEnum.create(IRedstoneControl.RedstoneControl::byIndexStatic, IRedstoneControl.RedstoneControl.DISABLED, () -> this.controlType, value -> {
                this.controlType = value;
            }));
        }
        if (this.canHandleGas() && this.handles(SubstanceType.GAS)) {
            List<IGasTank> gasTanks = this.getGasTanks(null);
            for (IGasTank gasTank : gasTanks) {
                container.track(SyncableGasStack.create(gasTank));
            }
        }
        if (this.canHandleInfusion() && this.handles(SubstanceType.INFUSION)) {
            List<IInfusionTank> infusionTanks = this.getInfusionTanks(null);
            for (IInfusionTank infusionTank : infusionTanks) {
                container.track(SyncableInfusionStack.create(infusionTank));
            }
        }
        if (this.canHandleFluid() && this.handles(SubstanceType.FLUID)) {
            List<IExtendedFluidTank> fluidTanks = this.getFluidTanks(null);
            for (IExtendedFluidTank fluidTank : fluidTanks) {
                container.track(SyncableFluidStack.create(fluidTank));
            }
        }
        if (this.canHandleHeat() && this.handles(SubstanceType.HEAT)) {
            List<IHeatCapacitor> heatCapacitors = this.getHeatCapacitors(null);
            for (IHeatCapacitor capacitor : heatCapacitors) {
                container.track(SyncableDouble.create(capacitor::getHeat, capacitor::setHeat));
                if (!(capacitor instanceof BasicHeatCapacitor)) continue;
                container.track(SyncableDouble.create(capacitor::getHeatCapacity, capacity -> ((BasicHeatCapacitor)capacitor).setHeatCapacity(capacity, false)));
            }
        }
        if (this.canHandleEnergy() && this.handles(SubstanceType.ENERGY)) {
            container.track(SyncableFloatingLong.create(this::getInputRate, this::setInputRate));
            List<IEnergyContainer> energyContainers = this.getEnergyContainers(null);
            for (IEnergyContainer energyContainer : energyContainers) {
                container.track(SyncableFloatingLong.create(energyContainer::getEnergy, energyContainer::setEnergy));
                if (!(energyContainer instanceof MachineEnergyContainer)) continue;
                MachineEnergyContainer machineEnergy = (MachineEnergyContainer)energyContainer;
                if (!this.supportsUpgrades()) {
                    if (!machineEnergy.adjustableRates()) continue;
                }
                container.track(SyncableFloatingLong.create(machineEnergy::getMaxEnergy, machineEnergy::setMaxEnergy));
                container.track(SyncableFloatingLong.create(machineEnergy::getEnergyPerTick, machineEnergy::setEnergyPerTick));
            }
        }
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        for (ITileComponent component : this.components) {
            component.addToUpdateTag(updateTag);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        for (ITileComponent component : this.components) {
            component.readFromUpdateTag(tag);
        }
    }

    public void onNeighborChange(Block block) {
        if (!this.isRemote() && this.supportsRedstone()) {
            this.updatePower();
        }
    }

    public void onAdded() {
        if (this.supportsRedstone()) {
            this.updatePower();
        }
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies && this.hasSecurity) {
            return this.getSecurity().getFrequency();
        }
        return null;
    }

    public void parseUpgradeData(@Nonnull IUpgradeData data) {
        Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
    }

    @Override
    @Nonnull
    public Direction getDirection() {
        if (this.isDirectional()) {
            return Attribute.getFacing(this.func_195044_w());
        }
        return Direction.NORTH;
    }

    @Override
    public void setFacing(@Nonnull Direction direction) {
        if (this.isDirectional()) {
            BlockState state = Attribute.setFacing(this.func_195044_w(), direction);
            if (this.field_145850_b != null && state != null) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
            }
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(@Nonnull IRedstoneControl.RedstoneControl type) {
        if (this.supportsRedstone()) {
            this.controlType = Objects.requireNonNull(type);
            this.markDirty(false);
        }
    }

    @Override
    public boolean isPowered() {
        return this.supportsRedstone() && this.redstone;
    }

    @Override
    public boolean wasPowered() {
        return this.supportsRedstone() && this.redstoneLastTick;
    }

    private void updatePower() {
        boolean power = this.field_145850_b.func_175640_z(this.func_174877_v());
        if (this.redstone != power) {
            this.redstone = power;
            this.onPowerChange();
        }
    }

    @Override
    public int getRedstoneLevel() {
        if (this.supportsComparator() && this.hasInventory()) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this);
        }
        return 0;
    }

    @Override
    public int getCurrentRedstoneLevel() {
        if (this.supportsComparator()) {
            return this.currentRedstoneLevel;
        }
        return 0;
    }

    @Override
    @Nonnull
    public Set<Upgrade> getSupportedUpgrade() {
        if (this.supportsUpgrades()) {
            return Attribute.get(this.blockProvider.getBlock(), AttributeUpgradeSupport.class).getSupportedUpgrades();
        }
        return Collections.emptySet();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        block3: {
            block2: {
                if (upgrade != Upgrade.SPEED) break block2;
                for (IEnergyContainer energyContainer : this.getEnergyContainers(null)) {
                    if (!(energyContainer instanceof MachineEnergyContainer)) continue;
                    ((MachineEnergyContainer)energyContainer).updateEnergyPerTick();
                }
                break block3;
            }
            if (upgrade != Upgrade.ENERGY) break block3;
            for (IEnergyContainer energyContainer : this.getEnergyContainers(null)) {
                if (!(energyContainer instanceof MachineEnergyContainer)) continue;
                MachineEnergyContainer machineEnergy = (MachineEnergyContainer)energyContainer;
                machineEnergy.updateMaxEnergy();
                machineEnergy.updateEnergyPerTick();
            }
        }
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory() {
        return null;
    }

    @Override
    @Nonnull
    public final List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.itemHandlerManager.getContainers(side);
    }

    @Override
    public void onContentsChanged() {
        this.markDirty(false);
    }

    @Override
    public void setInventory(ListNBT nbtTags, Object ... data) {
        if (nbtTags != null && !nbtTags.isEmpty() && this.persistInventory()) {
            DataHandlerUtils.readSlots(this.getInventorySlots(null), nbtTags);
        }
    }

    @Override
    public ListNBT getInventory(Object ... data) {
        return this.persistInventory() ? DataHandlerUtils.writeSlots(this.getInventorySlots(null)) : new ListNBT();
    }

    public boolean persistInventory() {
        return this.hasInventory();
    }

    @Nullable
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        return null;
    }

    @Override
    @Nonnull
    public final List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasHandlerManager.getContainers(side);
    }

    @Nullable
    protected IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks() {
        return null;
    }

    @Override
    @Nonnull
    public final List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionHandlerManager.getContainers(side);
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks() {
        return null;
    }

    @Override
    @Nonnull
    public final List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidHandlerManager.getContainers(side);
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        return null;
    }

    @Override
    @Nonnull
    public final List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyHandlerManager.getContainers(side);
    }

    @Override
    @Nonnull
    public FloatingLong insertEnergy(int container, @Nonnull FloatingLong amount, @Nullable Direction side, @Nonnull Action action) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        if (energyContainer == null) {
            return amount;
        }
        FloatingLong remainder = energyContainer.insert(amount, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
        if (action.execute()) {
            this.lastEnergyReceived = this.lastEnergyReceived.plusEqual(amount.subtract(remainder));
        }
        return remainder;
    }

    public FloatingLong getInputRate() {
        return this.lastEnergyReceived;
    }

    protected void setInputRate(FloatingLong inputRate) {
        this.lastEnergyReceived = inputRate;
    }

    @Nullable
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        return null;
    }

    @Override
    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        if (this.canHandleHeat() && this.getHeatCapacitorCount(side) > 0) {
            TileEntity adj = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
            return MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_HANDLER_CAPABILITY, side.func_176734_d())).orElse(null);
        }
        return null;
    }

    @Override
    @Nonnull
    public final List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
        return this.heatHandlerManager.getContainers(side);
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public boolean getActive() {
        return this.isRemote() ? this.getClientActive() : this.currentActive;
    }

    private boolean getClientActive() {
        return Attribute.isActive(this.func_195044_w());
    }

    @Override
    public void setActive(boolean active) {
        if (this.isActivatable()) {
            BlockState state = this.func_195044_w();
            Block block = state.func_177230_c();
            if (active != this.currentActive && Attribute.has(block, AttributeStateActive.class)) {
                this.currentActive = active;
                if (this.getClientActive() != active) {
                    if (active) {
                        state = Attribute.setActive(state, true);
                        this.field_145850_b.func_175656_a(this.field_174879_c, state);
                    } else {
                        if (this.updateDelay == 0) {
                            this.field_145850_b.func_175656_a(this.field_174879_c, Attribute.setActive(this.func_195044_w(), this.currentActive));
                        }
                        this.updateDelay = this.delaySupplier.getAsInt();
                    }
                }
            }
        }
    }

    protected boolean canPlaySound() {
        return this.getActive();
    }

    private void updateSound() {
        if (!this.hasSound() || !MekanismConfig.client.enableMachineSounds.get() || this.soundEvent == null) {
            return;
        }
        if (this.canPlaySound() && !this.func_145837_r()) {
            if (--this.playSoundCooldown > 0) {
                return;
            }
            if (!(this.isFullyMuffled() || this.activeSound != null && Minecraft.func_71410_x().func_147118_V().func_215294_c(this.activeSound))) {
                this.activeSound = SoundHandler.startTileSound(this.soundEvent, this.getSoundCategory(), this.getInitialVolume(), this.func_174877_v());
            }
            this.playSoundCooldown = 20;
        } else if (this.activeSound != null) {
            SoundHandler.stopTileSound(this.func_174877_v());
            this.activeSound = null;
            this.playSoundCooldown = 0;
        }
    }

    private boolean isFullyMuffled() {
        if (!this.hasSound() || !this.supportsUpgrades()) {
            return false;
        }
        if (this.getComponent().supports(Upgrade.MUFFLING)) {
            return this.getComponent().getUpgrades(Upgrade.MUFFLING) == Upgrade.MUFFLING.getMax();
        }
        return false;
    }
}

