/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class TileEntityThermalEvaporationValve
extends TileEntityThermalEvaporationBlock {
    private boolean prevMaster = false;

    public TileEntityThermalEvaporationValve() {
        super(MekanismBlocks.THERMAL_EVAPORATION_VALVE);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return side -> this.getController() == null ? Collections.emptyList() : this.getController().getFluidTanks(side);
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        return side -> this.getController() == null ? Collections.emptyList() : this.getController().getHeatCapacitors(side);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        return side -> this.getController() == null ? Collections.emptyList() : this.getController().getInventorySlots(side);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.master == null == this.prevMaster) {
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockPos offset = this.field_174879_c.func_177972_a(side);
                if (this.field_145850_b.func_175623_d(offset) || MekanismUtils.getTileEntity(TileEntityThermalEvaporationBlock.class, (IBlockReader)this.field_145850_b, offset) != null) continue;
                MekanismUtils.notifyNeighborofChange(this.field_145850_b, offset, this.field_174879_c);
            }
        }
        this.prevMaster = this.master != null;
    }

    @Override
    public void controllerGone() {
        super.controllerGone();
        this.invalidateCachedCapabilities();
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.FLUID || type == SubstanceType.HEAT) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public boolean persistInventory() {
        return false;
    }

    @Override
    public int getRedstoneLevel() {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller == null) {
            return 0;
        }
        return MekanismUtils.redstoneLevelFromContents(controller.inputTank.getFluidAmount(), controller.inputTank.getCapacity());
    }
}

