/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.IEvaporationSolar;
import mekanism.api.annotations.NonNull;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.FluidToFluidCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.interfaces.ITileCachedRecipeHolder;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityThermalEvaporationController
extends TileEntityThermalEvaporationBlock
implements ITileCachedRecipeHolder<FluidToFluidRecipe> {
    private static final int MAX_OUTPUT = 10000;
    private static final int MAX_HEIGHT = 18;
    public static final double MAX_MULTIPLIER_TEMP = 3000.0;
    public BasicFluidTank inputTank;
    public BasicFluidTank outputTank;
    public BasicHeatCapacitor heatCapacitor;
    private Set<Coord4D> tankParts = new ObjectOpenHashSet();
    private IEvaporationSolar[] solars = new IEvaporationSolar[4];
    private boolean temperatureSet;
    private double biomeTemp;
    private double tempMultiplier;
    public double lastGain;
    private int inputCapacity;
    public int height;
    private boolean clientStructured;
    public boolean controllerConflict;
    private boolean isLeftOnFace;
    private int renderY;
    private boolean updatedThisTick;
    public float prevScale;
    public double totalLoss;
    private CachedRecipe<FluidToFluidRecipe> cachedRecipe;
    private final IOutputHandler<@NonNull FluidStack> outputHandler;
    private final IInputHandler<@NonNull FluidStack> inputHandler = InputHelper.getInputHandler(this.inputTank);
    private FluidInventorySlot inputInputSlot;
    private OutputInventorySlot outputInputSlot;
    private FluidInventorySlot inputOutputSlot;
    private OutputInventorySlot outputOutputSlot;

    public TileEntityThermalEvaporationController() {
        super(MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank);
        this.addDisabledCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Capabilities.HEAT_HANDLER_CAPABILITY, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.inputTank = VariableCapacityFluidTank.input(this::getMaxFluid, fluid -> this.containsRecipe(recipe -> recipe.getInput().testType(fluid)), (IMekanismFluidHandler)this);
        builder.addTank(this.inputTank);
        this.outputTank = BasicFluidTank.output(10000, this);
        builder.addTank(this.outputTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputInputSlot = FluidInventorySlot.fill(this.inputTank, this, 28, 20);
        builder.addSlot(this.inputInputSlot);
        this.outputInputSlot = OutputInventorySlot.at(this, 28, 51);
        builder.addSlot(this.outputInputSlot);
        this.inputOutputSlot = FluidInventorySlot.drain(this.outputTank, this, 132, 20);
        builder.addSlot(this.inputOutputSlot);
        this.outputOutputSlot = OutputInventorySlot.at(this, 132, 51);
        builder.addSlot(this.outputOutputSlot);
        this.inputInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.inputOutputSlot.setSlotType(ContainerSlotType.INPUT);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(this::getDirection);
        this.heatCapacitor = BasicHeatCapacitor.create(MekanismConfig.general.evaporationHeatCapacity.get() * 3.0, this);
        builder.addCapacitor(this.heatCapacitor);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        float scale;
        boolean active;
        super.onUpdateServer();
        this.updatedThisTick = false;
        if (this.ticker == 5) {
            this.refresh();
        }
        if ((active = this.getActive()) && this.height == 0) {
            this.refresh();
            active = this.getActive();
        }
        if (active) {
            this.updateTemperature();
            this.inputOutputSlot.drainTank(this.outputOutputSlot);
            this.inputInputSlot.fillTank(this.outputInputSlot);
        }
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        if (active && (scale = MekanismUtils.getScale(this.prevScale, this.inputTank)) != this.prevScale) {
            this.prevScale = scale;
            this.sendUpdatePacket();
        }
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.isRemote()) {
            this.clearStructure();
        }
    }

    @Override
    public void onNeighborChange(Block block) {
        super.onNeighborChange(block);
        this.refresh();
    }

    protected void refresh() {
        if (!this.isRemote() && !this.updatedThisTick) {
            this.clearStructure();
            boolean active = this.buildStructure();
            this.setActive(active);
            if (active) {
                this.updateMaxFluid();
                this.heatCapacitor.setHeatCapacity(MekanismConfig.general.evaporationHeatCapacity.get() * (double)this.height, true);
                if (!this.inputTank.isEmpty()) {
                    this.inputTank.setStackSize(Math.min(this.inputTank.getFluidAmount(), this.getMaxFluid()), Action.EXECUTE);
                }
            } else {
                this.clearStructure();
            }
        }
    }

    @Override
    @Nonnull
    public MekanismRecipeType<FluidToFluidRecipe> getRecipeType() {
        return MekanismRecipeType.EVAPORATING;
    }

    @Override
    @Nullable
    public CachedRecipe<FluidToFluidRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public FluidToFluidRecipe getRecipe(int cacheIndex) {
        FluidStack fluid = this.inputHandler.getInput();
        if (fluid.isEmpty()) {
            return null;
        }
        return (FluidToFluidRecipe)this.findFirstRecipe(recipe -> recipe.test(fluid));
    }

    @Override
    @Nullable
    public CachedRecipe<FluidToFluidRecipe> createNewCachedRecipe(@Nonnull FluidToFluidRecipe recipe, int cacheIndex) {
        return new FluidToFluidCachedRecipe(recipe, this.inputHandler, this.outputHandler).setCanHolderFunction(() -> this.getActive() && this.height > 2 && this.height <= 18 && MekanismUtils.canFunction(this)).setOnFinish(() -> this.markDirty(false)).setActive(active -> {
            this.lastGain = active ? (this.tempMultiplier > 0.0 && this.tempMultiplier < 1.0 ? (double)(1.0f / (float)((int)Math.ceil(1.0 / this.tempMultiplier))) : this.tempMultiplier) : 0.0;
        }).setRequiredTicks(() -> this.tempMultiplier > 0.0 && this.tempMultiplier < 1.0 ? (int)Math.ceil(1.0 / this.tempMultiplier) : 1).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min(currentMax, this.tempMultiplier > 0.0 && this.tempMultiplier < 1.0 ? 1 : (int)this.tempMultiplier);
        });
    }

    private void updateTemperature() {
        if (!this.temperatureSet) {
            this.biomeTemp = this.field_145850_b.func_225523_d_().func_226836_a_(this.func_174877_v()).func_225486_c(this.func_174877_v());
            this.temperatureSet = true;
        }
        this.heatCapacitor.handleHeat(MekanismConfig.general.evaporationSolarMultiplier.get() * (double)this.getActiveSolars() * this.heatCapacitor.getHeatCapacity());
        double biome = this.biomeTemp - 0.5;
        double base = biome > 0.0 ? biome * 20.0 : this.biomeTemp * 40.0;
        base += 300.0;
        if (Math.abs(this.getTemp() - base) < 0.001) {
            this.heatCapacitor.handleHeat(base * this.heatCapacitor.getHeatCapacity() - this.heatCapacitor.getHeat());
        }
        double incr = MekanismConfig.general.evaporationHeatDissipation.get() * Math.sqrt(Math.abs(this.heatCapacitor.getTemperature() - base));
        if (this.heatCapacitor.getTemperature() > base) {
            incr = -incr;
        }
        this.heatCapacitor.handleHeat(this.heatCapacitor.getHeatCapacity() * incr);
        this.totalLoss = incr < 0.0 ? -incr / this.heatCapacitor.getHeatCapacity() : 0.0;
        this.tempMultiplier = (Math.min(3000.0, this.heatCapacitor.getTemperature()) - 300.0) * MekanismConfig.general.evaporationTempMultiplier.get() * ((double)this.height / 18.0);
        this.markDirty(false);
    }

    public double getTemp() {
        return this.heatCapacitor.getTemperature();
    }

    private int getActiveSolars() {
        int ret = 0;
        for (IEvaporationSolar solar : this.solars) {
            if (solar == null || !solar.canSeeSun()) continue;
            ++ret;
        }
        return ret;
    }

    private boolean buildStructure() {
        Direction right = this.getRightSide();
        Direction left = this.getLeftSide();
        this.height = 0;
        this.controllerConflict = false;
        this.updatedThisTick = true;
        BlockPos startPoint = this.func_174877_v();
        while (MekanismUtils.getTileEntity(TileEntityThermalEvaporationBlock.class, (IBlockReader)this.field_145850_b, startPoint.func_177984_a()) != null) {
            startPoint = startPoint.func_177984_a();
        }
        BlockPos test = startPoint.func_177977_b().func_177967_a(right, 2);
        this.isLeftOnFace = MekanismUtils.getTileEntity(TileEntityThermalEvaporationBlock.class, (IBlockReader)this.field_145850_b, test) != null;
        if (!this.scanTopLayer(startPoint = startPoint.func_177967_a(left, this.isLeftOnFace ? 1 : 2))) {
            return false;
        }
        this.height = 1;
        BlockPos middlePointer = startPoint.func_177977_b();
        while (this.scanLowerLayer(middlePointer)) {
            middlePointer = middlePointer.func_177977_b();
        }
        this.renderY = middlePointer.func_177956_o() + 1;
        if (this.height < 3 || this.height > 18) {
            this.height = 0;
            return false;
        }
        this.markDirty(false);
        return true;
    }

    private boolean scanTopLayer(BlockPos currentPos) {
        Direction right = this.getRightSide();
        Direction back = this.getOppositeDirection();
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                BlockPos pointerPos = currentPos.func_177967_a(right, x).func_177967_a(back, z);
                TileEntity pointerTile = MekanismUtils.getTileEntity((IBlockReader)this.field_145850_b, pointerPos);
                int corner = this.getCorner(x, z);
                if (!(corner != -1 ? !this.addSolarPanel(pointerTile, corner) && (MekanismUtils.getTileEntity(TileEntityThermalEvaporationBlock.class, (IBlockReader)this.field_145850_b, pointerPos.func_177984_a()) != null || !this.addTankPart(pointerTile)) : (!(x != 1 && x != 2 || z != 1 && z != 2) ? !this.field_145850_b.func_175623_d(pointerPos) : MekanismUtils.getTileEntity(TileEntityThermalEvaporationBlock.class, (IBlockReader)this.field_145850_b, pointerPos.func_177984_a()) != null || !this.addTankPart(pointerTile)))) continue;
                return false;
            }
        }
        return true;
    }

    private void updateMaxFluid() {
        this.inputCapacity = this.height * 4 * 64000;
    }

    public int getMaxFluid() {
        return this.inputCapacity;
    }

    private int getCorner(int x, int z) {
        if (x == 0 && z == 0) {
            return 0;
        }
        if (x == 0 && z == 3) {
            return 1;
        }
        if (x == 3 && z == 0) {
            return 2;
        }
        if (x == 3 && z == 3) {
            return 3;
        }
        return -1;
    }

    private boolean scanLowerLayer(BlockPos currentPos) {
        Direction right = this.getRightSide();
        Direction back = this.getOppositeDirection();
        boolean foundCenter = false;
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                BlockPos pointerPos = currentPos.func_177967_a(right, x).func_177967_a(back, z);
                TileEntity pointerTile = MekanismUtils.getTileEntity((IBlockReader)this.field_145850_b, pointerPos);
                if (!(x != 1 && x != 2 || z != 1 && z != 2)) {
                    if (pointerTile instanceof TileEntityThermalEvaporationBlock) {
                        if (foundCenter) continue;
                        if (x == 1 && z == 1) {
                            foundCenter = true;
                            continue;
                        }
                        this.height = -1;
                        return false;
                    }
                    if (!foundCenter && this.field_145850_b.func_175623_d(pointerPos)) continue;
                    this.height = -1;
                    return false;
                }
                if (this.addTankPart(pointerTile)) continue;
                this.height = -1;
                return false;
            }
        }
        ++this.height;
        return !foundCenter;
    }

    private boolean addTankPart(TileEntity tile) {
        if (tile instanceof TileEntityThermalEvaporationBlock && (tile == this || !(tile instanceof TileEntityThermalEvaporationController))) {
            if (tile != this) {
                ((TileEntityThermalEvaporationBlock)tile).addToStructure(Coord4D.get(this));
                this.tankParts.add(Coord4D.get(tile));
            }
            return true;
        }
        if (tile != this && tile instanceof TileEntityThermalEvaporationController) {
            this.controllerConflict = true;
        }
        return false;
    }

    private boolean addSolarPanel(TileEntity tile, int i) {
        Optional<IEvaporationSolar> capability;
        if (tile != null && !tile.func_145837_r() && (capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.EVAPORATION_SOLAR_CAPABILITY, Direction.DOWN))).isPresent()) {
            this.solars[i] = capability.get();
            return true;
        }
        return false;
    }

    public BlockPos getRenderLocation() {
        Direction right = this.getRightSide();
        BlockPos renderLocation = this.field_174879_c.func_177972_a(right);
        renderLocation = this.isLeftOnFace ? renderLocation.func_177972_a(right) : renderLocation;
        renderLocation = renderLocation.func_177972_a(this.getLeftSide()).func_177972_a(this.getOppositeDirection());
        renderLocation = new BlockPos(renderLocation.func_177958_n(), this.renderY, renderLocation.func_177952_p());
        switch (this.getDirection()) {
            case SOUTH: {
                renderLocation = renderLocation.func_177978_c().func_177976_e();
                break;
            }
            case WEST: {
                renderLocation = renderLocation.func_177978_c();
                break;
            }
            case EAST: {
                renderLocation = renderLocation.func_177976_e();
            }
        }
        return renderLocation;
    }

    @Override
    public TileEntityThermalEvaporationController getController() {
        return this.getActive() ? this : null;
    }

    private void clearStructure() {
        for (Coord4D tankPart : this.tankParts) {
            TileEntityThermalEvaporationBlock tile = MekanismUtils.getTileEntity(TileEntityThermalEvaporationBlock.class, (IBlockReader)this.field_145850_b, tankPart.getPos());
            if (tile == null) continue;
            tile.controllerGone();
        }
        this.tankParts.clear();
        this.solars = new IEvaporationSolar[]{null, null, null, null};
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.getActive() && this.height > 2 && !this.inputTank.isEmpty()) {
            BlockPos corner1 = this.getRenderLocation();
            BlockPos corner2 = corner1.func_177965_g(2).func_177970_e(2).func_177981_b(this.height - 1);
            return new AxisAlignedBB(corner1, corner2);
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active != this.clientStructured) {
            this.clientStructured = active;
            this.sendUpdatePacket();
        }
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableInt.create(() -> this.height, value -> {
            this.height = value;
        }));
        container.track(SyncableBoolean.create(() -> this.controllerConflict, value -> {
            this.controllerConflict = value;
        }));
        container.track(SyncableDouble.create(() -> this.lastGain, value -> {
            this.lastGain = value;
        }));
        container.track(SyncableDouble.create(() -> this.totalLoss, value -> {
            this.totalLoss = value;
        }));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_218657_a("fluid", (INBT)this.inputTank.getFluid().writeToNBT(new CompoundNBT()));
        updateTag.func_74768_a("height", this.height);
        updateTag.func_74757_a("isLeftOnFace", this.isLeftOnFace);
        updateTag.func_74768_a("renderY", this.renderY);
        updateTag.func_74757_a("active", this.getActive());
        updateTag.func_74776_a("scale", this.prevScale);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setFluidStackIfPresent(tag, "fluid", fluid -> this.inputTank.setStack((FluidStack)fluid));
        NBTUtils.setIntIfPresent(tag, "height", value -> {
            this.height = value;
            this.updateMaxFluid();
        });
        NBTUtils.setBooleanIfPresent(tag, "isLeftOnFace", value -> {
            this.isLeftOnFace = value;
        });
        NBTUtils.setIntIfPresent(tag, "renderY", value -> {
            this.renderY = value;
        });
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevScale = scale;
        });
        NBTUtils.setBooleanIfPresent(tag, "active", active -> {
            if (this.clientStructured != active) {
                this.clientStructured = active;
                if (active) {
                    BlockPos corner1 = this.getRenderLocation().func_177976_e().func_177978_c().func_177977_b();
                    BlockPos corner2 = corner1.func_177965_g(3).func_177970_e(3).func_177981_b(this.height - 1);
                    Mekanism.proxy.doMultiblockSparkle(this, corner1, corner2, tile -> tile instanceof TileEntityThermalEvaporationBlock);
                }
            }
        });
    }
}

