/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class TileEntityThermalEvaporationBlock
extends TileEntityMekanism {
    public Coord4D master;
    private boolean attempted;

    public TileEntityThermalEvaporationBlock() {
        this(MekanismBlocks.THERMAL_EVAPORATION_BLOCK);
    }

    public TileEntityThermalEvaporationBlock(IBlockProvider provider) {
        super(provider);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.ticker == 5 && !this.attempted && this.master == null) {
            this.updateController();
        }
        this.attempted = false;
    }

    public void addToStructure(Coord4D controller) {
        this.master = controller;
    }

    public void controllerGone() {
        this.master = null;
    }

    public void onChunkUnloaded() {
        TileEntityThermalEvaporationController tile;
        super.onChunkUnloaded();
        if (this.master != null && (tile = this.getController()) != null) {
            tile.refresh();
        }
    }

    @Override
    public void onNeighborChange(Block block) {
        super.onNeighborChange(block);
        if (!this.isRemote()) {
            TileEntityThermalEvaporationController tile = this.getController();
            if (tile == null) {
                this.updateController();
            } else {
                tile.refresh();
            }
        }
    }

    private void updateController() {
        if (!(this instanceof TileEntityThermalEvaporationController)) {
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockPos checkPos = this.field_174879_c.func_177972_a(side);
                TileEntityThermalEvaporationController check = MekanismUtils.getTileEntity(TileEntityThermalEvaporationController.class, (IBlockReader)this.func_145831_w(), checkPos);
                if (check == null) continue;
                check.refresh();
                return;
            }
            TileEntityThermalEvaporationController found = new ControllerFinder().find();
            if (found != null) {
                found.refresh();
            }
        }
    }

    public TileEntityThermalEvaporationController getController() {
        if (this.master != null) {
            return MekanismUtils.getTileEntity(TileEntityThermalEvaporationController.class, (IBlockReader)this.func_145831_w(), this.master.getPos());
        }
        return null;
    }

    public class ControllerFinder {
        public TileEntityThermalEvaporationController found;
        public Set<BlockPos> iterated = new ObjectOpenHashSet();
        private Deque<BlockPos> checkQueue = new LinkedList<BlockPos>();

        public void loop(BlockPos startPos) {
            this.checkQueue.add(startPos);
            while (this.checkQueue.peek() != null) {
                BlockPos checkPos = this.checkQueue.pop();
                if (this.iterated.contains(checkPos)) continue;
                this.iterated.add(checkPos);
                TileEntity te = MekanismUtils.getTileEntity((IBlockReader)TileEntityThermalEvaporationBlock.this.func_145831_w(), checkPos);
                if (te instanceof TileEntityThermalEvaporationController) {
                    this.found = (TileEntityThermalEvaporationController)te;
                    return;
                }
                if (!(te instanceof TileEntityThermalEvaporationBlock)) continue;
                ((TileEntityThermalEvaporationBlock)te).attempted = true;
                for (Direction side : EnumUtils.DIRECTIONS) {
                    BlockPos coord = checkPos.func_177972_a(side);
                    if (this.iterated.contains(coord)) continue;
                    this.checkQueue.addLast(coord);
                }
            }
        }

        public TileEntityThermalEvaporationController find() {
            this.loop(TileEntityThermalEvaporationBlock.this.field_174879_c);
            return this.found;
        }
    }
}

