/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IIncrementalEnum;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.sustained.ISustainedData;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITileComponent;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.chemical.GasTankGasTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.slot.GasInventorySlot;
import mekanism.common.tier.GasTankTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.GasSlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.upgrade.GasTankUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.GasUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;

public class TileEntityGasTank
extends TileEntityMekanism
implements ISideConfiguration,
ISustainedData,
IHasGasMode {
    public GasTankGasTank gasTank;
    public GasTankTier tier;
    public GasMode dumping;
    public long currentGasAmount;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.GAS, TransmissionType.ITEM);
    private GasInventorySlot drainSlot;
    private GasInventorySlot fillSlot;

    public TileEntityGasTank(IBlockProvider blockProvider) {
        super(blockProvider);
        ConfigInfo gasConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, new InventorySlotInfo(true, true, this.drainSlot));
            itemConfig.addSlotInfo(DataType.OUTPUT, new InventorySlotInfo(true, true, this.fillSlot));
            itemConfig.setDataType(RelativeSide.TOP, DataType.INPUT);
            itemConfig.setDataType(RelativeSide.BOTTOM, DataType.OUTPUT);
            itemConfig.setCanEject(false);
        }
        if ((gasConfig = this.configComponent.getConfig(TransmissionType.GAS)) != null) {
            gasConfig.addSlotInfo(DataType.INPUT, new GasSlotInfo(true, false, this.gasTank));
            gasConfig.addSlotInfo(DataType.OUTPUT, new GasSlotInfo(false, true, this.gasTank));
            gasConfig.fill(DataType.INPUT);
            gasConfig.setDataType(RelativeSide.FRONT, DataType.OUTPUT);
            gasConfig.setEjecting(true);
        }
        this.dumping = GasMode.IDLE;
        this.ejectorComponent = new TileComponentEjector(this);
    }

    @Override
    protected void presetVariables() {
        this.tier = Attribute.getTier(this.getBlockType(), GasTankTier.class);
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.gasTank = GasTankGasTank.create(this.tier, (IMekanismGasHandler)this);
        builder.addTank(this.gasTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.drainSlot = GasInventorySlot.drain(this.gasTank, this, 16, 16);
        builder.addSlot(this.drainSlot);
        this.fillSlot = GasInventorySlot.fill(this.gasTank, this, 16, 48);
        builder.addSlot(this.fillSlot);
        this.drainSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.drainSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.fillSlot.setSlotType(ContainerSlotType.INPUT);
        this.fillSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        long newGasAmount;
        ConfigInfo config;
        super.onUpdateServer();
        this.drainSlot.drainTank();
        this.fillSlot.fillTank();
        if (!this.gasTank.isEmpty() && MekanismUtils.canFunction(this) && (this.tier == GasTankTier.CREATIVE || this.dumping != GasMode.DUMPING) && (config = this.configComponent.getConfig(TransmissionType.GAS)) != null && config.isEjecting()) {
            GasUtils.emit(config.getSidesForData(DataType.OUTPUT), this.gasTank, this, this.tier.getOutput());
        }
        if (this.tier != GasTankTier.CREATIVE) {
            long needed;
            if (this.dumping == GasMode.DUMPING) {
                this.gasTank.shrinkStack(this.tier.getStorage() / 400L, Action.EXECUTE);
            } else if (this.dumping == GasMode.DUMPING_EXCESS && (needed = this.gasTank.getNeeded()) < this.tier.getOutput()) {
                this.gasTank.shrinkStack(this.tier.getOutput() - needed, Action.EXECUTE);
            }
        }
        if ((newGasAmount = this.gasTank.getStored()) != this.currentGasAmount) {
            this.markDirty(false);
        }
        this.currentGasAmount = newGasAmount;
    }

    @Override
    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumping = (GasMode)this.dumping.getNext();
            this.markDirty(false);
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "dumping", GasMode::byIndexStatic, mode -> {
            this.dumping = mode;
        });
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("dumping", this.dumping.ordinal());
        return nbtTags;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getCapacity());
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public Direction getOrientation() {
        return this.getDirection();
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof GasTankUpgradeData) {
            GasTankUpgradeData data = (GasTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.drainSlot.setStack(data.drainSlot.getStack());
            this.fillSlot.setStack(data.fillSlot.getStack());
            this.dumping = data.dumping;
            this.gasTank.setStack(data.stored);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public GasTankUpgradeData getUpgradeData() {
        return new GasTankUpgradeData(this.redstone, this.getControlType(), this.drainSlot, this.fillSlot, this.dumping, (GasStack)this.gasTank.getStack(), this.getComponents());
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setInt(itemStack, "dumping", this.dumping.ordinal());
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.dumping = GasMode.byIndexStatic(ItemDataUtils.getInt(itemStack, "dumping"));
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("dumping", "dumping");
        return remap;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableEnum.create(GasMode::byIndexStatic, GasMode.IDLE, () -> this.dumping, value -> {
            this.dumping = value;
        }));
    }

    public static enum GasMode implements IIncrementalEnum<GasMode>,
    IHasTextComponent
    {
        IDLE(MekanismLang.IDLE),
        DUMPING_EXCESS(MekanismLang.DUMPING_EXCESS),
        DUMPING(MekanismLang.DUMPING);

        private static final GasMode[] MODES;
        private final ILangEntry langEntry;

        private GasMode(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        @Override
        @Nonnull
        public GasMode byIndex(int index) {
            return GasMode.byIndexStatic(index);
        }

        public static GasMode byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = GasMode.values();
        }
    }
}

