/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.IValveHandler;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityDynamicValve
extends TileEntityDynamicTank {
    public TileEntityDynamicValve() {
        super(MekanismBlocks.DYNAMIC_VALVE);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return side -> this.structure == null ? Collections.emptyList() : ((SynchronizedTankData)this.structure).getFluidTanks(side);
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.FLUID) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public FluidStack insertFluid(FluidStack stack, Direction side, Action action) {
        FluidStack ret = super.insertFluid(stack, side, action);
        if (ret.getAmount() < stack.getAmount() && action.execute() && this.structure != null) {
            Coord4D coord4D = Coord4D.get(this);
            for (IValveHandler.ValveData data : ((SynchronizedTankData)this.structure).valves) {
                if (!coord4D.equals(data.location)) continue;
                data.onTransfer();
            }
        }
        return ret;
    }

    @Override
    public int getRedstoneLevel() {
        return this.structure == null ? 0 : MekanismUtils.redstoneLevelFromContents(((SynchronizedTankData)this.structure).fluidTank.getFluidAmount(), ((SynchronizedTankData)this.structure).fluidTank.getCapacity());
    }
}

