/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.sustained.ISustainedData;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MinerEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.inventory.container.tile.filter.FilterContainer;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.interfaces.IHasSortableFilters;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MinerUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Region;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityDigitalMiner
extends TileEntityMekanism
implements ISustainedData,
IChunkLoader,
IAdvancedBoundingBlock,
ITileFilterHolder<MinerFilter<?>>,
IHasSortableFilters {
    public Map<ChunkPos, BitSet> oresToMine = new Object2ObjectOpenHashMap();
    public Int2ObjectMap<MinerFilter<?>> replaceMap = new Int2ObjectOpenHashMap();
    private HashList<MinerFilter<?>> filters = new HashList();
    public ThreadMinerSearch searcher = new ThreadMinerSearch(this);
    private int radius;
    public boolean inverse;
    private int minY;
    private int maxY = 60;
    public boolean doEject = false;
    public boolean doPull = false;
    public ItemStack missingStack = ItemStack.field_190927_a;
    public int delay;
    private int delayLength;
    public int cachedToMine;
    private boolean silkTouch;
    public boolean running;
    private int delayTicks;
    private boolean initCalc;
    private int numPowering;
    public boolean clientRendering;
    private TileComponentChunkLoader<TileEntityDigitalMiner> chunkLoaderComponent;
    private MinerEnergyContainer energyContainer;
    private List<IInventorySlot> mainSlots;
    private EnergyInventorySlot energySlot;

    public TileEntityDigitalMiner() {
        super(MekanismBlocks.DIGITAL_MINER);
        this.delayLength = MekanismConfig.general.minerTicksPerMine.get();
        this.initCalc = false;
        this.clientRendering = false;
        this.chunkLoaderComponent = new TileComponentChunkLoader<TileEntityDigitalMiner>(this);
        this.radius = 10;
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, this));
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        this.addDisabledCapabilities(EnergyCompatUtils.getEnabledEnergyCapabilities());
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MinerEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        this.mainSlots = new ArrayList<IInventorySlot>();
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection, side -> side == RelativeSide.TOP, side -> side == RelativeSide.BACK);
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert = (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isReplaceStack((ItemStack)stack);
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract = (stack, automationType) -> automationType == AutomationType.MANUAL || !this.isReplaceStack((ItemStack)stack);
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                BasicInventorySlot slot = BasicInventorySlot.at(canExtract, canInsert, (IMekanismInventory)this, 8 + slotX * 18, 80 + slotY * 18);
                builder.addSlot(slot, RelativeSide.BACK, RelativeSide.TOP);
                this.mainSlots.add(slot);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityDigitalMiner)this).func_145831_w(), this, 152, 6);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    private void closeInvalidScreens() {
        if (this.getActive() && !this.playersUsing.isEmpty()) {
            for (PlayerEntity player : new ObjectOpenHashSet((Collection)this.playersUsing)) {
                if (!(player.field_71070_bA instanceof IEmptyContainer) && !(player.field_71070_bA instanceof FilterContainer)) continue;
                player.func_71053_j();
            }
        }
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        this.closeInvalidScreens();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.closeInvalidScreens();
        if (!this.initCalc) {
            if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
                boolean prevRunning = this.running;
                this.reset();
                this.start();
                this.running = prevRunning;
            }
            this.initCalc = true;
        }
        this.energySlot.fillContainerOrConvert();
        if (MekanismUtils.canFunction(this) && this.running && this.searcher.state == ThreadMinerSearch.State.FINISHED && !this.oresToMine.isEmpty()) {
            FloatingLong energyPerTick = this.energyContainer.getEnergyPerTick();
            if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                this.setActive(true);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                if (this.delay == 0) {
                    boolean did = false;
                    Iterator<ChunkPos> it = this.oresToMine.keySet().iterator();
                    block0: while (it.hasNext()) {
                        ChunkPos chunk = it.next();
                        BitSet set = this.oresToMine.get(chunk);
                        int next = 0;
                        while (!did) {
                            int index = set.nextSetBit(next);
                            BlockPos pos = this.getPosFromIndex(index);
                            if (index == -1) {
                                it.remove();
                                continue block0;
                            }
                            if (!this.field_145850_b.func_195588_v(pos) || this.field_145850_b.func_175623_d(pos)) {
                                set.clear(index);
                                if (set.cardinality() == 0) {
                                    it.remove();
                                    continue block0;
                                }
                                next = index + 1;
                                continue;
                            }
                            boolean hasFilter = false;
                            BlockState state = this.field_145850_b.func_180495_p(pos);
                            for (MinerFilter<?> filter : this.filters) {
                                if (!filter.canFilter(state)) continue;
                                hasFilter = true;
                                break;
                            }
                            if (this.inverse == hasFilter || !this.canMine(pos)) {
                                set.clear(index);
                                if (set.cardinality() == 0) {
                                    it.remove();
                                    continue block0;
                                }
                                next = index + 1;
                                continue;
                            }
                            List<ItemStack> drops = MinerUtils.getDrops((ServerWorld)this.field_145850_b, pos, this.getSilkTouch(), this.field_174879_c);
                            if (!this.canInsert(drops) || !this.setReplace(pos, index)) continue block0;
                            did = true;
                            this.add(drops);
                            set.clear(index);
                            if (set.cardinality() == 0) {
                                it.remove();
                            }
                            this.field_145850_b.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                            this.missingStack = ItemStack.field_190927_a;
                            continue block0;
                        }
                    }
                    this.delay = this.getDelay();
                    this.updateCachedToMine();
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        TransitRequest ejectMap = this.getEjectItemMap();
        if (this.doEject && this.delayTicks == 0 && !ejectMap.isEmpty()) {
            TileEntity ejectInv = this.getEjectInv();
            TileEntity ejectTile = this.getEjectTile();
            if (ejectInv != null && ejectTile != null) {
                Optional<ILogisticalTransporter> capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)ejectInv, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, this.getOppositeDirection()));
                TransitRequest.TransitResponse response = capability.isPresent() ? capability.get().insert(ejectTile, ejectMap, null, true, 0) : InventoryUtils.putStackInInventory(ejectInv, ejectMap, this.getOppositeDirection(), false);
                if (!response.isEmpty()) {
                    response.use(ejectTile, this.getOppositeDirection());
                }
                this.delayTicks = 10;
            }
        } else if (this.delayTicks > 0) {
            --this.delayTicks;
        }
    }

    public int getDelay() {
        return this.delayLength;
    }

    public boolean getSilkTouch() {
        return this.silkTouch;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setSilkTouch(boolean newSilkTouch) {
        boolean changed = this.silkTouch != newSilkTouch;
        this.silkTouch = newSilkTouch;
        if (changed) {
            this.energyContainer.updateMinerEnergyPerTick();
        }
    }

    public void toggleSilkTouch() {
        this.setSilkTouch(!this.getSilkTouch());
        this.markDirty(false);
    }

    public void toggleInverse() {
        this.inverse = !this.inverse;
        this.markDirty(false);
    }

    public void toggleAutoEject() {
        this.doEject = !this.doEject;
        this.markDirty(false);
    }

    public void toggleAutoPull() {
        this.doPull = !this.doPull;
        this.markDirty(false);
    }

    public void setRadiusFromPacket(int newRadius) {
        this.setRadius(Math.min(Math.max(0, newRadius), MekanismConfig.general.minerMaxRadius.get()));
        this.sendUpdatePacket();
        this.markDirty(false);
    }

    private void setRadius(int newRadius) {
        boolean changed = this.radius != newRadius;
        this.radius = newRadius;
        if (changed) {
            this.energyContainer.updateMinerEnergyPerTick();
            if (this.func_145830_o() && !this.isRemote()) {
                this.getChunkLoader().refreshChunkTickets();
            }
        }
    }

    public void setMinYFromPacket(int newMinY) {
        this.setMinY(Math.min(Math.max(0, newMinY), this.getMaxY()));
        this.sendUpdatePacket();
        this.markDirty(false);
    }

    private void setMinY(int newMinY) {
        boolean changed = this.minY != newMinY;
        this.minY = newMinY;
        if (changed) {
            this.energyContainer.updateMinerEnergyPerTick();
        }
    }

    public void setMaxYFromPacket(int newMaxY) {
        if (this.field_145850_b != null) {
            this.setMaxY(Math.max(Math.min(newMaxY, this.field_145850_b.func_217301_I() - 1), this.getMinY()));
            this.sendUpdatePacket();
            this.markDirty(false);
        }
    }

    private void setMaxY(int newMaxY) {
        boolean changed = this.maxY != newMaxY;
        this.maxY = newMaxY;
        if (changed) {
            this.energyContainer.updateMinerEnergyPerTick();
        }
    }

    @Override
    public void moveUp(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex - 1);
        this.markDirty(false);
    }

    @Override
    public void moveDown(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex + 1);
        this.markDirty(false);
    }

    private boolean setReplace(BlockPos pos, int index) {
        if (this.field_145850_b == null) {
            return false;
        }
        ItemStack stack = this.getReplace(index);
        if (stack.func_190926_b()) {
            MinerFilter filter = (MinerFilter)this.replaceMap.get(index);
            if (filter == null || filter.replaceStack.func_190926_b() || !filter.requireStack) {
                this.field_145850_b.func_217377_a(pos, false);
                return true;
            }
            this.missingStack = filter.replaceStack;
            return false;
        }
        PlayerEntity fakePlayer = (PlayerEntity)Objects.requireNonNull(Mekanism.proxy.getDummyPlayer((ServerWorld)this.field_145850_b, this.field_174879_c).get());
        BlockState newState = StackUtils.getStateForPlacement(stack, pos, fakePlayer);
        if (newState == null || !newState.func_196955_c((IWorldReader)this.field_145850_b, pos)) {
            return false;
        }
        this.field_145850_b.func_175656_a(pos, newState);
        return true;
    }

    private boolean canMine(BlockPos pos) {
        if (this.field_145850_b == null) {
            return false;
        }
        BlockState state = this.field_145850_b.func_180495_p(pos);
        PlayerEntity dummy = (PlayerEntity)Objects.requireNonNull(Mekanism.proxy.getDummyPlayer((ServerWorld)this.field_145850_b, this.func_174877_v()).get());
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.field_145850_b, pos, state, dummy);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private ItemStack getReplace(int index) {
        InvStack stack;
        MinerFilter filter = (MinerFilter)this.replaceMap.get(index);
        if (filter == null || filter.replaceStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (IInventorySlot slot : this.mainSlots) {
            if (!filter.replaceStackMatches(slot.getStack())) continue;
            MekanismUtils.logMismatchedStackSize(slot.shrinkStack(1, Action.EXECUTE), 1L);
            return StackUtils.size(filter.replaceStack, 1);
        }
        if (this.doPull && this.getPullInv() != null && (stack = InventoryUtils.takeDefinedItem(this.getPullInv(), Direction.UP, filter.replaceStack.func_77946_l(), 1, 1)) != null) {
            stack.useAll();
            return StackUtils.size(filter.replaceStack, 1);
        }
        return ItemStack.field_190927_a;
    }

    private TransitRequest getEjectItemMap() {
        TransitRequest request = new TransitRequest();
        for (int i = this.mainSlots.size() - 1; i >= 0; --i) {
            IInventorySlot slot = this.mainSlots.get(i);
            ItemStack simulatedExtraction = slot.extractItem(slot.getCount(), Action.SIMULATE, AutomationType.EXTERNAL);
            if (simulatedExtraction.func_190926_b()) continue;
            request.addItem(simulatedExtraction, i);
        }
        return request;
    }

    public boolean canInsert(List<ItemStack> toInsert) {
        if (toInsert.isEmpty()) {
            return true;
        }
        int slots = this.mainSlots.size();
        Int2ObjectOpenHashMap cachedStacks = new Int2ObjectOpenHashMap();
        for (ItemStack stackToInsert : toInsert) {
            if (stackToInsert.func_190926_b()) continue;
            ItemStack stack = stackToInsert.func_77946_l();
            for (int i = 0; i < slots; ++i) {
                IInventorySlot slot = this.mainSlots.get(i);
                boolean wasEmpty = slot.isEmpty();
                if (wasEmpty && cachedStacks.containsKey(i)) {
                    ItemCount cachedItem = (ItemCount)cachedStacks.get(i);
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)cachedItem.stack)) continue;
                    int limit = slot.getLimit(stack);
                    int stackSize = stack.func_190916_E();
                    int total = stackSize + cachedItem.count;
                    if (total <= limit) {
                        cachedItem.count = total;
                        stack = ItemStack.field_190927_a;
                        break;
                    }
                    int toAdd = total - limit;
                    if (toAdd <= 0) continue;
                    ItemCount itemCount = cachedItem;
                    itemCount.count = itemCount.count + toAdd;
                    stack = StackUtils.size(stack, stackSize - toAdd);
                    continue;
                }
                int stackSize = stack.func_190916_E();
                stack = slot.insertItem(stack, Action.SIMULATE, AutomationType.INTERNAL);
                int remainderSize = stack.func_190916_E();
                if (wasEmpty && remainderSize < stackSize) {
                    cachedStacks.put(i, (Object)new ItemCount(stackToInsert, stackSize - remainderSize));
                }
                if (stack.func_190926_b()) break;
            }
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private TileEntity getPullInv() {
        return MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177981_b(2));
    }

    private TileEntity getEjectInv() {
        return MekanismUtils.getTileEntity((IBlockReader)this.field_145850_b, this.func_174877_v().func_177984_a().func_177967_a(this.getOppositeDirection(), 2));
    }

    private void add(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            IInventorySlot slot;
            Iterator<IInventorySlot> iterator = this.mainSlots.iterator();
            while (iterator.hasNext() && !(stack = (slot = iterator.next()).insertItem(stack, Action.EXECUTE, AutomationType.INTERNAL)).func_190926_b()) {
            }
        }
    }

    public void start() {
        if (this.func_145831_w() == null) {
            return;
        }
        if (this.searcher.state == ThreadMinerSearch.State.IDLE) {
            BlockPos startingPos = this.getStartingPos();
            this.searcher.setChunkCache(new Region(this.func_145831_w(), startingPos, startingPos.func_177982_a(this.getDiameter(), this.getMaxY() - this.getMinY() + 1, this.getDiameter())));
            this.searcher.start();
        }
        this.running = true;
        this.markDirty(false);
    }

    public void stop() {
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.searcher.interrupt();
            this.reset();
            return;
        }
        if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
            this.running = false;
        }
        this.markDirty(false);
    }

    public void reset() {
        this.searcher = new ThreadMinerSearch(this);
        this.running = false;
        this.cachedToMine = 0;
        this.oresToMine.clear();
        this.replaceMap.clear();
        this.missingStack = ItemStack.field_190927_a;
        this.setActive(false);
        this.markDirty(false);
    }

    public boolean isReplaceStack(ItemStack stack) {
        for (MinerFilter<?> filter : this.filters) {
            if (!filter.replaceStackMatches(stack)) continue;
            return true;
        }
        return false;
    }

    private void updateCachedToMine() {
        this.cachedToMine = this.oresToMine.values().stream().mapToInt(BitSet::cardinality).sum();
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.running = nbtTags.func_74767_n("running");
        this.delay = nbtTags.func_74762_e("delay");
        this.numPowering = nbtTags.func_74762_e("numPowering");
        NBTUtils.setEnumIfPresent(nbtTags, "state", ThreadMinerSearch.State::byIndexStatic, state -> {
            this.searcher.state = state;
        });
        this.setConfigurationData(nbtTags);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.reset();
        }
        nbtTags.func_74757_a("running", this.running);
        nbtTags.func_74768_a("delay", this.delay);
        nbtTags.func_74768_a("numPowering", this.numPowering);
        nbtTags.func_74768_a("state", this.searcher.state.ordinal());
        return this.getConfigurationData(nbtTags);
    }

    public int getTotalSize() {
        return this.getDiameter() * this.getDiameter() * (this.getMaxY() - this.getMinY() + 1);
    }

    public int getDiameter() {
        return this.radius * 2 + 1;
    }

    public BlockPos getStartingPos() {
        return new BlockPos(this.func_174877_v().func_177958_n() - this.radius, this.getMinY(), this.func_174877_v().func_177952_p() - this.radius);
    }

    private BlockPos getPosFromIndex(int index) {
        int diameter = this.getDiameter();
        BlockPos start = this.getStartingPos();
        return start.func_177982_a(index % diameter, index / diameter / diameter, index / diameter % diameter);
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.clientRendering) {
            return INFINITE_EXTENT_AABB;
        }
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    @Override
    public void onPlace() {
        if (this.field_145850_b != null) {
            BlockPos pos = this.func_174877_v();
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        BlockPos boundingPos = pos.func_177982_a(x, y, z);
                        MekanismUtils.makeAdvancedBoundingBlock((IWorld)this.field_145850_b, boundingPos, pos);
                        this.field_145850_b.func_195593_d(boundingPos, this.getBlockType());
                    }
                }
            }
        }
    }

    @Override
    public void onBreak() {
        if (this.field_145850_b != null) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(x, y, z), false);
                    }
                }
            }
        }
    }

    private TileEntity getEjectTile() {
        return MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177984_a().func_177972_a(this.getOppositeDirection()));
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public CompoundNBT getConfigurationData(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("radius", this.getRadius());
        nbtTags.func_74768_a("min", this.getMinY());
        nbtTags.func_74768_a("max", this.getMaxY());
        nbtTags.func_74757_a("eject", this.doEject);
        nbtTags.func_74757_a("pull", this.doPull);
        nbtTags.func_74757_a("silkTouch", this.getSilkTouch());
        nbtTags.func_74757_a("inverse", this.inverse);
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (MinerFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            nbtTags.func_218657_a("filters", (INBT)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(CompoundNBT nbtTags) {
        this.setRadius(Math.min(nbtTags.func_74762_e("radius"), MekanismConfig.general.minerMaxRadius.get()));
        NBTUtils.setIntIfPresent(nbtTags, "min", this::setMinY);
        NBTUtils.setIntIfPresent(nbtTags, "max", this::setMaxY);
        this.doEject = nbtTags.func_74767_n("eject");
        this.doPull = nbtTags.func_74767_n("pull");
        NBTUtils.setBooleanIfPresent(nbtTags, "silkTouch", this::setSilkTouch);
        this.inverse = nbtTags.func_74767_n("inverse");
        this.filters.clear();
        if (nbtTags.func_150297_b("filters", 9)) {
            ListNBT tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof MinerFilter)) continue;
                this.filters.add((MinerFilter)filter);
            }
        }
    }

    @Override
    public String getDataType() {
        return this.getBlockType().func_149739_a();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setInt(itemStack, "radius", this.getRadius());
        ItemDataUtils.setInt(itemStack, "min", this.getMinY());
        ItemDataUtils.setInt(itemStack, "max", this.getMaxY());
        ItemDataUtils.setBoolean(itemStack, "eject", this.doEject);
        ItemDataUtils.setBoolean(itemStack, "pull", this.doPull);
        ItemDataUtils.setBoolean(itemStack, "silkTouch", this.getSilkTouch());
        ItemDataUtils.setBoolean(itemStack, "inverse", this.inverse);
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (MinerFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "radius", 3)) {
            this.setRadius(Math.min(ItemDataUtils.getInt(itemStack, "radius"), MekanismConfig.general.minerMaxRadius.get()));
        }
        if (ItemDataUtils.hasData(itemStack, "min", 3)) {
            this.setMinY(ItemDataUtils.getInt(itemStack, "min"));
        }
        if (ItemDataUtils.hasData(itemStack, "max", 3)) {
            this.setMaxY(ItemDataUtils.getInt(itemStack, "max"));
        }
        if (ItemDataUtils.hasData(itemStack, "eject", 1)) {
            this.doEject = ItemDataUtils.getBoolean(itemStack, "eject");
        }
        if (ItemDataUtils.hasData(itemStack, "pull", 1)) {
            this.doPull = ItemDataUtils.getBoolean(itemStack, "pull");
        }
        if (ItemDataUtils.hasData(itemStack, "silkTouch", 1)) {
            this.setSilkTouch(ItemDataUtils.getBoolean(itemStack, "silkTouch"));
        }
        if (ItemDataUtils.hasData(itemStack, "inverse", 1)) {
            this.inverse = ItemDataUtils.getBoolean(itemStack, "inverse");
        }
        if (ItemDataUtils.hasData(itemStack, "filters", 9)) {
            ListNBT tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof MinerFilter)) continue;
                this.filters.add((MinerFilter)filter);
            }
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("radius", "radius");
        remap.put("min", "min");
        remap.put("max", "max");
        remap.put("eject", "eject");
        remap.put("pull", "pull");
        remap.put("silkTouch", "silkTouch");
        remap.put("inverse", "inverse");
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.delayLength = MekanismUtils.getTicks(this, MekanismConfig.general.minerTicksPerMine.get());
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getOffsetCapabilityIfEnabled(@Nonnull Capability<T> capability, Direction side, @Nonnull Vec3i offset) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.hasInventory()) {
                return this.itemHandlerManager.resolve(capability, side);
            }
            return LazyOptional.empty();
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            if (this.canHandleEnergy()) {
                return this.energyHandlerManager.resolve(capability, side);
            }
            return LazyOptional.empty();
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@Nonnull Capability<?> capability, Direction side, @Nonnull Vec3i offset) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (offset.equals((Object)new Vec3i(0, 1, 0))) {
                return side != Direction.UP;
            }
            Direction back = this.getOppositeDirection();
            if (offset.equals((Object)new Vec3i(back.func_82601_c(), 1, back.func_82599_e()))) {
                return side != back;
            }
            return true;
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            if (offset.equals((Object)Vec3i.field_177959_e)) {
                return side != Direction.DOWN;
            }
            Direction left = this.getLeftSide();
            Direction right = this.getRightSide();
            if (offset.equals((Object)new Vec3i(left.func_82601_c(), 0, left.func_82599_e()))) {
                return side != left;
            }
            if (offset.equals((Object)new Vec3i(right.func_82601_c(), 0, right.func_82599_e()))) {
                return side != right;
            }
            return true;
        }
        return false;
    }

    public TileComponentChunkLoader<TileEntityDigitalMiner> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        int chunkXMin = this.field_174879_c.func_177958_n() - this.radius >> 4;
        int chunkXMax = this.field_174879_c.func_177958_n() + this.radius >> 4;
        int chunkZMin = this.field_174879_c.func_177958_n() - this.radius >> 4;
        int chunkZMax = this.field_174879_c.func_177952_p() + this.radius >> 4;
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        for (int chunkX = chunkXMin; chunkX <= chunkXMax; ++chunkX) {
            for (int chunkZ = chunkZMin; chunkZ <= chunkZMax; ++chunkZ) {
                set.add(new ChunkPos(chunkX, chunkZ));
            }
        }
        return set;
    }

    @Override
    public HashList<MinerFilter<?>> getFilters() {
        return this.filters;
    }

    public MinerEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        this.addConfigContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.doEject, value -> {
            this.doEject = value;
        }));
        container.track(SyncableBoolean.create(() -> this.doPull, value -> {
            this.doPull = value;
        }));
        container.track(SyncableBoolean.create(() -> this.running, value -> {
            this.running = value;
        }));
        container.track(SyncableBoolean.create(this::getSilkTouch, this::setSilkTouch));
        container.track(SyncableEnum.create(ThreadMinerSearch.State::byIndexStatic, ThreadMinerSearch.State.IDLE, () -> this.searcher.state, value -> {
            this.searcher.state = value;
        }));
        container.track(SyncableInt.create(() -> !this.isRemote() && this.searcher.state == ThreadMinerSearch.State.SEARCHING ? this.searcher.found : this.cachedToMine, value -> {
            this.cachedToMine = value;
        }));
        container.track(SyncableItemStack.create(() -> this.missingStack, value -> {
            this.missingStack = value;
        }));
    }

    public void addConfigContainerTrackers(MekanismContainer container) {
        container.track(SyncableInt.create(this::getRadius, this::setRadius));
        container.track(SyncableInt.create(this::getMinY, this::setMinY));
        container.track(SyncableInt.create(this::getMaxY, this::setMaxY));
        container.track(SyncableBoolean.create(() -> this.inverse, value -> {
            this.inverse = value;
        }));
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            this.filters = value instanceof HashList ? (HashList)value : new HashList(value);
        }));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74768_a("radius", this.getRadius());
        updateTag.func_74768_a("min", this.getMinY());
        updateTag.func_74768_a("max", this.getMaxY());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setIntIfPresent(tag, "radius", this::setRadius);
        NBTUtils.setIntIfPresent(tag, "min", this::setMinY);
        NBTUtils.setIntIfPresent(tag, "max", this::setMaxY);
    }

    private static class ItemCount {
        private final ItemStack stack;
        private int count;

        public ItemCount(ItemStack stack, int count) {
            this.stack = stack;
            this.count = count;
        }
    }
}

