/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.Range3D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public abstract class BasePacketHandler {
    private int index = 0;

    protected static SimpleChannel createChannel(ResourceLocation name) {
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions(BasePacketHandler.getProtocolVersion()::equals).serverAcceptedVersions(BasePacketHandler.getProtocolVersion()::equals).networkProtocolVersion(BasePacketHandler::getProtocolVersion).simpleChannel();
    }

    private static String getProtocolVersion() {
        return Mekanism.instance == null ? "999.999.999" : Mekanism.instance.versionNumber.toString();
    }

    public static String readString(PacketBuffer buffer) {
        return buffer.func_150789_c(Short.MAX_VALUE);
    }

    public static void log(String log) {
        if (MekanismConfig.general.logPackets.get()) {
            Mekanism.logger.info(log);
        }
    }

    public static PlayerEntity getPlayer(Supplier<NetworkEvent.Context> context) {
        return Mekanism.proxy.getPlayer(context);
    }

    protected abstract SimpleChannel getChannel();

    public abstract void initialize();

    protected <MSG> void registerClientToServer(Class<MSG> type, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer) {
        this.getChannel().registerMessage(this.index++, type, encoder, decoder, consumer, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    protected <MSG> void registerServerToClient(Class<MSG> type, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer) {
        this.getChannel().registerMessage(this.index++, type, encoder, decoder, consumer, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public <MSG> void sendTo(MSG message, ServerPlayerEntity player) {
        this.getChannel().sendTo(message, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public <MSG> void sendToAll(MSG message) {
        this.getChannel().send(PacketDistributor.ALL.noArg(), message);
    }

    public <MSG> void sendToDimension(MSG message, DimensionType dimension) {
        this.getChannel().send(PacketDistributor.DIMENSION.with(() -> dimension), message);
    }

    public <MSG> void sendToServer(MSG message) {
        this.getChannel().sendToServer(message);
    }

    public <MSG> void sendToAllTracking(MSG message, Entity entity) {
        this.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public <MSG> void sendToAllTracking(MSG message, TileEntity tile) {
        this.sendToAllTracking(message, tile.func_145831_w(), tile.func_174877_v());
    }

    public <MSG> void sendToAllTracking(MSG message, World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            ((ServerWorld)world).func_72863_F().field_217237_a.func_219097_a(new ChunkPos(pos), false).forEach(p -> this.sendTo(message, (ServerPlayerEntity)p));
        } else {
            this.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)), message);
        }
    }

    public <MSG> void sendToReceivers(MSG message, DynamicNetwork<?, ?, ?> network) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            Range3D range = network.getPacketRange();
            PlayerList playerList = server.func_184103_al();
            int radius = playerList.func_72395_o() * 16;
            for (ServerPlayerEntity player : playerList.func_181057_v()) {
                if (range.dimension != player.field_71093_bK) continue;
                BlockPos playerPosition = player.func_180425_c();
                int playerX = playerPosition.func_177958_n();
                int playerZ = playerPosition.func_177952_p();
                if (!((double)(playerX + radius) + 1.99999 > (double)range.xMin) || !((double)range.xMax + 0.99999 > (double)(playerX - radius)) || !((double)(playerZ + radius) + 1.99999 > (double)range.zMin) || !((double)range.zMax + 0.99999 > (double)(playerZ - radius))) continue;
                this.sendTo(message, player);
            }
        }
    }
}

