/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.fluxnetworks;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.energy.EnergyCompatUtils;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FNStrictEnergyHandler
implements IStrictEnergyHandler {
    private final IFNEnergyStorage storage;

    public FNStrictEnergyHandler(IFNEnergyStorage storage) {
        this.storage = storage;
    }

    @Override
    public int getEnergyContainerCount() {
        return 1;
    }

    @Override
    public FloatingLong getEnergy(int container) {
        return container == 0 ? EnergyCompatUtils.EnergyType.FORGE.convertFrom(this.storage.getEnergyStoredL()) : FloatingLong.ZERO;
    }

    @Override
    public void setEnergy(int container, FloatingLong energy) {
    }

    @Override
    public FloatingLong getMaxEnergy(int container) {
        return container == 0 ? EnergyCompatUtils.EnergyType.FORGE.convertFrom(this.storage.getMaxEnergyStoredL()) : FloatingLong.ZERO;
    }

    @Override
    public FloatingLong getNeededEnergy(int container) {
        return container == 0 ? EnergyCompatUtils.EnergyType.FORGE.convertFrom(Math.max(0L, this.storage.getMaxEnergyStoredL() - this.storage.getEnergyStoredL())) : FloatingLong.ZERO;
    }

    @Override
    public FloatingLong insertEnergy(int container, FloatingLong amount, @Nonnull Action action) {
        if (container == 0 && this.storage.canReceiveL()) {
            long toInsert = EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(amount);
            return EnergyCompatUtils.EnergyType.FORGE.convertFrom(toInsert - this.storage.receiveEnergyL(toInsert, action.simulate()));
        }
        return amount;
    }

    @Override
    public FloatingLong extractEnergy(int container, FloatingLong amount, @Nonnull Action action) {
        if (container == 0 && this.storage.canExtractL()) {
            return EnergyCompatUtils.EnergyType.FORGE.convertFrom(this.storage.extractEnergyL(EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(amount), action.simulate()));
        }
        return FloatingLong.ZERO;
    }
}

