/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.distribution;

import mekanism.common.distribution.SplitInfo;

public class LongSplitInfo
extends SplitInfo<Long> {
    private long amountToSplit;
    private long amountPerTarget;
    private long sentSoFar;
    private long remainder;

    public LongSplitInfo(long amountToSplit, int totalTargets) {
        super(totalTargets);
        this.amountToSplit = amountToSplit;
        this.amountPerTarget = this.toSplitAmong == 0 ? 0L : amountToSplit / (long)this.toSplitAmong;
        this.remainder = this.toSplitAmong == 0 ? 0L : amountToSplit % (long)this.toSplitAmong;
    }

    @Override
    public void send(Long amountNeeded) {
        this.amountToSplit -= amountNeeded.longValue();
        this.sentSoFar += amountNeeded.longValue();
        --this.toSplitAmong;
        if (amountNeeded != this.amountPerTarget && this.toSplitAmong != 0) {
            long amountPerLast = this.amountPerTarget;
            this.amountPerTarget = this.amountToSplit / (long)this.toSplitAmong;
            if (!this.amountPerChanged && this.amountPerTarget != amountPerLast) {
                this.amountPerChanged = true;
            }
        }
    }

    @Override
    public Long getShareAmount() {
        return this.amountPerTarget;
    }

    @Override
    public Long getRemainderAmount() {
        return this.amountPerTarget + (long)(this.remainder > 0L ? 1 : 0);
    }

    @Override
    public void updateRemainder() {
        this.remainder = Math.max(0L, this.remainder - 1L);
    }

    @Override
    public Long getTotalSent() {
        return this.sentSoFar;
    }
}

