/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TransporterManager {
    private static Map<Coord4D, Set<TransporterStack>> flowingStacks = new Object2ObjectOpenHashMap();

    public static void reset() {
        flowingStacks.clear();
    }

    public static void add(TransporterStack stack) {
        flowingStacks.computeIfAbsent(stack.getDest(), k -> new ObjectOpenHashSet()).add(stack);
    }

    public static void remove(TransporterStack stack) {
        if (stack.hasPath() && stack.getPathType() != TransporterStack.Path.NONE) {
            flowingStacks.get(stack.getDest()).remove(stack);
        }
    }

    private static int simulateInsert(IItemHandler handler, InventoryInfo inventoryInfo, ItemStack stack, int count) {
        int maxStackSize = stack.func_77976_d();
        for (int slot = 0; slot < handler.getSlots() && count != 0; ++slot) {
            int max = handler.getSlotLimit(slot);
            if (max == 0 || !handler.isItemValid(slot, stack)) continue;
            int destCount = inventoryInfo.stackSizes.getInt(slot);
            int mergedCount = count + destCount;
            boolean needsSimulation = false;
            if (destCount > 0) {
                if (!InventoryUtils.areItemsStackable((ItemStack)inventoryInfo.inventory.get(slot), stack)) continue;
                if (max > maxStackSize && mergedCount > maxStackSize) {
                    needsSimulation = true;
                    if (stack.func_190916_E() <= maxStackSize) {
                        stack = count > maxStackSize ? StackUtils.size(stack, count) : StackUtils.size(stack, maxStackSize + 1);
                    }
                }
            } else {
                needsSimulation = true;
            }
            if (needsSimulation) {
                ItemStack simulatedRemainder = handler.insertItem(slot, stack, true);
                int accepted = stack.func_190916_E() - simulatedRemainder.func_190916_E();
                if (accepted == 0) continue;
                if (accepted < count) {
                    max = accepted;
                }
                if (destCount == 0) {
                    inventoryInfo.inventory.set(slot, (Object)StackUtils.size(stack, 1));
                }
            }
            if (mergedCount > max) {
                inventoryInfo.stackSizes.set(slot, max);
                count = mergedCount - max;
                continue;
            }
            inventoryInfo.stackSizes.set(slot, mergedCount);
            return 0;
        }
        return count;
    }

    public static boolean didEmit(ItemStack stack, ItemStack returned) {
        return returned.func_190926_b() || returned.func_190916_E() < stack.func_190916_E();
    }

    public static ItemStack getToUse(ItemStack stack, ItemStack returned) {
        return returned.func_190926_b() ? stack : StackUtils.size(stack, stack.func_190916_E() - returned.func_190916_E());
    }

    public static TransitRequest.TransitResponse getPredictedInsert(TileEntity tile, EnumColor color, TransitRequest request, Direction side) {
        Optional capability;
        ISideConfiguration config;
        if (tile instanceof ISideConfiguration && (config = (ISideConfiguration)tile).getEjector().hasStrictInput()) {
            Direction tileSide = config.getOrientation();
            EnumColor configColor = config.getEjector().getInputColor(RelativeSide.fromDirections(tileSide, side.func_176734_d()));
            if (configColor != null && configColor != color) {
                return request.getEmptyResponse();
            }
        }
        if (!(capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()))).isPresent()) {
            Mekanism.logger.error("Failed to predict insert; not an IItemHandler: {}", (Object)tile);
            return request.getEmptyResponse();
        }
        IItemHandler handler = (IItemHandler)capability.get();
        InventoryInfo inventoryInfo = new InventoryInfo(handler);
        Set<TransporterStack> transporterStacks = flowingStacks.get(Coord4D.get(tile));
        if (transporterStacks != null) {
            for (TransporterStack transporterStack : transporterStacks) {
                if (transporterStack == null || transporterStack.getPathType() == TransporterStack.Path.NONE || TransporterManager.simulateInsert(handler, inventoryInfo, transporterStack.itemStack, transporterStack.itemStack.func_190916_E()) <= 0) continue;
                return request.getEmptyResponse();
            }
        }
        for (Map.Entry entry : request.getItemMap().entrySet()) {
            int numToSend;
            ItemStack stack = ((HashedItem)entry.getKey()).getStack();
            int numLeftOver = TransporterManager.simulateInsert(handler, inventoryInfo, stack, numToSend = ((TransitRequest.SlotData)entry.getValue()).getTotalCount());
            if (numLeftOver == numToSend) continue;
            return request.createResponse(StackUtils.size(stack, numToSend - numLeftOver), (TransitRequest.SlotData)entry.getValue());
        }
        return request.getEmptyResponse();
    }

    private static class InventoryInfo {
        private NonNullList<ItemStack> inventory;
        private IntList stackSizes = new IntArrayList();

        public InventoryInfo(IItemHandler handler) {
            this.inventory = NonNullList.func_191197_a((int)handler.getSlots(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                this.inventory.set(i, (Object)stack);
                this.stackSizes.add(stack.func_190916_E());
            }
        }
    }
}

