/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class Finder {
    public abstract boolean modifies(ItemStack var1);

    public static class ModIDFinder
    extends Finder {
        public String modID;

        public ModIDFinder(String mod) {
            this.modID = mod;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            String id = stack.func_77973_b().getRegistryName().func_110624_b();
            if (this.modID.equals(id) || this.modID.equals("*")) {
                return true;
            }
            if (this.modID.endsWith("*") && !this.modID.startsWith("*")) {
                return id.startsWith(this.modID.substring(0, this.modID.length() - 1));
            }
            if (this.modID.startsWith("*") && !this.modID.endsWith("*")) {
                return id.endsWith(this.modID.substring(1));
            }
            if (this.modID.startsWith("*") && this.modID.endsWith("*")) {
                return id.contains(this.modID.substring(1, this.modID.length() - 1));
            }
            return false;
        }
    }

    public static class MaterialFinder
    extends Finder {
        public Material materialType;

        public MaterialFinder(Material type) {
            this.materialType = type;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) {
                return false;
            }
            return Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P().func_185904_a() == this.materialType;
        }
    }

    public static class ItemStackFinder
    extends Finder {
        public ItemStack itemType;

        public ItemStackFinder(ItemStack type) {
            this.itemType = type;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            return this.itemType.func_77973_b() == stack.func_77973_b();
        }
    }

    public static class TagFinder
    extends Finder {
        public final String tagName;

        public TagFinder(String name) {
            this.tagName = name;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            Set tags = stack.func_77973_b().getTags();
            if (tags.isEmpty()) {
                return false;
            }
            for (ResourceLocation tag : tags) {
                String tagAsString = tag.toString();
                if (this.tagName.equals(tagAsString) || this.tagName.equals("*")) {
                    return true;
                }
                if (!(this.tagName.endsWith("*") && !this.tagName.startsWith("*") ? tagAsString.startsWith(this.tagName.substring(0, this.tagName.length() - 1)) : (this.tagName.startsWith("*") && !this.tagName.endsWith("*") ? tagAsString.endsWith(this.tagName.substring(1)) : this.tagName.startsWith("*") && this.tagName.endsWith("*") && tagAsString.contains(this.tagName.substring(1, this.tagName.length() - 1))))) continue;
                return true;
            }
            return false;
        }
    }

    public static class FirstFinder
    extends Finder {
        @Override
        public boolean modifies(ItemStack stack) {
            return true;
        }
    }
}

