/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.tank.TankCache;
import mekanism.common.multiblock.IValveHandler;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityDynamicValve;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class TankUpdateProtocol
extends UpdateProtocol<SynchronizedTankData> {
    public static final int FLUID_PER_TANK = 64000;

    public TankUpdateProtocol(TileEntityDynamicTank tile) {
        super(tile);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        return BlockTypeTile.is(this.pointer.func_145831_w().func_180495_p(new BlockPos(x, y, z)).func_177230_c(), MekanismBlockTypes.DYNAMIC_TANK);
    }

    protected TankCache getNewCache() {
        return new TankCache();
    }

    @Override
    protected SynchronizedTankData getNewStructure() {
        return new SynchronizedTankData((TileEntityDynamicTank)this.pointer);
    }

    @Override
    protected MultiblockManager<SynchronizedTankData> getManager() {
        return Mekanism.tankManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedTankData> cache, MultiblockCache<SynchronizedTankData> merge) {
        TankCache tankCache = (TankCache)cache;
        TankCache mergeCache = (TankCache)merge;
        StorageUtils.mergeTanks(tankCache.getFluidTanks(null).get(0), mergeCache.getFluidTanks(null).get(0));
        tankCache.editMode = mergeCache.editMode;
        List<ItemStack> rejects = StackUtils.getMergeRejects(tankCache.getInventorySlots(null), mergeCache.getInventorySlots(null));
        if (!rejects.isEmpty()) {
            rejectedItems.addAll(rejects);
        }
        StackUtils.merge(tankCache.getInventorySlots(null), mergeCache.getInventorySlots(null));
    }

    @Override
    protected void onFormed() {
        super.onFormed();
        if (!((SynchronizedTankData)this.structureFound).fluidTank.isEmpty()) {
            ((SynchronizedTankData)this.structureFound).fluidTank.setStackSize(Math.min(((SynchronizedTankData)this.structureFound).fluidTank.getFluidAmount(), ((SynchronizedTankData)this.structureFound).getTankCapacity()), Action.EXECUTE);
        }
    }

    @Override
    protected void onStructureCreated(SynchronizedTankData structure, int origX, int origY, int origZ, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        for (Coord4D obj : structure.locations) {
            if (MekanismUtils.getTileEntity(TileEntityDynamicValve.class, (IBlockReader)this.pointer.func_145831_w(), obj.getPos()) == null) continue;
            IValveHandler.ValveData data = new IValveHandler.ValveData();
            data.location = obj;
            data.side = this.getSide(obj, origX + xmin, origX + xmax, origY + ymin, origY + ymax, origZ + zmin, origZ + zmax);
            structure.valves.add(data);
        }
    }
}

