/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.base.ContainerEditMode;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.MultiblockFluidTank;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.multiblock.IValveHandler;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.TileEntityDynamicTank;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;

public class SynchronizedTankData
extends SynchronizedData<SynchronizedTankData>
implements IMekanismFluidHandler {
    public MultiblockFluidTank<TileEntityDynamicTank> fluidTank;
    public ContainerEditMode editMode = ContainerEditMode.BOTH;
    public Set<IValveHandler.ValveData> valves = new ObjectOpenHashSet();
    @Nonnull
    private List<IInventorySlot> inventorySlots;
    private List<IExtendedFluidTank> fluidTanks;
    private int tankCapacity;

    public SynchronizedTankData(TileEntityDynamicTank tile) {
        this.fluidTank = MultiblockFluidTank.create(tile, () -> tile.structure == null ? 0 : ((SynchronizedTankData)tile.structure).getTankCapacity(), BasicFluidTank.alwaysTrue);
        this.fluidTanks = Collections.singletonList(this.fluidTank);
        this.inventorySlots = this.createBaseInventorySlots();
    }

    private List<IInventorySlot> createBaseInventorySlots() {
        ArrayList<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
        FluidInventorySlot input = FluidInventorySlot.input(this.fluidTank, this, 146, 20);
        inventorySlots.add(input);
        inventorySlots.add(OutputInventorySlot.at(this, 146, 51));
        input.setSlotType(ContainerSlotType.INPUT);
        return inventorySlots;
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    public void setInventoryData(@Nonnull List<IInventorySlot> toCopy) {
        for (int i = 0; i < toCopy.size(); ++i) {
            if (i >= this.inventorySlots.size()) continue;
            this.inventorySlots.get(i).deserializeNBT(toCopy.get(i).serializeNBT());
        }
    }

    public void setTankData(@Nonnull List<IExtendedFluidTank> toCopy) {
        for (int i = 0; i < toCopy.size(); ++i) {
            if (i >= this.fluidTanks.size()) continue;
            this.fluidTanks.get(i).deserializeNBT((INBT)toCopy.get(i).serializeNBT());
        }
    }

    public int getTankCapacity() {
        return this.tankCapacity;
    }

    @Override
    public void setVolume(int volume) {
        super.setVolume(volume);
        this.tankCapacity = this.getVolume() * 64000;
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }
}

