/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.matrix;

import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.matrix.MatrixCache;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class MatrixUpdateProtocol
extends UpdateProtocol<SynchronizedMatrixData> {
    public MatrixUpdateProtocol(TileEntityInductionCasing tile) {
        super(tile);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        return BlockTypeTile.is(this.pointer.func_145831_w().func_180495_p(new BlockPos(x, y, z)).func_177230_c(), MekanismBlockTypes.INDUCTION_CASING);
    }

    @Override
    public boolean isValidInnerNode(int x, int y, int z) {
        if (super.isValidInnerNode(x, y, z)) {
            return true;
        }
        TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.pointer.func_145831_w(), new BlockPos(x, y, z));
        return tile instanceof TileEntityInductionCell || tile instanceof TileEntityInductionProvider;
    }

    protected MatrixCache getNewCache() {
        return new MatrixCache();
    }

    @Override
    protected SynchronizedMatrixData getNewStructure() {
        return new SynchronizedMatrixData((TileEntityInductionCasing)this.pointer);
    }

    @Override
    protected MultiblockManager<SynchronizedMatrixData> getManager() {
        return Mekanism.matrixManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedMatrixData> cache, MultiblockCache<SynchronizedMatrixData> merge) {
        MatrixCache matrixCache = (MatrixCache)cache;
        MatrixCache mergeCache = (MatrixCache)merge;
        List<ItemStack> rejects = StackUtils.getMergeRejects(matrixCache.getInventorySlots(null), mergeCache.getInventorySlots(null));
        if (!rejects.isEmpty()) {
            rejectedItems.addAll(rejects);
        }
        StackUtils.merge(matrixCache.getInventorySlots(null), mergeCache.getInventorySlots(null));
    }

    @Override
    protected void onStructureDestroyed(SynchronizedMatrixData structure) {
        structure.invalidate();
        super.onStructureDestroyed(structure);
    }

    @Override
    protected boolean canForm(SynchronizedMatrixData structure) {
        for (Coord4D coord : this.innerNodes) {
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.pointer.func_145831_w(), coord.getPos());
            if (tile instanceof TileEntityInductionCell) {
                structure.addCell(coord, (TileEntityInductionCell)tile);
                continue;
            }
            if (!(tile instanceof TileEntityInductionProvider)) continue;
            structure.addProvider(coord, (TileEntityInductionProvider)tile);
        }
        return true;
    }
}

