/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.chemical.MultiblockGasTank;
import mekanism.common.capabilities.fluid.MultiblockFluidTank;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.capabilities.heat.MultiblockHeatCapacitor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.multiblock.IValveHandler;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;

public class SynchronizedBoilerData
extends SynchronizedData<SynchronizedBoilerData>
implements IMekanismFluidHandler,
IMekanismGasHandler,
ITileHeatHandler {
    public static Object2BooleanMap<UUID> hotMap = new Object2BooleanOpenHashMap();
    public static final double CASING_HEAT_CAPACITY = 5.0;
    public static final double CASING_INVERSE_INSULATION_COEFFICIENT = 10.0;
    public static final double CASING_INVERSE_CONDUCTION_COEFFICIENT = 1.0;
    public static final double BASE_BOIL_TEMP = UnitDisplayUtils.TemperatureUnit.CELSIUS.zeroOffset + 100.0;
    public MultiblockFluidTank<TileEntityBoilerCasing> waterTank;
    public MultiblockGasTank<TileEntityBoilerCasing> steamTank;
    public MultiblockHeatCapacitor<TileEntityBoilerCasing> heatCapacitor;
    public double lastEnvironmentLoss;
    public int lastBoilRate;
    public int lastMaxBoil;
    public boolean clientHot;
    public int superheatingElements;
    private int waterVolume;
    private long steamVolume;
    private int waterTankCapacity;
    private long steamTankCapacity;
    public Coord4D upperRenderLocation;
    public Set<IValveHandler.ValveData> valves = new ObjectOpenHashSet();
    private final List<IExtendedFluidTank> fluidTanks;
    private final List<IGasTank> gasTanks;
    private final List<IHeatCapacitor> heatCapacitors;

    public SynchronizedBoilerData(TileEntityBoilerCasing tile) {
        this.waterTank = MultiblockFluidTank.create(tile, () -> tile.structure == null ? 0 : ((SynchronizedBoilerData)tile.structure).getWaterTankCapacity(), fluid -> fluid.getFluid().func_207185_a(FluidTags.field_206959_a));
        this.fluidTanks = Collections.singletonList(this.waterTank);
        this.steamTank = MultiblockGasTank.create(tile, () -> tile.structure == null ? 0L : ((SynchronizedBoilerData)tile.structure).getSteamTankCapacity(), (stack, automationType) -> automationType != AutomationType.EXTERNAL || tile.structure != null, (stack, automationType) -> automationType != AutomationType.EXTERNAL, gas -> gas == MekanismGases.STEAM.getGas());
        this.gasTanks = Collections.singletonList(this.steamTank);
        this.heatCapacitor = MultiblockHeatCapacitor.create(tile, 5.0, () -> 10.0 * (double)this.locations.size(), () -> 10.0 * (double)this.locations.size());
        this.heatCapacitors = Collections.singletonList(this.heatCapacitor);
    }

    @Override
    public void onCreated() {
        this.heatCapacitor.setHeatCapacity(5.0 * (double)this.locations.size(), true);
    }

    public void setFluidTankData(@Nonnull List<IExtendedFluidTank> toCopy) {
        for (int i = 0; i < toCopy.size(); ++i) {
            if (i >= this.fluidTanks.size()) continue;
            this.fluidTanks.get(i).deserializeNBT((INBT)toCopy.get(i).serializeNBT());
        }
    }

    public void setGasTankData(@Nonnull List<IGasTank> toCopy) {
        for (int i = 0; i < toCopy.size(); ++i) {
            if (i >= this.gasTanks.size()) continue;
            this.gasTanks.get(i).deserializeNBT((INBT)toCopy.get(i).serializeNBT());
        }
    }

    public void setHeatCapacitorData(@Nonnull List<IHeatCapacitor> toCopy) {
        for (int i = 0; i < toCopy.size(); ++i) {
            if (i >= this.heatCapacitors.size()) continue;
            this.heatCapacitors.get(i).deserializeNBT((INBT)toCopy.get(i).serializeNBT());
        }
    }

    public double getHeatAvailable() {
        double heatAvailable = (this.heatCapacitor.getTemperature() - BASE_BOIL_TEMP) * (this.heatCapacitor.getHeatCapacity() * MekanismConfig.general.boilerWaterConductivity.get());
        return Math.min(heatAvailable, MekanismConfig.general.superheatingHeatTransfer.get() * (double)this.superheatingElements);
    }

    @Override
    public HeatAPI.HeatTransfer simulate() {
        double invConduction = 10000.0 + 11.0 * (double)this.locations.size();
        double heatToTransfer = (this.heatCapacitor.getTemperature() - 300.0) / invConduction;
        this.heatCapacitor.handleHeat(-heatToTransfer * this.heatCapacitor.getHeatCapacity());
        return new HeatAPI.HeatTransfer(0.0, heatToTransfer);
    }

    public int getWaterTankCapacity() {
        return this.waterTankCapacity;
    }

    public long getSteamTankCapacity() {
        return this.steamTankCapacity;
    }

    public int getWaterVolume() {
        return this.waterVolume;
    }

    public void setWaterVolume(int volume) {
        this.waterVolume = volume;
        this.waterTankCapacity = this.getWaterVolume() * 16000;
    }

    public long getSteamVolume() {
        return this.steamVolume;
    }

    public void setSteamVolume(long volume) {
        this.steamVolume = volume;
        this.steamTankCapacity = this.getSteamVolume() * 160000L;
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.heatCapacitors;
    }
}

