/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ClientConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedBooleanValue enablePlayerSounds;
    public final CachedBooleanValue enableMachineSounds;
    public final CachedBooleanValue dynamicTankEasterEgg;
    public final CachedBooleanValue holidays;
    public final CachedFloatValue baseSoundVolume;
    public final CachedBooleanValue machineEffects;
    public final CachedBooleanValue enableAmbientLighting;
    public final CachedIntValue ambientLightingLevel;
    public final CachedBooleanValue opaqueTransmitters;
    public final CachedBooleanValue allowModeScroll;
    public final CachedBooleanValue enableMultiblockFormationParticles;
    public final CachedBooleanValue alignHUDLeft;
    public final CachedBooleanValue enableHUD;

    ClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Client Config. This config only exists on the client").push("client");
        this.enablePlayerSounds = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Play sounds for Jetpack/Gas Mask/Flamethrower (all players).").define("enablePlayerSounds", true));
        this.enableMachineSounds = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("If enabled machines play their sounds while running.").define("enableMachineSounds", true));
        this.dynamicTankEasterEgg = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Audible sparkles.").define("dynamicTankEasterEgg", false));
        this.holidays = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Christmas/New Years greetings in chat.").define("holidays", true));
        this.baseSoundVolume = CachedFloatValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Adjust Mekanism sounds' base volume. < 1 is softer, higher is louder.").defineInRange("baseSoundVolume", 1.0, 0.0, 3.4028234663852886E38));
        this.machineEffects = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Show particles when machines active.").define("machineEffects", true));
        this.enableAmbientLighting = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Should active machines produce block light.").define("enableAmbientLighting", true));
        this.ambientLightingLevel = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("How much light to produce if ambient lighting is enabled.").defineInRange("ambientLightingLevel", 15, 1, 15));
        this.opaqueTransmitters = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("If true, don't render Cables/Pipes/Tubes as transparent and don't render their contents.").define("opaqueTransmitters", false));
        this.allowModeScroll = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Allow sneak + scroll to change item modes.").define("allowModeScroll", true));
        this.enableMultiblockFormationParticles = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Set to false to prevent particle spam when loading multiblocks (notification message will display instead).").define("enableMultiblockFormationParticles", true));
        this.alignHUDLeft = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Align HUD with left (if true) or right (if false)").define("alignHUDLeft", true));
        this.enableHUD = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enable item information HUD during gameplay").define("enableHUD", true));
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "client";
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }
}

