/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.chunkloading;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Upgrade;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.chunkloading.ChunkMultimap;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChunkManager
extends WorldSavedData {
    private static final String CHUNK_LIST_KEY = "chunks";
    private static final Logger LOGGER = LogManager.getLogger((String)"Mekanism ChunkManager");
    private static final String SAVEDATA_KEY = "mekanism_force_chunks";
    private static final TicketType<ChunkPos> INITIAL_LOAD_TICKET_TYPE = TicketType.func_223183_a((String)"mekanism:initial_chunkload", Comparator.comparingLong(ChunkPos::func_201841_a), (int)10);
    private ChunkMultimap chunks = new ChunkMultimap();

    public ChunkManager() {
        super(SAVEDATA_KEY);
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.chunks = new ChunkMultimap();
        this.chunks.deserializeNBT(nbt.func_150295_c(CHUNK_LIST_KEY, 10));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_218657_a(CHUNK_LIST_KEY, (INBT)this.chunks.serializeNBT());
        return compound;
    }

    public void registerChunk(ChunkPos chunk, BlockPos chunkLoaderPos) {
        this.chunks.add(chunk, chunkLoaderPos);
        this.func_76185_a();
    }

    public void deregisterChunk(ChunkPos chunk, BlockPos chunkLoaderPos) {
        this.chunks.remove(chunk, chunkLoaderPos);
        this.func_76185_a();
    }

    public static void worldLoad(ServerWorld world) {
        ChunkManager savedData = ChunkManager.getInstance(world);
        LOGGER.info("Loading {} chunks for dimension {}", (Object)savedData.chunks.size(), (Object)world.field_73011_w.func_186058_p().getRegistryName());
        savedData.chunks.long2ObjectEntrySet().fastForEach(entry -> {
            boolean shouldLoad = false;
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                BlockPos blockPos = (BlockPos)iterator.next();
                Block block = world.func_180495_p(blockPos).func_177230_c();
                if (Attribute.has(block, AttributeUpgradeSupport.class) && Attribute.get(block, AttributeUpgradeSupport.class).getSupportedUpgrades().contains(Upgrade.ANCHOR)) {
                    shouldLoad = true;
                    continue;
                }
                LOGGER.warn("Block at {} was does not support Anchor Upgrades?! Block: {}", (Object)blockPos, (Object)block.getRegistryName());
                iterator.remove();
                savedData.func_76185_a();
            }
            if (shouldLoad) {
                ChunkPos pos = new ChunkPos(entry.getLongKey());
                world.func_72863_F().func_217228_a(INITIAL_LOAD_TICKET_TYPE, pos, 2, (Object)pos);
            }
        });
    }

    public static void tick(ServerWorld world) {
        ChunkManager instance = ChunkManager.getInstance(world);
        if (!instance.chunks.isEmpty()) {
            world.func_82742_i();
        }
    }

    public static ChunkManager getInstance(ServerWorld world) {
        return (ChunkManager)world.func_217481_x().func_215752_a(ChunkManager::new, SAVEDATA_KEY);
    }
}

