/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical.item;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.chemical.VariableCapacityGasTank;
import mekanism.common.capabilities.chemical.item.ItemStackMekanismGasHandler;
import mekanism.common.tier.GasTankTier;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RateLimitGasHandler
extends ItemStackMekanismGasHandler {
    private final IGasTank tank;

    public static RateLimitGasHandler create(LongSupplier rate, LongSupplier capacity) {
        return RateLimitGasHandler.create(rate, capacity, BasicGasTank.alwaysTrueBi, BasicGasTank.alwaysTrueBi, BasicGasTank.alwaysTrue, null);
    }

    public static RateLimitGasHandler create(GasTankTier tier) {
        Objects.requireNonNull(tier, "Gas tank tier cannot be null");
        return new RateLimitGasHandler(handler -> new GasTankRateLimitGasTank(tier, (IMekanismGasHandler)handler));
    }

    public static RateLimitGasHandler create(LongSupplier rate, LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> isValid) {
        return RateLimitGasHandler.create(rate, capacity, canExtract, canInsert, isValid, null);
    }

    public static RateLimitGasHandler create(LongSupplier rate, LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> isValid, @Nullable ChemicalAttributeValidator attributeValidator) {
        Objects.requireNonNull(rate, "Rate supplier cannot be null");
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(isValid, "Gas validity check cannot be null");
        return new RateLimitGasHandler(handler -> new RateLimitGasTank(rate, capacity, canExtract, canInsert, isValid, attributeValidator, (IMekanismGasHandler)handler));
    }

    private RateLimitGasHandler(Function<IMekanismGasHandler, IGasTank> tankProvider) {
        this.tank = tankProvider.apply(this);
    }

    @Override
    protected List<IGasTank> getInitialTanks() {
        return Collections.singletonList(this.tank);
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class GasTankRateLimitGasTank
    extends RateLimitGasTank {
        private final boolean isCreative;

        private GasTankRateLimitGasTank(GasTankTier tier, IMekanismGasHandler gasHandler) {
            super(tier::getOutput, tier::getStorage, BasicGasTank.alwaysTrueBi, BasicGasTank.alwaysTrueBi, BasicGasTank.alwaysTrue, null, gasHandler);
            this.isCreative = tier == GasTankTier.CREATIVE;
        }

        @Override
        public GasStack insert(GasStack stack, Action action, AutomationType automationType) {
            return super.insert(stack, action.combine(!this.isCreative), automationType);
        }

        @Override
        public GasStack extract(long amount, Action action, AutomationType automationType) {
            return (GasStack)super.extract(amount, action.combine(!this.isCreative), automationType);
        }

        @Override
        public long setStackSize(long amount, Action action) {
            return super.setStackSize(amount, action.combine(!this.isCreative));
        }
    }

    public static class RateLimitGasTank
    extends VariableCapacityGasTank {
        private final LongSupplier rate;

        public RateLimitGasTank(LongSupplier rate, LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> isValid, @Nullable ChemicalAttributeValidator attributeValidator, IMekanismGasHandler gasHandler) {
            super(capacity, canExtract, canInsert, isValid, attributeValidator, gasHandler);
            this.rate = rate;
        }

        @Override
        protected long getRate(@Nullable AutomationType automationType) {
            return automationType == null || automationType == AutomationType.MANUAL ? super.getRate(automationType) : this.rate.getAsLong();
        }
    }
}

