/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockCardboardBox;
import mekanism.common.network.PacketClearRecipeCache;
import mekanism.common.network.PacketMekanismTags;
import mekanism.common.network.PacketPlayerData;
import mekanism.common.network.PacketSecurityUpdate;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonPlayerTracker {
    private static final ITextComponent ALPHA_WARNING;
    public static boolean monitoringCardboardBox;

    public CommonPlayerTracker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            Mekanism.packetHandler.sendTo(new PacketSecurityUpdate(), (ServerPlayerEntity)event.getPlayer());
            Mekanism.packetHandler.sendTo(new PacketMekanismTags(Mekanism.instance.getTagManager()), (ServerPlayerEntity)event.getPlayer());
            Mekanism.packetHandler.sendTo(new PacketClearRecipeCache(), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Mekanism.playerState.clearPlayer(event.getPlayer().func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        Mekanism.playerState.clearPlayer(event.getPlayer().func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof PlayerEntity && event.getPlayer() instanceof ServerPlayerEntity) {
            Mekanism.packetHandler.sendTo(new PacketPlayerData(event.getTarget().func_110124_au()), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void rightClickEvent(PlayerInteractEvent.RightClickBlock blockEvent) {
        if (blockEvent.getPlayer().func_225608_bj_() && blockEvent.getWorld().func_180495_p(blockEvent.getPos()).func_177230_c() instanceof BlockCardboardBox) {
            blockEvent.setUseBlock(Event.Result.ALLOW);
            blockEvent.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ItemEntity && monitoringCardboardBox) {
            event.setCanceled(true);
        }
    }

    static {
        TranslationTextComponent hereComponent = MekanismLang.ALPHA_WARNING_HERE.translate(new Object[0]);
        hereComponent.func_150256_b().func_150228_d(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLUE).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/mekanism/Mekanism#alpha-status"));
        ALPHA_WARNING = MekanismLang.LOG_FORMAT.translateColored(EnumColor.RED, new Object[]{MekanismLang.MEKANISM, EnumColor.GRAY, MekanismLang.ALPHA_WARNING.translate(hereComponent)});
    }
}

