/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.KeySync;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.entity.EntityFlame;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.item.gear.ItemGasMask;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemScubaTank;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonPlayerTickHandler {
    public static boolean isOnGround(PlayerEntity player) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)player.func_226277_ct_());
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(player.func_226278_cu_() - 0.01)), z = MathHelper.func_76128_c((double)player.func_226281_cx_()));
        BlockState s = player.field_70170_p.func_180495_p(pos);
        VoxelShape shape = s.func_196954_c((IBlockReader)player.field_70170_p, pos);
        if (shape.func_197766_b()) {
            return false;
        }
        AxisAlignedBB playerBox = player.func_174813_aQ();
        return !s.isAir((IBlockReader)player.field_70170_p, pos) && playerBox.func_72317_d(0.0, -0.01, 0.0).func_72326_a(shape.func_197752_a().func_186670_a(pos));
    }

    public static boolean isGasMaskOn(PlayerEntity player) {
        ItemStack tank = player.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack mask = player.func_184582_a(EquipmentSlotType.HEAD);
        return !tank.func_190926_b() && !mask.func_190926_b() && tank.func_77973_b() instanceof ItemScubaTank && mask.func_77973_b() instanceof ItemGasMask && GasUtils.hasGas(tank) && ((ItemScubaTank)tank.func_77973_b()).getFlowing(tank);
    }

    public static boolean isFlamethrowerOn(PlayerEntity player) {
        if (Mekanism.playerState.isFlamethrowerOn(player)) {
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            return !currentItem.func_190926_b() && currentItem.func_77973_b() instanceof ItemFlamethrower;
        }
        return false;
    }

    public static boolean isFreeRunnerOn(PlayerEntity player) {
        ItemStack stack = player.func_184582_a(EquipmentSlotType.FEET);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFreeRunners) {
            return ((ItemFreeRunners)stack.func_77973_b()).getMode(stack) == ItemFreeRunners.FreeRunnerMode.NORMAL && !player.func_225608_bj_();
        }
        return false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            this.tickEnd(event.player);
        }
    }

    public void tickEnd(PlayerEntity player) {
        ItemStack stack;
        if (CommonPlayerTickHandler.isFreeRunnerOn(player)) {
            player.field_70138_W = 1.002f;
        } else if (player.field_70138_W == 1.002f) {
            player.field_70138_W = 0.6f;
        }
        if (CommonPlayerTickHandler.isFlamethrowerOn(player)) {
            player.field_70170_p.func_217376_c((Entity)new EntityFlame(player));
            if (!player.func_184812_l_() && !player.func_175149_v()) {
                ItemStack currentItem = player.field_71071_by.func_70448_g();
                ((ItemFlamethrower)currentItem.func_77973_b()).useGas(currentItem, 1L);
            }
        }
        if (CommonPlayerTickHandler.isJetpackOn(player)) {
            stack = player.func_184582_a(EquipmentSlotType.CHEST);
            ItemJetpack jetpack = (ItemJetpack)stack.func_77973_b();
            ItemJetpack.JetpackMode mode = jetpack.getMode(stack);
            Vec3d motion = player.func_213322_ci();
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                player.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.5), motion.func_82616_c());
            } else if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = Mekanism.keyMap.has(player, KeySync.ASCEND);
                boolean descending = Mekanism.keyMap.has(player, KeySync.DESCEND);
                if (!ascending && !descending || ascending && descending) {
                    if (motion.func_82617_b() > 0.0) {
                        player.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, 0.0), motion.func_82616_c());
                    } else if (motion.func_82617_b() < 0.0 && !CommonPlayerTickHandler.isOnGround(player)) {
                        player.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.0), motion.func_82616_c());
                    }
                } else if (ascending) {
                    player.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.2), motion.func_82616_c());
                } else if (!CommonPlayerTickHandler.isOnGround(player)) {
                    player.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, -0.2), motion.func_82616_c());
                }
            }
            player.field_70143_R = 0.0f;
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.field_147365_f = 0;
            }
            jetpack.useGas(stack, 1L);
        }
        if (CommonPlayerTickHandler.isGasMaskOn(player)) {
            stack = player.func_184582_a(EquipmentSlotType.CHEST);
            ItemScubaTank tank = (ItemScubaTank)stack.func_77973_b();
            int max = 300;
            tank.useGas(stack, 1L);
            GasStack received = tank.useGas(stack, 300 - player.func_70086_ai());
            if (!received.isEmpty()) {
                player.func_70050_g(player.func_70086_ai() + (int)received.getAmount());
            }
            if (player.func_70086_ai() == 300) {
                for (EffectInstance effect : player.func_70651_bq()) {
                    for (int i = 0; i < 9; ++i) {
                        effect.func_76455_a((LivingEntity)player, () -> MekanismUtils.onChangedPotionEffect((LivingEntity)player, effect, true));
                    }
                }
            }
        }
    }

    public static boolean isJetpackOn(PlayerEntity player) {
        ItemStack chest;
        if (!player.func_184812_l_() && !player.func_175149_v() && !(chest = player.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b() && chest.func_77973_b() instanceof ItemJetpack && GasUtils.hasGas(chest)) {
            ItemJetpack.JetpackMode mode = ((ItemJetpack)chest.func_77973_b()).getMode(chest);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                return Mekanism.keyMap.has(player, KeySync.ASCEND);
            }
            if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = Mekanism.keyMap.has(player, KeySync.ASCEND);
                boolean descending = Mekanism.keyMap.has(player, KeySync.DESCEND);
                if (!ascending || descending) {
                    return !CommonPlayerTickHandler.isOnGround(player);
                }
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        FloatingLong energyRequirement;
        FloatingLong simulatedExtract;
        IEnergyContainer energyContainer;
        ItemStack chestStack;
        ItemStack headStack;
        LivingEntity base = event.getEntityLiving();
        if (event.getSource() == DamageSource.field_76376_m && !(headStack = base.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b() && headStack.func_77973_b() instanceof ItemGasMask && !(chestStack = base.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b() && chestStack.func_77973_b() instanceof ItemScubaTank && ((ItemScubaTank)chestStack.func_77973_b()).getFlowing(chestStack) && GasUtils.hasGas(chestStack)) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() == DamageSource.field_76379_h && (energyContainer = this.getFreeRunnerEnergyContainer(base)) != null && (simulatedExtract = energyContainer.extract(energyRequirement = ((FloatingLong)MekanismConfig.gear.freeRunnerFallEnergyCost.get()).multiply(event.getAmount()), Action.SIMULATE, AutomationType.MANUAL)).equals(energyRequirement)) {
            energyContainer.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        FloatingLong energyRequirement;
        FloatingLong extracted;
        IEnergyContainer energyContainer;
        if (event.getSource() == DamageSource.field_76379_h && (energyContainer = this.getFreeRunnerEnergyContainer(event.getEntityLiving())) != null && !(extracted = energyContainer.extract(energyRequirement = ((FloatingLong)MekanismConfig.gear.freeRunnerFallEnergyCost.get()).multiply(event.getAmount()), Action.EXECUTE, AutomationType.MANUAL)).isZero()) {
            FloatingLong remainder = energyRequirement.subtract(extracted);
            if (remainder.isZero()) {
                event.setCanceled(true);
            } else {
                float newDamage = remainder.divide((FloatingLong)MekanismConfig.gear.freeRunnerFallEnergyCost.get()).floatValue();
                if (newDamage == 0.0f) {
                    event.setCanceled(true);
                } else {
                    event.setAmount(newDamage);
                }
            }
        }
    }

    @Nullable
    private IEnergyContainer getFreeRunnerEnergyContainer(LivingEntity base) {
        ItemFreeRunners boots;
        ItemStack feetStack = base.func_184582_a(EquipmentSlotType.FEET);
        if (!feetStack.func_190926_b() && feetStack.func_77973_b() instanceof ItemFreeRunners && (boots = (ItemFreeRunners)feetStack.func_77973_b()).getMode(feetStack) == ItemFreeRunners.FreeRunnerMode.NORMAL) {
            return StorageUtils.getEnergyContainer(feetStack, 0);
        }
        return null;
    }
}

