/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackGasToGasRecipe;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;

public class ItemStackGasToGasRecipeCategory
extends BaseRecipeCategory<ItemStackGasToGasRecipe> {
    public ItemStackGasToGasRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, 3, 3, 170, 79);
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 5, 4));
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 133, 13));
        this.guiElements.add(new GuiSlot(SlotType.POWER, this, 154, 4).with(SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(SlotType.INPUT, this, 25, 35));
        this.guiElements.add(new GuiSlot(SlotType.EXTRA, this, 154, 24).with(SlotOverlay.PLUS));
        this.guiElements.add(new GuiSlot(SlotType.EXTRA, this, 5, 64).with(SlotOverlay.MINUS));
        this.guiElements.add(new GuiProgress(() -> (double)this.timer.getValue() / 20.0, ProgressType.LARGE_RIGHT, this, 79, 38));
    }

    public Class<? extends ItemStackGasToGasRecipe> getRecipeClass() {
        return ItemStackGasToGasRecipe.class;
    }

    public void setIngredients(ItemStackGasToGasRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemInput().getRepresentations()));
        List<@NonNull TYPE> gasInputs = recipe.getGasInput().getRepresentations();
        int scale = 100;
        List scaledGases = gasInputs.stream().map(gas -> new GasStack((GasStack)gas, (long)scale)).collect(Collectors.toList());
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(scaledGases));
        ingredients.setOutput(MekanismJEI.TYPE_GAS, (Object)recipe.getOutputDefinition());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ItemStackGasToGasRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 25 - this.xOffset, 35 - this.yOffset);
        itemStacks.set(0, recipe.getItemInput().getRepresentations());
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        List<@NonNull TYPE> gasInputs = recipe.getGasInput().getRepresentations();
        int scale = 100;
        List<GasStack> scaledGases = gasInputs.stream().map(gas -> new GasStack((GasStack)gas, (long)scale)).collect(Collectors.toList());
        this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 0, true, 6 - this.xOffset, 5 - this.yOffset, 16, 58, scaledGases, true);
        this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 1, false, 134 - this.xOffset, 14 - this.yOffset, 16, 58, Collections.singletonList(recipe.getOutputDefinition()), true);
    }
}

