/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.filter.GuiItemStackFilter;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.inventory.container.tile.filter.LSItemStackFilterContainer;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public class GuiTItemStackFilter
extends GuiItemStackFilter<TItemStackFilter, TileEntityLogisticalSorter, LSItemStackFilterContainer> {
    private TextFieldWidget minField;
    private TextFieldWidget maxField;

    public GuiTItemStackFilter(LSItemStackFilterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.origFilter = container.getOrigFilter();
        this.filter = container.getFilter();
        this.isNew = container.isNew();
    }

    @Override
    protected void addButtons() {
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 18).setRenderHover(true));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 43));
        this.saveButton = new TranslationButton(this, this.getGuiLeft() + 47, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_SAVE, () -> {
            if (!(((TItemStackFilter)this.filter).getItemStack().func_190926_b() || this.minField.func_146179_b().isEmpty() || this.maxField.func_146179_b().isEmpty())) {
                int min = Integer.parseInt(this.minField.func_146179_b());
                int max = Integer.parseInt(this.maxField.func_146179_b());
                if (max >= min && max <= 64) {
                    ((TItemStackFilter)this.filter).min = Integer.parseInt(this.minField.func_146179_b());
                    ((TItemStackFilter)this.filter).max = Integer.parseInt(this.maxField.func_146179_b());
                    if (this.isNew) {
                        Mekanism.packetHandler.sendToServer(new PacketNewFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), this.filter));
                    } else {
                        Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), false, this.origFilter, this.filter));
                    }
                    this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
                } else if (min > max) {
                    this.status = MekanismLang.ITEM_FILTER_MAX_LESS_THAN_MIN.translateColored(EnumColor.DARK_RED, new Object[0]);
                    this.ticker = 20;
                } else {
                    this.status = MekanismLang.ITEM_FILTER_OVER_SIZED.translateColored(EnumColor.DARK_RED, new Object[0]);
                    this.ticker = 20;
                }
            } else if (((TItemStackFilter)this.filter).getItemStack().func_190926_b()) {
                this.status = MekanismLang.ITEM_FILTER_NO_ITEM.translateColored(EnumColor.DARK_RED, new Object[0]);
                this.ticker = 20;
            } else if (this.minField.func_146179_b().isEmpty() || this.maxField.func_146179_b().isEmpty()) {
                this.status = MekanismLang.ITEM_FILTER_SIZE_MISSING.translateColored(EnumColor.DARK_RED, new Object[0]);
                this.ticker = 20;
            }
        });
        this.addButton(this.saveButton);
        this.deleteButton = new TranslationButton(this, this.getGuiLeft() + 109, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_DELETE, () -> {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), true, this.origFilter, null));
            this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
        });
        this.addButton(this.deleteButton);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 5, this.getGuiTop() + 5, 11, 14, this.getButtonLocation("back"), () -> this.sendPacketToServer(this.isNew ? PacketGuiButtonPress.ClickedTileButton.LS_SELECT_FILTER_TYPE : PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 11, this.getGuiTop() + 62, 10, this.getButtonLocation("default"), () -> {
            ((TItemStackFilter)this.filter).allowDefault = !((TItemStackFilter)this.filter).allowDefault;
        }, this.getOnHover(MekanismLang.FILTER_ALLOW_DEFAULT)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 11, this.getGuiTop() + 72, 10, this.getButtonLocation("fuzzy"), () -> {
            ((TItemStackFilter)this.filter).fuzzyMode = !((TItemStackFilter)this.filter).fuzzyMode;
        }, this.getOnHover(MekanismLang.FUZZY_MODE)));
        this.addButton(new ColorButton((IGuiWrapper)this, this.getGuiLeft() + 12, this.getGuiTop() + 44, 16, 16, () -> ((TItemStackFilter)this.filter).color, () -> {
            ((TItemStackFilter)this.filter).color = GuiTItemStackFilter.hasShiftDown() ? null : TransporterUtils.increment(((TItemStackFilter)this.filter).color);
        }, () -> {
            ((TItemStackFilter)this.filter).color = TransporterUtils.decrement(((TItemStackFilter)this.filter).color);
        }));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 128, this.getGuiTop() + 44, 11, 14, this.getButtonLocation("silk_touch"), () -> {
            ((TItemStackFilter)this.filter).sizeMode = !((TItemStackFilter)this.filter).sizeMode;
        }, (onHover, xAxis, yAxis) -> {
            if (((TileEntityLogisticalSorter)this.tile).singleItem && ((TItemStackFilter)this.filter).sizeMode) {
                this.displayTooltip((ITextComponent)MekanismLang.SIZE_MODE_CONFLICT.translate(new Object[0]), xAxis, yAxis);
            } else {
                this.displayTooltip((ITextComponent)MekanismLang.SIZE_MODE.translate(new Object[0]), xAxis, yAxis);
            }
        }));
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 33, 18, 93, 43));
        this.minField = new TextFieldWidget(this.font, this.getGuiLeft() + 149, this.getGuiTop() + 19, 20, 11, "");
        this.addButton((Widget)this.minField);
        this.minField.func_146203_f(2);
        this.minField.func_146180_a("" + ((TItemStackFilter)this.filter).min);
        this.maxField = new TextFieldWidget(this.font, this.getGuiLeft() + 149, this.getGuiTop() + 31, 20, 11, "");
        this.addButton((Widget)this.maxField);
        this.maxField.func_146203_f(2);
        this.maxField.func_146180_a("" + ((TItemStackFilter)this.filter).max);
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String min = this.minField.func_146179_b();
        String max = this.maxField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.minField.func_146180_a(min);
        this.maxField.func_146180_a(max);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        TextFieldWidget focusedField = this.getFocusedField();
        if (focusedField != null) {
            if (keyCode == 256) {
                focusedField.func_146195_b(false);
                return true;
            }
            return focusedField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        TextFieldWidget focusedField = this.getFocusedField();
        if (focusedField != null) {
            if (Character.isDigit(c)) {
                return focusedField.charTyped(c, keyCode);
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    @Nullable
    private TextFieldWidget getFocusedField() {
        if (this.minField.func_212955_f()) {
            return this.minField;
        }
        if (this.maxField.func_212955_f()) {
            return this.maxField;
        }
        return null;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        this.drawString((ITextComponent)MekanismLang.MIN.translate(""), 128, 20, 0x404040);
        this.drawString((ITextComponent)MekanismLang.MAX.translate(""), 128, 32, 0x404040);
        if (((TileEntityLogisticalSorter)this.tile).singleItem && ((TItemStackFilter)this.filter).sizeMode) {
            this.drawString(MekanismLang.ITEM_FILTER_SIZE_MODE.translateColored(EnumColor.RED, BooleanStateDisplay.OnOff.of(((TItemStackFilter)this.filter).sizeMode)), 141, 46, 0x404040);
        } else {
            this.drawString(BooleanStateDisplay.OnOff.of(((TItemStackFilter)this.filter).sizeMode).getTextComponent(), 141, 46, 0x404040);
        }
        this.drawString(BooleanStateDisplay.OnOff.of(((TItemStackFilter)this.filter).fuzzyMode).getTextComponent(), 24, 74, 0x404040);
        this.drawTransporterForegroundLayer(((TItemStackFilter)this.filter).getItemStack());
        if (!((TItemStackFilter)this.filter).getItemStack().func_190926_b()) {
            this.renderScaledText(((TItemStackFilter)this.filter).getItemStack().func_200301_q(), 35, 41, 52480, 89);
        }
    }

    @Override
    protected void drawTransporterForegroundLayer(@Nonnull ItemStack stack) {
        this.drawString(BooleanStateDisplay.OnOff.of(((TItemStackFilter)this.filter).allowDefault).getTextComponent(), 24, 64, 0x404040);
        this.renderItem(stack, 12, 19);
    }

    @Override
    public void tick() {
        super.tick();
        this.minField.func_146178_a();
        this.maxField.func_146178_a();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (button == 0 && this.overTypeInput(mouseX - (double)this.getGuiLeft(), mouseY - (double)this.getGuiTop())) {
            ItemStack stack = this.minecraft.field_71439_g.field_71071_by.func_70445_o();
            if (!stack.func_190926_b() && !GuiTItemStackFilter.hasShiftDown()) {
                ((TItemStackFilter)this.filter).setItemStack(stack.func_77946_l());
                ((TItemStackFilter)this.filter).getItemStack().func_190920_e(1);
            } else if (stack.func_190926_b() && GuiTItemStackFilter.hasShiftDown()) {
                ((TItemStackFilter)this.filter).setItemStack(ItemStack.field_190927_a);
            }
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
        return true;
    }
}

