/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GuiUtils {
    public static void renderExtendedTexture(ResourceLocation resource, int sideWidth, int sideHeight, int left, int top, int width, int height) {
        int textureWidth = 2 * sideWidth + 1;
        int textureHeight = 2 * sideHeight + 1;
        int centerWidth = width - 2 * sideWidth;
        int centerHeight = height - 2 * sideHeight;
        int leftEdgeEnd = left + sideHeight;
        int rightEdgeStart = leftEdgeEnd + centerWidth;
        int topEdgeEnd = top + sideWidth;
        int bottomEdgeStart = topEdgeEnd + centerHeight;
        MekanismRenderer.bindTexture(resource);
        AbstractGui.blit((int)left, (int)top, (float)0.0f, (float)0.0f, (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerHeight > 0) {
            AbstractGui.blit((int)left, (int)topEdgeEnd, (int)sideWidth, (int)centerHeight, (float)0.0f, (float)sideHeight, (int)sideWidth, (int)1, (int)textureWidth, (int)textureHeight);
        }
        AbstractGui.blit((int)left, (int)bottomEdgeStart, (float)0.0f, (float)(sideHeight + 1), (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerWidth > 0) {
            AbstractGui.blit((int)leftEdgeEnd, (int)top, (int)centerWidth, (int)sideHeight, (float)sideWidth, (float)0.0f, (int)1, (int)sideHeight, (int)textureWidth, (int)textureHeight);
            if (centerHeight > 0) {
                AbstractGui.blit((int)leftEdgeEnd, (int)topEdgeEnd, (int)centerWidth, (int)centerHeight, (float)sideWidth, (float)sideHeight, (int)1, (int)1, (int)textureWidth, (int)textureHeight);
            }
            AbstractGui.blit((int)leftEdgeEnd, (int)bottomEdgeStart, (int)centerWidth, (int)sideHeight, (float)sideWidth, (float)(sideHeight + 1), (int)1, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        }
        AbstractGui.blit((int)rightEdgeStart, (int)top, (float)(sideWidth + 1), (float)0.0f, (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerHeight > 0) {
            AbstractGui.blit((int)rightEdgeStart, (int)topEdgeEnd, (int)sideWidth, (int)centerHeight, (float)(sideWidth + 1), (float)sideHeight, (int)sideWidth, (int)1, (int)textureWidth, (int)textureHeight);
        }
        AbstractGui.blit((int)rightEdgeStart, (int)bottomEdgeStart, (float)(sideWidth + 1), (float)(sideHeight + 1), (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
    }

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        MekanismRenderer.bindTexture(AtlasTexture.field_110575_b);
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uMaxLocal = uMax - uDif * (float)maskRight / (float)textureWidth;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vMaxLocal = vMax - vDif * (float)maskTop / (float)textureHeight;
                vertexBuffer.func_225582_a_((double)x, (double)(y + textureHeight), (double)zLevel).func_225583_a_(uMin, vMaxLocal).func_181675_d();
                vertexBuffer.func_225582_a_((double)shiftedX, (double)(y + textureHeight), (double)zLevel).func_225583_a_(uMaxLocal, vMaxLocal).func_181675_d();
                vertexBuffer.func_225582_a_((double)shiftedX, (double)(y + maskTop), (double)zLevel).func_225583_a_(uMaxLocal, vMin).func_181675_d();
                vertexBuffer.func_225582_a_((double)x, (double)(y + maskTop), (double)zLevel).func_225583_a_(uMin, vMin).func_181675_d();
            }
        }
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }
}

