/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiTeleporterStatus;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiSetFrequency;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiTeleporter
extends GuiMekanismTile<TileEntityTeleporter, MekanismTileContainer<TileEntityTeleporter>> {
    private MekanismButton publicButton;
    private MekanismButton privateButton;
    private MekanismButton setButton;
    private MekanismButton deleteButton;
    private GuiTextScrollList scrollList;
    private TextFieldWidget frequencyField;
    private boolean privateMode;

    public GuiTeleporter(MekanismTileContainer<TileEntityTeleporter> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        if (((TileEntityTeleporter)this.tile).frequency != null) {
            this.privateMode = !((TileEntityTeleporter)this.tile).frequency.publicFreq;
        }
        this.field_147000_g += 64;
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 48, 102, 89, 13));
        this.addButton(new GuiInnerScreen(this, 136, 102, 13, 13));
        this.addButton(new GuiTeleporterStatus(this, () -> ((TileEntityTeleporter)this.tile).frequency != null, () -> ((TileEntityTeleporter)this.tile).status));
        this.addButton(new GuiRedstoneControl(this, this.tile));
        this.addButton(new GuiUpgradeTab(this, this.tile));
        this.addButton(new GuiSecurityTab<TileEntityMekanism>((IGuiWrapper)this, this.tile));
        this.addButton(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityTeleporter)this.tile).getEnergyContainer(), 158, 26));
        this.scrollList = new GuiTextScrollList(this, 27, 36, 122, 42);
        this.addButton(this.scrollList);
        this.publicButton = new TranslationButton(this, this.getGuiLeft() + 27, this.getGuiTop() + 14, 60, 20, MekanismLang.PUBLIC, () -> {
            this.privateMode = false;
            this.updateButtons();
        });
        this.addButton(this.publicButton);
        this.privateButton = new TranslationButton(this, this.getGuiLeft() + 89, this.getGuiTop() + 14, 60, 20, MekanismLang.PRIVATE, () -> {
            this.privateMode = true;
            this.updateButtons();
        });
        this.addButton(this.privateButton);
        this.setButton = new TranslationButton(this, this.getGuiLeft() + 27, this.getGuiTop() + 116, 60, 20, MekanismLang.BUTTON_SET, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? ((TileEntityTeleporter)this.tile).privateCache.get(selection) : ((TileEntityTeleporter)this.tile).publicCache.get(selection);
                this.setFrequency(freq.name);
            }
            this.updateButtons();
        });
        this.addButton(this.setButton);
        this.deleteButton = new TranslationButton(this, this.getGuiLeft() + 89, this.getGuiTop() + 116, 60, 20, MekanismLang.BUTTON_DELETE, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? ((TileEntityTeleporter)this.tile).privateCache.get(selection) : ((TileEntityTeleporter)this.tile).publicCache.get(selection);
                Mekanism.packetHandler.sendToServer(new PacketGuiSetFrequency(((TileEntityTeleporter)this.tile).func_174877_v(), false, freq.name, freq.publicFreq));
                this.scrollList.clearSelection();
            }
            this.updateButtons();
        });
        this.addButton(this.deleteButton);
        this.frequencyField = new TextFieldWidget(this.font, this.getGuiLeft() + 50, this.getGuiTop() + 104, 86, 11, "");
        this.addButton((Widget)this.frequencyField);
        this.frequencyField.func_146203_f(16);
        this.frequencyField.func_146185_a(false);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 137, this.getGuiTop() + 103, 11, 12, this.getButtonLocation("checkmark"), () -> {
            this.setFrequency(this.frequencyField.func_146179_b());
            this.frequencyField.func_146180_a("");
            this.updateButtons();
        }));
        this.updateButtons();
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String s = this.frequencyField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.frequencyField.func_146180_a(s);
    }

    public ITextComponent getSecurity(Frequency freq) {
        if (freq.publicFreq) {
            return MekanismLang.PUBLIC.translate(new Object[0]);
        }
        return MekanismLang.PRIVATE.translateColored(EnumColor.DARK_RED, new Object[0]);
    }

    private void updateButtons() {
        if (this.getOwner() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency freq : ((TileEntityTeleporter)this.tile).privateCache) {
                text.add(freq.name);
            }
        } else {
            for (Frequency freq : ((TileEntityTeleporter)this.tile).publicCache) {
                text.add(MekanismLang.GENERIC_WITH_PARENTHESIS.translate(freq.name, freq.clientOwner).func_150254_d());
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.active = true;
            this.privateButton.active = false;
        } else {
            this.publicButton.active = false;
            this.privateButton.active = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? ((TileEntityTeleporter)this.tile).privateCache.get(this.scrollList.getSelection()) : ((TileEntityTeleporter)this.tile).publicCache.get(this.scrollList.getSelection());
            this.setButton.active = ((TileEntityTeleporter)this.tile).frequency == null || !((TileEntityTeleporter)this.tile).frequency.equals(freq);
            this.deleteButton.active = this.getOwner().equals(freq.ownerUUID);
        } else {
            this.setButton.active = false;
            this.deleteButton.active = false;
        }
    }

    public void tick() {
        super.tick();
        this.updateButtons();
        this.frequencyField.func_146178_a();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateButtons();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.frequencyField.func_212955_f()) {
            if (keyCode == 256) {
                this.frequencyField.func_146195_b(false);
                return true;
            }
            if (keyCode == 257) {
                this.setFrequency(this.frequencyField.func_146179_b());
                this.frequencyField.func_146180_a("");
                return true;
            }
            return this.frequencyField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        if (this.frequencyField.func_212955_f()) {
            if (Character.isDigit(c) || Character.isLetter(c) || FrequencyManager.SPECIAL_CHARS.contains(Character.valueOf(c))) {
                return this.frequencyField.charTyped(c, keyCode);
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString(((TileEntityTeleporter)this.tile).getName(), this.getXSize() / 2 - this.getStringWidth(((TileEntityTeleporter)this.tile).getName()) / 2, 4, 0x404040);
        this.drawString(OwnerDisplay.of(this.getOwner(), ((TileEntityTeleporter)this.tile).getSecurity().getClientOwner()).getTextComponent(), 8, this.getYSize() - 92, 0x404040);
        TranslationTextComponent frequencyComponent = MekanismLang.FREQUENCY.translate(new Object[0]);
        this.drawString((ITextComponent)frequencyComponent, 32, 81, 0x404040);
        TranslationTextComponent securityComponent = MekanismLang.SECURITY.translate("");
        this.drawString((ITextComponent)securityComponent, 32, 91, 0x404040);
        int frequencyOffset = this.getStringWidth((ITextComponent)frequencyComponent) + 1;
        if (((TileEntityTeleporter)this.tile).frequency != null) {
            this.renderScaledText(((TileEntityTeleporter)this.tile).frequency.name, 32 + frequencyOffset, 81, 0x797979, this.field_146999_f - 32 - frequencyOffset - 4);
            this.drawString(this.getSecurity(((TileEntityTeleporter)this.tile).frequency), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, 0x797979);
        } else {
            this.drawString(MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + frequencyOffset, 81, 0x797979);
            this.drawString(MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, 0x797979);
        }
        this.renderScaledText((ITextComponent)MekanismLang.SET.translate(new Object[0]), 27, 104, 0x404040, 20);
        super.func_146979_b(mouseX, mouseY);
    }

    private UUID getOwner() {
        return ((TileEntityTeleporter)this.tile).getSecurity().getOwnerUUID();
    }

    public void setFrequency(String freq) {
        if (!freq.isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiSetFrequency(((TileEntityTeleporter)this.tile).func_174877_v(), true, freq, !this.privateMode));
        }
    }
}

