/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.SideDataButton;
import mekanism.client.gui.element.tab.GuiConfigTypeTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public class GuiSideConfiguration
extends GuiMekanismTile<TileEntityMekanism, EmptyTileContainer<TileEntityMekanism>> {
    private List<GuiPos> slotPosList = new ArrayList<GuiPos>();
    private TransmissionType currentType;
    private List<GuiConfigTypeTab> configTabs = new ArrayList<GuiConfigTypeTab>();

    public GuiSideConfiguration(EmptyTileContainer<TileEntityMekanism> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g = 95;
        this.currentType = this.getTopTransmission();
        this.slotPosList.add(new GuiPos(RelativeSide.BOTTOM, 81, 64));
        this.slotPosList.add(new GuiPos(RelativeSide.TOP, 81, 34));
        this.slotPosList.add(new GuiPos(RelativeSide.FRONT, 81, 49));
        this.slotPosList.add(new GuiPos(RelativeSide.BACK, 66, 64));
        this.slotPosList.add(new GuiPos(RelativeSide.LEFT, 66, 49));
        this.slotPosList.add(new GuiPos(RelativeSide.RIGHT, 96, 49));
    }

    public <TILE extends TileEntityMekanism> TILE getTile() {
        return (TILE)this.tile;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 51, 15, 74, 12));
        this.addButton(new GuiInnerScreen(this, 80, 33, 16, 16));
        this.addButton(new GuiInnerScreen(this, 65, 48, 16, 16));
        this.addButton(new GuiInnerScreen(this, 95, 48, 16, 16));
        this.addButton(new GuiInnerScreen(this, 80, 63, 16, 16));
        this.addButton(new GuiInnerScreen(this, 65, 63, 16, 16));
        List<TransmissionType> transmissions = ((ISideConfiguration)this.getTile()).getConfig().getTransmissions();
        for (int i = 0; i < transmissions.size(); ++i) {
            TransmissionType type = transmissions.get(i);
            GuiConfigTypeTab tab = new GuiConfigTypeTab((IGuiWrapper)this, type, i < 3 ? -26 : 176, 2 + 28 * (i % 3));
            this.addButton(tab);
            this.configTabs.add(tab);
        }
        this.updateTabs();
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 6, this.getGuiTop() + 6, 14, this.getButtonLocation("back"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON, this.tile))));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 156, this.getGuiTop() + 6, 14, this.getButtonLocation("auto_eject"), () -> Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate(this.tile.func_174877_v(), this.currentType)), this.getOnHover(MekanismLang.AUTO_EJECT)));
        for (GuiPos guiPos : this.slotPosList) {
            this.addButton(new SideDataButton(this, this.getGuiLeft() + guiPos.xPos, this.getGuiTop() + guiPos.yPos, guiPos.relativeSide, () -> ((ISideConfiguration)this.getTile()).getConfig().getDataType(this.currentType, guiPos.relativeSide), () -> {
                DataType dataType = ((ISideConfiguration)this.getTile()).getConfig().getDataType(this.currentType, guiPos.relativeSide);
                return dataType == null ? EnumColor.GRAY : dataType.getColor();
            }, this.tile, () -> this.currentType, PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, this.getOnHover()));
        }
    }

    private GuiElement.IHoverable getOnHover() {
        return (onHover, xAxis, yAxis) -> {
            DataType dataType;
            if (onHover instanceof SideDataButton && (dataType = ((SideDataButton)onHover).getDataType()) != null) {
                this.displayTooltip(MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(dataType.getColor(), dataType, dataType.getColor().getName()), xAxis, yAxis);
            }
        };
    }

    public TransmissionType getTopTransmission() {
        return ((ISideConfiguration)this.getTile()).getConfig().getTransmissions().get(0);
    }

    public void setCurrentType(TransmissionType type) {
        this.currentType = type;
    }

    public void updateTabs() {
        for (GuiConfigTypeTab tab : this.configTabs) {
            tab.visible = this.currentType != tab.getTransmissionType();
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText((ITextComponent)MekanismLang.CONFIG_TYPE.translate(this.currentType), 0, this.getXSize(), 5, 0x404040);
        ConfigInfo config = ((ISideConfiguration)this.getTile()).getConfig().getConfig(this.currentType);
        if (config == null || !config.canEject()) {
            this.drawString((ITextComponent)MekanismLang.NO_EJECT.translate(new Object[0]), 53, 17, 52480);
        } else {
            this.drawString((ITextComponent)MekanismLang.EJECT.translate(BooleanStateDisplay.OnOff.of(config.isEjecting())), 53, 17, 52480);
        }
        this.drawString((ITextComponent)MekanismLang.SLOTS.translate(new Object[0]), 77, 81, 0x787878);
        super.func_146979_b(mouseX, mouseY);
    }

    public void tick() {
        super.tick();
        if (this.tile == null || MekanismUtils.getTileEntity((IBlockReader)this.minecraft.field_71441_e, this.tile.func_174877_v()) == null) {
            this.minecraft.func_147108_a(null);
        }
    }

    public static class GuiPos {
        public final RelativeSide relativeSide;
        public final int xPos;
        public final int yPos;

        public GuiPos(RelativeSide side, int x, int y) {
            this.relativeSide = side;
            this.xPos = x;
            this.yPos = y;
        }
    }
}

