/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.IRegistryDelegate;

public abstract class ChemicalStack<CHEMICAL extends Chemical<CHEMICAL>>
implements IHasTextComponent,
IHasTranslationKey {
    private boolean isEmpty;
    private long amount;
    @Nonnull
    private IRegistryDelegate<CHEMICAL> chemicalDelegate;

    protected ChemicalStack(@Nonnull CHEMICAL chemical, long amount) {
        this.chemicalDelegate = this.getDelegate(chemical);
        this.amount = amount;
        this.updateEmpty();
    }

    @Nonnull
    protected abstract IRegistryDelegate<CHEMICAL> getDelegate(CHEMICAL var1);

    @Nonnull
    protected abstract CHEMICAL getEmptyChemical();

    @Nonnull
    public abstract ChemicalStack<CHEMICAL> copy();

    @Nonnull
    public final CHEMICAL getType() {
        return this.isEmpty ? this.getEmptyChemical() : this.getRaw();
    }

    public boolean isTypeEqual(@Nonnull ChemicalStack<CHEMICAL> stack) {
        return this.isTypeEqual(stack.getType());
    }

    public boolean isTypeEqual(@Nonnull CHEMICAL chemical) {
        return this.getType() == chemical;
    }

    @Nonnull
    public ResourceLocation getTypeRegistryName() {
        return this.getType().getRegistryName();
    }

    public int getChemicalTint() {
        return ((Chemical)this.getType()).getTint();
    }

    @Nonnull
    public final CHEMICAL getRaw() {
        return (CHEMICAL)((Chemical)this.chemicalDelegate.get());
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    protected void updateEmpty() {
        this.isEmpty = ((Chemical)this.getRaw()).isEmptyType() || this.amount <= 0L;
    }

    public long getAmount() {
        return this.isEmpty ? 0L : this.amount;
    }

    public void setAmount(long amount) {
        if (((Chemical)this.getRaw()).isEmptyType()) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        this.amount = amount;
        this.updateEmpty();
    }

    public void grow(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.amount - amount);
    }

    public boolean has(Class<? extends ChemicalAttribute> type) {
        return ((Chemical)this.getType()).has(type);
    }

    @Nullable
    public <T extends ChemicalAttribute> T get(Class<T> type) {
        return ((Chemical)this.getType()).get(type);
    }

    public Collection<ChemicalAttribute> getAttributes() {
        return ((Chemical)this.getType()).getAttributes();
    }

    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return ((Chemical)this.getType()).getAttributeTypes();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.getType().hashCode();
        code = 31 * code + Long.hashCode(this.getAmount());
        return code;
    }

    public abstract boolean equals(Object var1);

    public String toString() {
        return "[" + this.getType() + ", " + this.amount + "]";
    }

    @Override
    public ITextComponent getTextComponent() {
        return ((Chemical)this.getType()).getTextComponent();
    }

    @Override
    public String getTranslationKey() {
        return ((Chemical)this.getType()).getTranslationKey();
    }

    public boolean contains(@Nonnull ChemicalStack<CHEMICAL> other) {
        return this.isTypeEqual((CHEMICAL)other) && this.amount >= other.amount;
    }

    public boolean isStackIdentical(@Nonnull ChemicalStack<CHEMICAL> other) {
        return this.isTypeEqual((CHEMICAL)other) && this.amount == other.amount;
    }

    public CompoundNBT write(CompoundNBT nbtTags) {
        ((Chemical)this.getType()).write(nbtTags);
        nbtTags.func_74772_a("amount", this.getAmount());
        return nbtTags;
    }

    public void writeToPacket(PacketBuffer buf) {
        buf.writeRegistryId(this.getType());
        buf.func_179254_b(this.getAmount());
    }
}

