/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.common.model.TransformationHelper;

public class TRSRBakedModel
implements IBakedModel {
    protected final IBakedModel original;
    protected TransformationMatrix transformation;
    private final int faceOffset;

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float scale) {
        this(original, x, y, z, 0.0f, 0.0f, 0.0f, scale, scale, scale);
    }

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scale) {
        this(original, x, y, z, rotX, rotY, rotZ, scale, scale, scale);
    }

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ) {
        this(original, new TransformationMatrix(new Vector3f(x, y, z), null, new Vector3f(scaleX, scaleY, scaleZ), TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(rotX, rotY, rotZ), (boolean)true)));
    }

    public TRSRBakedModel(IBakedModel original, TransformationMatrix transform) {
        this.original = original;
        this.transformation = transform;
        this.faceOffset = 0;
    }

    public TRSRBakedModel(IBakedModel original, Direction facing) {
        this(original, facing, null);
    }

    public TRSRBakedModel(IBakedModel original, Direction facing, @Nullable Vector3f translation) {
        this.original = original;
        double r = Math.PI * (double)(360 - facing.func_176734_d().func_176736_b() * 90) / 180.0;
        this.transformation = new TransformationMatrix(translation, TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, (float)r, 0.0f), (boolean)false), null, null);
        this.faceOffset = 4 + Direction.NORTH.func_176736_b() - facing.func_176736_b();
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        ImmutableList.Builder quads = ImmutableList.builder();
        if (side != null && side.func_176736_b() > -1) {
            side = Direction.func_176731_b((int)((side.func_176736_b() + this.faceOffset) % 4));
        }
        for (BakedQuad quad : this.original.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE)) {
            BakedQuadBuilder builder = new BakedQuadBuilder(quad.func_187508_a());
            TRSRTransformer transformer = new TRSRTransformer((IVertexConsumer)builder, this.transformation.blockCenterToCorner());
            quad.pipe((IVertexConsumer)transformer);
            quads.add((Object)builder.build());
        }
        return quads.build();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.original.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.original.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.original.func_188617_f();
    }
}

