/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot.affix;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;
import shadows.apotheosis.deadly.loot.affix.Affixes;

public class AffixEvents {
    public static final List<ItemStack> NUGGETS = new ArrayList<ItemStack>();

    @SubscribeEvent
    public void crit(CriticalHitEvent e) {
        Map<Affix, Float> affixes = AffixHelper.getAffixes(e.getPlayer().func_184614_ca());
        if (!e.isVanillaCritical() && affixes.containsKey((Object)Affixes.ALWAYS_CRIT)) {
            e.setResult(Event.Result.ALLOW);
        }
        if (affixes.containsKey((Object)Affixes.CRIT_DAMAGE)) {
            e.setDamageModifier(affixes.get((Object)Affixes.CRIT_DAMAGE).floatValue() + e.getDamageModifier());
        }
    }

    @SubscribeEvent
    public void harvest(BlockEvent.HarvestDropsEvent e) {
        if (e.getHarvester() == null) {
            return;
        }
        ItemStack stack = e.getHarvester().func_184614_ca();
        if (stack.func_190926_b() || !stack.func_77942_o() || !AffixEvents.isEffective(stack, e.getState())) {
            return;
        }
        Map<Affix, Float> affixes = AffixHelper.getAffixes(stack);
        if (affixes.containsKey((Object)Affixes.SIFTING) && e.getWorld().func_201674_k().nextFloat() <= affixes.get((Object)Affixes.SIFTING).floatValue()) {
            e.getDrops().add(NUGGETS.get(e.getWorld().func_201674_k().nextInt(NUGGETS.size())).func_77946_l());
        }
    }

    private static boolean isEffective(ItemStack stack, BlockState state) {
        for (ToolType s : stack.func_77973_b().getToolTypes(stack)) {
            if (!state.func_177230_c().isToolEffective(state, s)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent e) {
        Map<Affix, Float> affixes;
        PlayerEntity player = e.player;
        if (e.phase == TickEvent.Phase.END) {
            return;
        }
        ItemStack active = player.func_184607_cu();
        if (active.func_77973_b().isShield(active, (LivingEntity)player) && active.func_77942_o() && (affixes = AffixHelper.getAffixes(active)).containsKey((Object)Affixes.RESISTANCE)) {
            player.func_195064_c(new EffectInstance(Effects.field_76429_m, (int)(affixes.get((Object)Affixes.RESISTANCE).floatValue() * 20.0f)));
        }
    }

    static {
        NUGGETS.add(new ItemStack((IItemProvider)Items.field_151074_bl));
        NUGGETS.add(new ItemStack((IItemProvider)Items.field_191525_da));
    }
}

