/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import org.apache.commons.lang3.tuple.Pair;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.BossItem;
import shadows.apotheosis.deadly.gen.WorldFeature;
import shadows.apotheosis.deadly.gen.WorldGenerator;

public class BossFeature
extends WorldFeature {
    public static final List<BossItem> BOSS_ITEMS = new ArrayList<BossItem>();

    @Override
    public boolean generate(IWorld world, int chunkX, int chunkZ, Random rand) {
        int y;
        if ((double)DeadlyConfig.bossChance <= rand.nextDouble()) {
            return false;
        }
        int x = (chunkX << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        int z = (chunkZ << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        BlockPos.Mutable mPos = new BlockPos.Mutable(x, y, z);
        BossItem item = (BossItem)WeightedRandom.func_76271_a((Random)rand, BOSS_ITEMS);
        for (y = 15 + rand.nextInt(35); y > 10; --y) {
            if (!Block.func_220055_a((IWorldReader)world, (BlockPos)mPos.func_181079_c(x, y, z), (Direction)Direction.UP) || !world.func_226664_a_(item.getAABB(world).func_186670_a((BlockPos)mPos.func_181079_c(x, y + 1, z)))) continue;
            item.place(world, (BlockPos)mPos, rand);
            WorldGenerator.setSuccess(world.func_201675_m().func_186058_p().getRegistryName(), chunkX, chunkZ);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBePlaced(IWorld world, BlockPos pos, Random rand) {
        return false;
    }

    @Override
    public void place(IWorld world, BlockPos pos, Random rand) {
    }

    public static void init() {
        for (Pair<Integer, ResourceLocation> pair : DeadlyConfig.BOSS_MOBS) {
            BossItem i = new BossItem((Integer)pair.getLeft(), (ResourceLocation)pair.getRight());
            BOSS_ITEMS.add(i);
        }
    }

    @Override
    public boolean isEnabled() {
        return !BOSS_ITEMS.isEmpty() && DeadlyConfig.bossChance > 0.0f;
    }
}

