/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tiles;

import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;

public class TemplateManagerTileEntity
extends TileEntity
implements INamedContainerProvider {
    @ObjectHolder(value="buildinggadgets:template_manager_tile")
    public static TileEntityType<TemplateManagerTileEntity> TYPE;
    public static final Tag<Item> TEMPLATE_CONVERTIBLES;
    public static final int SIZE = 2;
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TemplateManagerTileEntity.this.func_70296_d();
        }

        private boolean isTemplateStack(ItemStack stack) {
            return stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).isPresent();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 && this.isTemplateStack(stack) || slot == 1 && (this.isTemplateStack(stack) || stack.func_77973_b().func_206844_a(TEMPLATE_CONVERTIBLES));
        }
    };
    private LazyOptional<IItemHandler> handlerOpt;

    public TemplateManagerTileEntity() {
        super(TYPE);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Template Manager GUI");
    }

    @Nullable
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerEntity) {
        Preconditions.checkArgument((this.func_145831_w() != null ? 1 : 0) != 0);
        return new TemplateManagerContainer(windowId, playerInventory, this);
    }

    public void onLoad() {
        this.onChunkUnloaded();
        this.handlerOpt = LazyOptional.of(() -> this.itemStackHandler);
    }

    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT(compound.func_74775_l("items"));
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("items", (INBT)this.itemStackHandler.serializeNBT());
        return super.func_189515_b(compound);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canInteractWith(PlayerEntity playerIn) {
        if (this.func_145837_r()) return false;
        Vec3d vec3d = new Vec3d((Vec3i)this.field_174879_c);
        if (!(playerIn.func_195048_a(vec3d.func_72441_c(0.5, 0.5, 0.5)) <= 64.0)) return false;
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.handlerOpt != null) {
            return this.handlerOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onChunkUnloaded() {
        if (this.handlerOpt != null) {
            this.handlerOpt.invalidate();
            this.handlerOpt = null;
        }
    }

    static {
        TEMPLATE_CONVERTIBLES = new ItemTags.Wrapper(Reference.ItemReference.TAG_TEMPLATE_CONVERTIBLE);
    }
}

