/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import wile.engineerstools.items.ItemTools;

public class ItemSleepingBag
extends ItemTools {
    private final boolean respawn_at_bed = false;

    public ItemSleepingBag(Item.Properties properties) {
        super(properties.func_200917_a(1).func_200915_b(4096).setNoRepair());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a()).isBed((IBlockReader)context.func_195991_k(), context.func_195995_a(), (LivingEntity)context.func_195999_j())) {
            return ActionResultType.PASS;
        }
        this.onUse(context.func_195999_j(), context.func_195991_k(), context.func_195995_a(), context.func_196000_l());
        return ActionResultType.SUCCESS;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected || world.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        CompoundNBT nbt = player.getPersistentData();
        if (!nbt.func_74764_b("ETCorrectBedLocation")) {
            return;
        }
        nbt.func_82580_o("ETCorrectBedLocation");
        BlockPos pos = null;
        DimensionType dim = null;
        if (nbt.func_74764_b("ETOriginalBedLocation")) {
            pos = BlockPos.func_218283_e((long)nbt.func_74763_f("ETOriginalBedLocation"));
            nbt.func_82580_o("ETOriginalBedLocation");
        }
        if (nbt.func_74764_b("ETOriginalBedDimension")) {
            dim = DimensionType.func_186069_a((int)nbt.func_74762_e("ETOriginalBedDimension"));
            nbt.func_82580_o("ETOriginalBedDimension");
        }
        if (pos == null || dim != player.field_71093_bK || dim == null) {
            return;
        }
        ((Object)((Object)((ItemSleepingBag)player.func_184586_b(Hand.MAIN_HAND).func_77973_b()))).getClass();
        player.setSpawnPoint(pos, true, false, dim);
    }

    private void onUse(PlayerEntity player, World world, BlockPos pos, Direction side) {
        if (side != Direction.UP) {
            return;
        }
        this.tryPlayerSleep(player, world, pos.func_177984_a()).ifLeft(sr -> {
            switch (sr) {
                case TOO_FAR_AWAY: {
                    break;
                }
                default: {
                    player.func_146105_b(sr.func_221259_a(), true);
                }
            }
        });
    }

    private Either<PlayerEntity.SleepResult, Unit> tryPlayerSleep(PlayerEntity player, World world, BlockPos at) {
        PlayerEntity.SleepResult ret;
        BlockPos bl = player.getBedLocation(player.field_71093_bK);
        DimensionType dim = player.field_71093_bK;
        Optional<BlockPos> optAt = Optional.of(at);
        if (!world.func_201670_d() && (ret = ForgeEventFactory.onPlayerSleepInBed((PlayerEntity)player, optAt)) != null) {
            return Either.left((Object)ret);
        }
        if (!world.field_72995_K) {
            if (player.func_70608_bn() || !player.func_70089_S()) {
                return Either.left((Object)PlayerEntity.SleepResult.OTHER_PROBLEM);
            }
            if (!world.field_73011_w.func_76569_d()) {
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_HERE);
            }
            if (!ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)player, optAt)) {
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
            }
            if (!player.func_184812_l_() && !world.func_175647_a(MonsterEntity.class, new AxisAlignedBB((double)(at.func_177958_n() - 8), (double)(at.func_177956_o() - 5), (double)(at.func_177952_p() - 8), (double)(at.func_177958_n() + 8), (double)(at.func_177956_o() + 5), (double)(at.func_177952_p() + 8)), e -> e.func_191990_c(player)).isEmpty()) {
                return Either.left((Object)PlayerEntity.SleepResult.NOT_SAFE);
            }
            CompoundNBT nbt = player.getPersistentData();
            nbt.func_74777_a("SleepTimer", (short)0);
            if (bl != null) {
                nbt.func_74772_a("ETOriginalBedLocation", bl.func_218275_a());
                nbt.func_74768_a("ETOriginalBedDimension", dim.func_186068_a());
            }
            player.func_213342_e(at);
            if (bl != null) {
                // empty if block
            }
            if (world instanceof ServerWorld) {
                ((ServerWorld)world).func_72854_c();
            }
        }
        return Either.right((Object)Unit.INSTANCE);
    }

    public static void onSleepingLocationCheckEvent(SleepingLocationCheckEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (player.field_70170_p.field_72995_K || !(player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof ItemSleepingBag)) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
    }

    public static void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (player.field_70170_p.field_72995_K || !(player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof ItemSleepingBag)) {
            return;
        }
        CompoundNBT nbt = player.getPersistentData();
        nbt.func_74768_a("ETCorrectBedLocation", 1);
    }
}

