/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.blocks.BlockAriadneCoal;
import wile.engineerstools.items.ItemAriadneCoal;
import wile.engineerstools.items.ItemCrushingHammer;
import wile.engineerstools.items.ItemDivingCapsule;
import wile.engineerstools.items.ItemMusliBar;
import wile.engineerstools.items.ItemMusliBarPress;
import wile.engineerstools.items.ItemRediaTool;
import wile.engineerstools.items.ItemSleepingBag;
import wile.engineerstools.items.ItemStimPack;
import wile.engineerstools.items.ItemTools;
import wile.engineerstools.items.ModBlockItem;

public class ModContent {
    private static final Logger LOGGER = ModEngineersTools.LOGGER;
    private static final String MODID = "engineerstools";
    private static final Block.Properties coal_properties = Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(3.0f, 50.0f).func_200947_a(SoundType.field_185851_d).func_200942_a().func_222380_e();
    public static final BlockAriadneCoal ARIADNE_COAL_X = (BlockAriadneCoal)new BlockAriadneCoal(coal_properties, Direction.Axis.X).setRegistryName(new ResourceLocation("engineerstools", "ariadne_coal_x"));
    public static final BlockAriadneCoal ARIADNE_COAL_Y = (BlockAriadneCoal)new BlockAriadneCoal(coal_properties, Direction.Axis.Y).setRegistryName(new ResourceLocation("engineerstools", "ariadne_coal_y"));
    public static final BlockAriadneCoal ARIADNE_COAL_Z = (BlockAriadneCoal)new BlockAriadneCoal(coal_properties, Direction.Axis.Z).setRegistryName(new ResourceLocation("engineerstools", "ariadne_coal_z"));
    private static final ArrayList<Block> modBlocks = new ArrayList();
    private static final TileEntityType<?>[] tile_entity_types;
    public static final ItemRediaTool REDIA_TOOL;
    public static final ItemCrushingHammer CRUSHING_HAMMER;
    public static final ItemAriadneCoal ARIADNE_COAL;
    public static final ItemStimPack STIM_PACK;
    public static final ItemDivingCapsule DIVING_CAPSULE;
    public static final ItemSleepingBag SLEEPING_BAG;
    public static final ItemTools IRON_GRIT;
    public static final ItemTools GOLD_GRIT;
    public static final ItemMusliBar MUSLI_BAR;
    public static final ItemMusliBarPress MUSLI_BAR_PRESS;
    private static final Item[] modItems;
    public static final ContainerType<ItemMusliBarPress.MusliBarPressContainer> CT_MUSLI_BAR_PRESS;
    private static final ContainerType<?>[] CONTAINER_TYPES;
    private static final ArrayList<Block> registeredBlocks;
    private static final ArrayList<Item> registeredItems;

    private static Item.Properties default_item_properties() {
        return new Item.Properties().func_200916_a(ModEngineersTools.ITEMGROUP);
    }

    private static <T extends Container> ContainerType<T> register(ContainerType.IFactory<T> factory, String regname) {
        ContainerType container_type = new ContainerType(factory);
        container_type.setRegistryName(new ResourceLocation(MODID, regname));
        return container_type;
    }

    public static ArrayList<Block> allBlocks() {
        return registeredBlocks;
    }

    @Nonnull
    public static List<Block> getRegisteredBlocks() {
        return Collections.unmodifiableList(registeredBlocks);
    }

    @Nonnull
    public static List<Item> getRegisteredItems() {
        return Collections.unmodifiableList(registeredItems);
    }

    public static final void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block e : registeredBlocks) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
        LOGGER.info("Registered " + Integer.toString(registeredBlocks.size()) + " blocks.");
    }

    public static final void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        for (TileEntityType<?> e : tile_entity_types) {
            event.getRegistry().register(e);
        }
        LOGGER.info("Registered " + Integer.toString(tile_entity_types.length) + " tile entities.");
    }

    public static final void registerItems(RegistryEvent.Register<Item> event) {
        for (Item e : registeredItems) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
        LOGGER.info("Registered " + Integer.toString(registeredItems.size()) + " items.");
    }

    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        for (ContainerType<?> e : CONTAINER_TYPES) {
            event.getRegistry().register(e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerGuis(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(CT_MUSLI_BAR_PRESS, ItemMusliBarPress.MusliBarPressGui::new);
    }

    public static final void processRegisteredContent() {
    }

    public static final void processContentClientSide() {
        for (Block block : ModContent.getRegisteredBlocks()) {
            if (!(block instanceof BlockAriadneCoal)) continue;
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228645_f_());
        }
    }

    static {
        modBlocks.add(ARIADNE_COAL_X);
        modBlocks.add(ARIADNE_COAL_Y);
        modBlocks.add(ARIADNE_COAL_Z);
        tile_entity_types = new TileEntityType[0];
        REDIA_TOOL = (ItemRediaTool)new ItemRediaTool(ModContent.default_item_properties()).setRegistryName(MODID, "redia_tool");
        CRUSHING_HAMMER = (ItemCrushingHammer)new ItemCrushingHammer(ModContent.default_item_properties()).setRegistryName(MODID, "crushing_hammer");
        ARIADNE_COAL = (ItemAriadneCoal)new ItemAriadneCoal(ModContent.default_item_properties()).setRegistryName(MODID, "ariadne_coal");
        STIM_PACK = (ItemStimPack)new ItemStimPack(ModContent.default_item_properties()).setRegistryName(MODID, "stimpack");
        DIVING_CAPSULE = (ItemDivingCapsule)new ItemDivingCapsule(ModContent.default_item_properties()).setRegistryName(MODID, "diving_capsule");
        SLEEPING_BAG = (ItemSleepingBag)new ItemSleepingBag(ModContent.default_item_properties()).setRegistryName(MODID, "sleeping_bag");
        IRON_GRIT = (ItemTools)new ItemTools(ModContent.default_item_properties()).setRegistryName(MODID, "iron_grit");
        GOLD_GRIT = (ItemTools)new ItemTools(ModContent.default_item_properties()).setRegistryName(MODID, "gold_grit");
        MUSLI_BAR = (ItemMusliBar)new ItemMusliBar(ModContent.default_item_properties()).setRegistryName(MODID, "musli_bar");
        MUSLI_BAR_PRESS = (ItemMusliBarPress)new ItemMusliBarPress(ModContent.default_item_properties()).setRegistryName(MODID, "musli_bar_press");
        modItems = new Item[]{REDIA_TOOL, CRUSHING_HAMMER, ARIADNE_COAL, STIM_PACK, SLEEPING_BAG, DIVING_CAPSULE, MUSLI_BAR_PRESS, MUSLI_BAR, IRON_GRIT, GOLD_GRIT};
        CT_MUSLI_BAR_PRESS = ModContent.register(ItemMusliBarPress.MusliBarPressContainer::new, "ct_musli_bar_press");
        CONTAINER_TYPES = new ContainerType[]{CT_MUSLI_BAR_PRESS};
        registeredBlocks = new ArrayList();
        registeredBlocks.addAll(modBlocks);
        registeredItems = new ArrayList();
        registeredItems.addAll(Arrays.asList(modItems));
        for (Block e : registeredBlocks) {
            registeredItems.add((Item)new ModBlockItem(e, new Item.Properties()).setRegistryName(e.getRegistryName()));
        }
    }
}

