/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.jei;

import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.block.ModBlocks;
import com.blakebr0.mysticalagriculture.compat.jei.InfusionCategory;
import com.blakebr0.mysticalagriculture.compat.jei.ReprocessorCategory;
import com.blakebr0.mysticalagriculture.item.ModItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JeiCompat
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("mysticalagriculture", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusionCategory(guiHelper), new ReprocessorCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.INFUSION_ALTAR.get()), new ResourceLocation[]{InfusionCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.INFUSION_PEDESTAL.get()), new ResourceLocation[]{InfusionCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BASIC_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.INFERIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PRUDENTIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.TERTIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.IMPERIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.SUPREMIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            RecipeManager manager = world.func_199532_z();
            registration.addRecipes(manager.func_215366_a(RecipeTypes.INFUSION).values(), InfusionCategory.UID);
            registration.addRecipes(manager.func_215366_a(RecipeTypes.REPROCESSOR).values(), ReprocessorCategory.UID);
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ModItems.SOUL_JAR.ifPresent(jar -> registration.registerSubtypeInterpreter(jar, stack -> {
            IMobSoulType type = MobSoulUtils.getType(stack);
            return type != null ? type.getEntityIds().toString() : "";
        }));
    }
}

