/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TillingAOEAugment
extends Augment {
    private static final Map<Block, BlockState> HOE_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_185774_da, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_196660_k, (Object)Blocks.field_150346_d.func_176223_P()));
    private final int range;

    public TillingAOEAugment(ResourceLocation id, int tier, int range) {
        super(id, tier, EnumSet.of(AugmentType.HOE), TillingAOEAugment.getColor(12158300, tier), TillingAOEAugment.getColor(5848361, tier));
        this.range = range;
    }

    @Override
    public boolean onItemUse(ItemUseContext context) {
        Hand hand;
        Direction direction;
        BlockPos pos;
        World world;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return false;
        }
        ItemStack stack = context.func_195996_i();
        if (!this.tryTill(stack, player, world = context.func_195991_k(), pos = context.func_195995_a(), direction = context.func_196000_l(), hand = context.func_221531_n()) && !player.func_213453_ef()) {
            return false;
        }
        if (player.func_213453_ef()) {
            BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-this.range, 0, -this.range), (BlockPos)pos.func_177982_a(this.range, 0, this.range)).forEach(aoePos -> this.tryTill(stack, player, world, (BlockPos)aoePos, direction, hand));
        }
        return true;
    }

    private boolean tryTill(ItemStack stack, PlayerEntity player, World world, BlockPos pos, Direction direction, Hand hand) {
        BlockState state;
        if (direction != Direction.DOWN && world.func_175623_d(pos.func_177984_a()) && (state = HOE_LOOKUP.get(world.func_180495_p(pos).func_177230_c())) != null) {
            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, state, 11);
                if (player != null) {
                    stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(hand));
                }
            }
            return true;
        }
        return false;
    }

    private static int getColor(int color, int tier) {
        return Utils.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

