/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.soul;

import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class MobSoulType
implements IMobSoulType {
    private final ResourceLocation id;
    private final Set<ResourceLocation> entityIds;
    private double soulRequirement;
    private int color;
    private String entityDisplayNameKey = null;
    private ITextComponent entityDisplayName = null;

    public MobSoulType(ResourceLocation id, ResourceLocation entityId, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = Collections.singleton(entityId);
        this.soulRequirement = soulRequirement;
        this.color = color;
    }

    public MobSoulType(ResourceLocation id, ResourceLocation entityId, String entityDisplayNameKey, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = Collections.singleton(entityId);
        this.soulRequirement = soulRequirement;
        this.entityDisplayNameKey = entityDisplayNameKey;
        this.color = color;
    }

    public MobSoulType(ResourceLocation id, Set<ResourceLocation> entityIds, String entityDisplayNameKey, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = entityIds;
        this.soulRequirement = soulRequirement;
        this.entityDisplayNameKey = entityDisplayNameKey;
        this.color = color;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Set<ResourceLocation> getEntityIds() {
        return this.entityIds;
    }

    @Override
    public double getSoulRequirement() {
        return this.soulRequirement;
    }

    @Override
    public void setSoulRequirement(double soulRequirement) {
        this.soulRequirement = soulRequirement;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public boolean isEntityApplicable(LivingEntity entity) {
        return this.entityIds.contains(entity.func_200600_R().getRegistryName());
    }

    @Override
    public ITextComponent getEntityDisplayName() {
        if (this.entityDisplayName == null) {
            if (this.entityDisplayNameKey != null) {
                this.entityDisplayName = new TranslationTextComponent(String.format("mobSoulType.%s.%s", this.getModId(), this.entityDisplayNameKey), new Object[0]);
            } else {
                EntityType entity;
                ResourceLocation entityId = this.entityIds.stream().findFirst().orElse(null);
                if (entityId != null && (entity = (EntityType)ForgeRegistries.ENTITIES.getValue(entityId)) != null) {
                    this.entityDisplayName = entity.func_212546_e();
                    return this.entityDisplayName;
                }
                this.entityDisplayName = new TranslationTextComponent("tooltip.mysticalagriculture.invalid_entity", new Object[0]);
            }
        }
        return this.entityDisplayName;
    }

    @Override
    public MobSoulType setEntityDisplayName(ITextComponent name) {
        this.entityDisplayName = name;
        return this;
    }
}

