/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.projection;

import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;

public class PowerConsolidationMahoujinTileEntity
extends MahoujinTileEntity
implements ITickableTileEntity {
    public static final String LAKED = "MAHOUTSUKAI_NUM_TIMES_LAKED";
    private int numTimesLaked = 0;
    private int tickCounter = 0;

    public PowerConsolidationMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.powerConsolidation);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a(LAKED, this.numTimesLaked);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.numTimesLaked = compound.func_74762_e(LAKED);
        super.func_145839_a(compound);
    }

    public void func_73660_a() {
        int radius = MTConfig.POWER_CONSOLIDATION_LAKE_RADIUS;
        int cycle = MTConfig.POWER_CONSOLIDATION_LAKE_CYCLE;
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickCounter == cycle) {
                if (this.numTimesLaked >= radius - 1) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                } else {
                    boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.field_174879_c, this.field_145850_b, this.getCasterUUID(), MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST);
                    if (nearbyBatteriesGaveMana || this.getCaster() != null && PlayerManaManager.drainMana(this.getCaster(), MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST, false, false) == MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST) {
                        this.createLake();
                        ++this.numTimesLaked;
                    }
                }
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public void createLake() {
        int r = this.numTimesLaked + 1;
        Stream lst = BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-r - 1, -r - 1, -r - 1), (BlockPos)this.field_174879_c.func_177982_a(r + 1, r + 1, r + 1));
        lst.forEach(p -> {
            if (p.func_218140_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), false) < (double)(r * r + 1) && p.func_177956_o() < this.field_174879_c.func_177956_o() && this.field_145850_b.func_175625_s(p) == null) {
                if ((double)(this.numTimesLaked * this.numTimesLaked) - p.func_218140_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), false) <= 1.0) {
                    EffectUtil.tryChangeBlockState(false, p, Blocks.field_150346_d.func_176223_P(), this.field_145850_b, this.getCaster());
                } else {
                    EffectUtil.tryChangeBlockState(false, p, ModBlocks.murkyFluid.func_176223_P(), this.field_145850_b, this.getCaster());
                }
            }
        });
    }
}

