/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.worldsave.MahouSavedData;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;

public class ContractMahoujinTileEntity
extends MahoujinTileEntity
implements ITickableTileEntity {
    private int tickCounter = 0;

    public ContractMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.contract);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            MahouSavedData save = new MahouSavedData(this.field_145850_b);
            if (this.tickCounter == MTConfig.CONTRACT_BLOCK_CYCLE) {
                PlayerEntity casterPresent;
                ArrayList<PlayerEntity> targets = this.getTargets();
                if (targets != null && !targets.isEmpty() && (casterPresent = this.entityReadyToContract()) != null) {
                    for (PlayerEntity entityIn : targets) {
                        if (PlayerManaManager.drainMana(casterPresent, MTConfig.CONTRACT_MANA_COST, false, false) != MTConfig.CONTRACT_MANA_COST || !save.addContractIfNotExists(casterPresent.func_110124_au(), entityIn.func_110124_au())) continue;
                        entityIn.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "A contract has been formed with " + casterPresent.func_145748_c_().getString()));
                        casterPresent.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "A contract has been formed with " + entityIn.func_145748_c_().getString()));
                    }
                }
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public ArrayList<PlayerEntity> getTargets() {
        int radius = MTConfig.CONTRACT_RADIUS;
        Stream blocks = BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-radius, -radius, -radius), (BlockPos)this.field_174879_c.func_177982_a(radius, radius, radius));
        ArrayList<PlayerEntity> ret = new ArrayList<PlayerEntity>();
        blocks.forEach(tmp -> {
            ContractMahoujinTileEntity mte;
            PlayerEntity player;
            TileEntity te = this.field_145850_b.func_175625_s(tmp);
            if (te instanceof ContractMahoujinTileEntity && !this.field_174879_c.equals(tmp) && (player = (mte = (ContractMahoujinTileEntity)te).entityReadyToContract()) != null && player.func_70089_S()) {
                ret.add(player);
            }
        });
        return ret;
    }

    public PlayerEntity entityReadyToContract() {
        List lst = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)));
        if (lst.isEmpty() || !lst.contains(this.getCaster())) {
            return null;
        }
        return this.getCaster();
    }

    public static boolean isImmuneToSpell(World world, UUID caster, Entity e) {
        UUID ownerId;
        MahouSavedData save = new MahouSavedData(world);
        if (e instanceof TameableEntity && caster != null && (ownerId = ((TameableEntity)e).func_184753_b()) != null && (ownerId.equals(caster) || save.doesContractExist(caster, ownerId))) {
            return true;
        }
        if (e instanceof PlayerEntity && caster != null) {
            if (e.func_110124_au().equals(caster)) {
                return true;
            }
            if (save.doesContractExist(caster, e.func_110124_au())) {
                return true;
            }
        }
        return false;
    }

    public static void breakContract(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (!player.field_70170_p.field_72995_K) {
                MahouSavedData save = new MahouSavedData(player.field_70170_p);
                if (event.getSource() != null && event.getSource().func_76346_g() != null && event.getSource().func_76346_g().func_110124_au() != null && save.doesContractExist(player.func_110124_au(), event.getSource().func_76346_g().func_110124_au())) {
                    player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "A contract has broken."));
                    event.getSource().func_76346_g().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "A contract has broken."));
                    save.removeContract(player.func_110124_au(), event.getSource().func_76346_g().func_110124_au());
                }
            }
        }
    }
}

