/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;

public class StatModifierMap
implements Multimap<ItemStat, StatInstance> {
    private final Multimap<ItemStat, StatInstance> map = ArrayListMultimap.create();

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public boolean containsEntry(Object key, Object value) {
        return this.map.containsEntry(key, value);
    }

    public boolean put(ItemStat key, StatInstance value) {
        for (StatInstance inst : this.map.get((Object)key)) {
            if (!inst.getId().equals(value.getId())) continue;
            return false;
        }
        return this.map.put((Object)key, (Object)value);
    }

    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    public boolean putAll(ItemStat key, @Nonnull Iterable<? extends StatInstance> values) {
        return this.map.putAll((Object)key, values);
    }

    public boolean putAll(@Nonnull Multimap<? extends ItemStat, ? extends StatInstance> multimap) {
        return this.map.putAll(multimap);
    }

    public Collection<StatInstance> replaceValues(ItemStat key, @Nonnull Iterable<? extends StatInstance> values) {
        return this.map.replaceValues((Object)key, values);
    }

    public Collection<StatInstance> removeAll(Object key) {
        return this.map.removeAll(key);
    }

    public void clear() {
        this.map.clear();
    }

    public Collection<StatInstance> get(ItemStat key) {
        return this.map.get((Object)key);
    }

    public Set<ItemStat> keySet() {
        return this.map.keySet();
    }

    public Multiset<ItemStat> keys() {
        return this.map.keys();
    }

    public Collection<StatInstance> values() {
        return this.map.values();
    }

    public Collection<Map.Entry<ItemStat, StatInstance>> entries() {
        return this.map.entries();
    }

    public Map<ItemStat, Collection<StatInstance>> asMap() {
        return this.map.asMap();
    }

    public static StatModifierMap read(PacketBuffer buffer) {
        StatModifierMap map = new StatModifierMap();
        int count = buffer.func_150792_a();
        for (int i = 0; i < count; ++i) {
            ItemStat stat = ItemStat.ALL_STATS.get(buffer.func_150789_c(255));
            StatInstance instance = StatInstance.read("p" + i, buffer);
            map.put(stat, instance);
        }
        return map;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.size());
        this.forEach((stat, instance) -> {
            buffer.func_180714_a(stat.name.func_110623_a());
            instance.write(buffer);
        });
    }
}

