/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import xreliquary.client.gui.components.Box;
import xreliquary.client.gui.components.Component;
import xreliquary.client.gui.components.ItemStackPane;
import xreliquary.init.ModItems;

public class HandgunPane
extends Component {
    private Box mainPane;
    private ItemStackPane[] bulletPanes = new ItemStackPane[8];
    private ItemStackPane magazinePane;
    private Hand hand;
    private int time = 0;

    public HandgunPane(Hand hand) {
        this.hand = hand;
        this.magazinePane = new ItemStackPane(ModItems.EMPTY_MAGAZINE);
        for (int i = 0; i < 8; ++i) {
            this.bulletPanes[i] = new ItemStackPane(ItemStack.field_190927_a){

                @Override
                public int getPadding() {
                    return -3;
                }
            };
        }
        Box bulletsPane = new Box(Box.Layout.HORIZONTAL, Box.Alignment.MIDDLE, (Component[])this.bulletPanes){

            @Override
            public int getPadding() {
                return 3;
            }
        };
        this.mainPane = hand == Hand.OFF_HAND ? Box.createHorizontal(Box.Alignment.MIDDLE, new ItemStackPane(ModItems.HANDGUN), this.magazinePane, bulletsPane) : Box.createHorizontal(Box.Alignment.MIDDLE, bulletsPane, this.magazinePane, new ItemStackPane(ModItems.HANDGUN));
    }

    @Override
    public int getHeightInternal() {
        return this.mainPane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return this.mainPane.getWidth();
    }

    @Override
    public int getHeight() {
        return this.holdsHandgun() ? super.getHeight() : 0;
    }

    @Override
    public boolean shouldRender() {
        return this.holdsHandgun();
    }

    private boolean holdsHandgun() {
        return Minecraft.func_71410_x().field_71439_g.func_184586_b(this.hand).func_77973_b() == ModItems.HANDGUN;
    }

    @Override
    public void renderInternal(int x, int y) {
        ItemStack handgun = Minecraft.func_71410_x().field_71439_g.func_184586_b(this.hand);
        if (handgun.func_190926_b()) {
            return;
        }
        ItemStack bullets = ModItems.HANDGUN.getBulletStack(handgun);
        for (int i = 0; i < 8; ++i) {
            if (i < bullets.func_190916_E()) {
                this.bulletPanes[i].setItemStack(bullets);
                continue;
            }
            this.bulletPanes[i].setItemStack(ItemStack.field_190927_a);
        }
        if (bullets.func_190926_b() && this.getTime() % 32 > 16) {
            this.magazinePane.setItem(ModItems.EMPTY_MAGAZINE);
        } else {
            this.magazinePane.setItemStack(ItemStack.field_190927_a);
        }
        this.mainPane.render(x, y);
    }

    private int getTime() {
        ++this.time;
        if (this.time > 31) {
            this.time = 0;
        }
        return this.time;
    }
}

